@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.PeeringAttachmentOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dynamicRouting Indicates whether dynamic routing is enabled or disabled.. Supports `enable` and `disable`.
 */
public data class PeeringAttachmentOptionsArgs(
    public val dynamicRouting: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.PeeringAttachmentOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.PeeringAttachmentOptionsArgs =
        com.pulumi.aws.ec2transitgateway.inputs.PeeringAttachmentOptionsArgs.builder()
            .dynamicRouting(dynamicRouting?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeeringAttachmentOptionsArgs].
 */
@PulumiTagMarker
public class PeeringAttachmentOptionsArgsBuilder internal constructor() {
    private var dynamicRouting: Output<String>? = null

    /**
     * @param value Indicates whether dynamic routing is enabled or disabled.. Supports `enable` and `disable`.
     */
    @JvmName("wcedjgkbfstmrrxh")
    public suspend fun dynamicRouting(`value`: Output<String>) {
        this.dynamicRouting = value
    }

    /**
     * @param value Indicates whether dynamic routing is enabled or disabled.. Supports `enable` and `disable`.
     */
    @JvmName("qfdwncimopxljchl")
    public suspend fun dynamicRouting(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicRouting = mapped
    }

    internal fun build(): PeeringAttachmentOptionsArgs = PeeringAttachmentOptionsArgs(
        dynamicRouting = dynamicRouting,
    )
}
