@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getAttachment.
 * @property arn ARN of the attachment.
 * @property associationState The state of the association (see [the underlying AWS API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayAttachmentAssociation.html) for valid values).
 * @property associationTransitGatewayRouteTableId The ID of the route table for the transit gateway.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property resourceId ID of the resource.
 * @property resourceOwnerId ID of the AWS account that owns the resource.
 * @property resourceType Resource type.
 * @property state Attachment state.
 * @property tags Key-value tags for the attachment.
 * @property transitGatewayAttachmentId
 * @property transitGatewayId ID of the transit gateway.
 * @property transitGatewayOwnerId The ID of the AWS account that owns the transit gateway.
 */
public data class GetAttachmentResult(
    public val arn: String,
    public val associationState: String,
    public val associationTransitGatewayRouteTableId: String,
    public val filters: List<GetAttachmentFilter>? = null,
    public val id: String,
    public val resourceId: String,
    public val resourceOwnerId: String,
    public val resourceType: String,
    public val state: String,
    public val tags: Map<String, String>,
    public val transitGatewayAttachmentId: String,
    public val transitGatewayId: String,
    public val transitGatewayOwnerId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetAttachmentResult): GetAttachmentResult = GetAttachmentResult(
            arn = javaType.arn(),
            associationState = javaType.associationState(),
            associationTransitGatewayRouteTableId = javaType.associationTransitGatewayRouteTableId(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetAttachmentFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            resourceId = javaType.resourceId(),
            resourceOwnerId = javaType.resourceOwnerId(),
            resourceType = javaType.resourceType(),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transitGatewayAttachmentId = javaType.transitGatewayAttachmentId(),
            transitGatewayId = javaType.transitGatewayId(),
            transitGatewayOwnerId = javaType.transitGatewayOwnerId(),
        )
    }
}
