@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Name of the filter field. Valid values can be found in the [EC2 DescribeTransitGatewayAttachments API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html).
 * @property values Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
 */
public data class GetDirectConnectGatewayAttachmentFilter(
    public val name: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetDirectConnectGatewayAttachmentFilter): GetDirectConnectGatewayAttachmentFilter = GetDirectConnectGatewayAttachmentFilter(
            name = javaType.name(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
