@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property subnetId The ID of the subnet associated with the transit gateway multicast domain.
 * @property transitGatewayAttachmentId The ID of the transit gateway attachment.
 */
public data class GetMulticastDomainAssociation(
    public val subnetId: String,
    public val transitGatewayAttachmentId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetMulticastDomainAssociation): GetMulticastDomainAssociation = GetMulticastDomainAssociation(
            subnetId = javaType.subnetId(),
            transitGatewayAttachmentId = javaType.transitGatewayAttachmentId(),
        )
    }
}
