@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property groupIpAddress The IP address assigned to the transit gateway multicast group.
 * @property networkInterfaceId The group members' network interface ID.
 */
public data class GetMulticastDomainSource(
    public val groupIpAddress: String,
    public val networkInterfaceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetMulticastDomainSource): GetMulticastDomainSource = GetMulticastDomainSource(
            groupIpAddress = javaType.groupIpAddress(),
            networkInterfaceId = javaType.networkInterfaceId(),
        )
    }
}
