@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRouteTableAssociations.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids Set of Transit Gateway Route Table Association identifiers.
 * @property transitGatewayRouteTableId
 */
public data class GetRouteTableAssociationsResult(
    public val filters: List<GetRouteTableAssociationsFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val transitGatewayRouteTableId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetRouteTableAssociationsResult): GetRouteTableAssociationsResult = GetRouteTableAssociationsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableAssociationsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            transitGatewayRouteTableId = javaType.transitGatewayRouteTableId(),
        )
    }
}
