@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRouteTablePropagations.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids Set of Transit Gateway Route Table Association identifiers.
 * @property transitGatewayRouteTableId
 */
public data class GetRouteTablePropagationsResult(
    public val filters: List<GetRouteTablePropagationsFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val transitGatewayRouteTableId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetRouteTablePropagationsResult): GetRouteTablePropagationsResult = GetRouteTablePropagationsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTablePropagationsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            transitGatewayRouteTableId = javaType.transitGatewayRouteTableId(),
        )
    }
}
