@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getRouteTable.
 * @property arn EC2 Transit Gateway Route Table ARN.
 * @property defaultAssociationRouteTable Boolean whether this is the default association route table for the EC2 Transit Gateway
 * @property defaultPropagationRouteTable Boolean whether this is the default propagation route table for the EC2 Transit Gateway
 * @property filters
 * @property id EC2 Transit Gateway Route Table identifier
 * @property tags Key-value tags for the EC2 Transit Gateway Route Table
 * @property transitGatewayId EC2 Transit Gateway identifier
 */
public data class GetRouteTableResult(
    public val arn: String,
    public val defaultAssociationRouteTable: Boolean,
    public val defaultPropagationRouteTable: Boolean,
    public val filters: List<GetRouteTableFilter>? = null,
    public val id: String,
    public val tags: Map<String, String>,
    public val transitGatewayId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetRouteTableResult): GetRouteTableResult = GetRouteTableResult(
            arn = javaType.arn(),
            defaultAssociationRouteTable = javaType.defaultAssociationRouteTable(),
            defaultPropagationRouteTable = javaType.defaultPropagationRouteTable(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transitGatewayId = javaType.transitGatewayId(),
        )
    }
}
