@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destinationCidrBlock The CIDR used for route destination matches.
 * @property prefixListId The ID of the prefix list used for destination matches.
 * @property state The current state of the route, can be `active`, `deleted`, `pending`, `blackhole`, `deleting`.
 * @property transitGatewayRouteTableAnnouncementId The id of the transit gateway route table announcement, most of the time it is an empty string.
 * @property type The type of the route, can be `propagated` or `static`.
 */
public data class GetRouteTableRoutesRoute(
    public val destinationCidrBlock: String,
    public val prefixListId: String,
    public val state: String,
    public val transitGatewayRouteTableAnnouncementId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetRouteTableRoutesRoute): GetRouteTableRoutesRoute = GetRouteTableRoutesRoute(
            destinationCidrBlock = javaType.destinationCidrBlock(),
            prefixListId = javaType.prefixListId(),
            state = javaType.state(),
            transitGatewayRouteTableAnnouncementId = javaType.transitGatewayRouteTableAnnouncementId(),
            type = javaType.type(),
        )
    }
}
