@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getVpcAttachment.
 * @property applianceModeSupport Whether Appliance Mode support is enabled.
 * @property dnsSupport Whether DNS support is enabled.
 * @property filters
 * @property id EC2 Transit Gateway VPC Attachment identifier
 * @property ipv6Support Whether IPv6 support is enabled.
 * @property subnetIds Identifiers of EC2 Subnets.
 * @property tags Key-value tags for the EC2 Transit Gateway VPC Attachment
 * @property transitGatewayId EC2 Transit Gateway identifier
 * @property vpcId Identifier of EC2 VPC.
 * @property vpcOwnerId Identifier of the AWS account that owns the EC2 VPC.
 */
public data class GetVpcAttachmentResult(
    public val applianceModeSupport: String,
    public val dnsSupport: String,
    public val filters: List<GetVpcAttachmentFilter>? = null,
    public val id: String,
    public val ipv6Support: String,
    public val subnetIds: List<String>,
    public val tags: Map<String, String>,
    public val transitGatewayId: String,
    public val vpcId: String,
    public val vpcOwnerId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetVpcAttachmentResult): GetVpcAttachmentResult = GetVpcAttachmentResult(
            applianceModeSupport = javaType.applianceModeSupport(),
            dnsSupport = javaType.dnsSupport(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpcAttachmentFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ipv6Support = javaType.ipv6Support(),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transitGatewayId = javaType.transitGatewayId(),
            vpcId = javaType.vpcId(),
            vpcOwnerId = javaType.vpcOwnerId(),
        )
    }
}
