@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcAttachments.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of all attachments ids matching the filter. You can retrieve more information about the attachment using the [aws&#46;ec2transitgateway&#46;VpcAttachment][2] data source, searching by identifier.
 */
public data class GetVpcAttachmentsResult(
    public val filters: List<GetVpcAttachmentsFilter>? = null,
    public val id: String,
    public val ids: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetVpcAttachmentsResult): GetVpcAttachmentsResult = GetVpcAttachmentsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpcAttachmentsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
        )
    }
}
