@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getVpnAttachment.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property tags Key-value tags for the EC2 Transit Gateway VPN Attachment
 * @property transitGatewayId
 * @property vpnConnectionId
 */
public data class GetVpnAttachmentResult(
    public val filters: List<GetVpnAttachmentFilter>? = null,
    public val id: String,
    public val tags: Map<String, String>,
    public val transitGatewayId: String? = null,
    public val vpnConnectionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetVpnAttachmentResult): GetVpnAttachmentResult = GetVpnAttachmentResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpnAttachmentFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transitGatewayId = javaType.transitGatewayId().map({ args0 -> args0 }).orElse(null),
            vpnConnectionId = javaType.vpnConnectionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
