@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.EcrFunctions.getAuthorizationTokenPlain
import com.pulumi.aws.ecr.EcrFunctions.getCredentialsPlain
import com.pulumi.aws.ecr.EcrFunctions.getImagePlain
import com.pulumi.aws.ecr.EcrFunctions.getLifecyclePolicyDocumentPlain
import com.pulumi.aws.ecr.EcrFunctions.getPullThroughCacheRulePlain
import com.pulumi.aws.ecr.EcrFunctions.getRepositoriesPlain
import com.pulumi.aws.ecr.EcrFunctions.getRepositoryCreationTemplatePlain
import com.pulumi.aws.ecr.EcrFunctions.getRepositoryPlain
import com.pulumi.aws.ecr.kotlin.inputs.GetAuthorizationTokenPlainArgs
import com.pulumi.aws.ecr.kotlin.inputs.GetAuthorizationTokenPlainArgsBuilder
import com.pulumi.aws.ecr.kotlin.inputs.GetCredentialsPlainArgs
import com.pulumi.aws.ecr.kotlin.inputs.GetCredentialsPlainArgsBuilder
import com.pulumi.aws.ecr.kotlin.inputs.GetImagePlainArgs
import com.pulumi.aws.ecr.kotlin.inputs.GetImagePlainArgsBuilder
import com.pulumi.aws.ecr.kotlin.inputs.GetLifecyclePolicyDocumentPlainArgs
import com.pulumi.aws.ecr.kotlin.inputs.GetLifecyclePolicyDocumentPlainArgsBuilder
import com.pulumi.aws.ecr.kotlin.inputs.GetLifecyclePolicyDocumentRule
import com.pulumi.aws.ecr.kotlin.inputs.GetPullThroughCacheRulePlainArgs
import com.pulumi.aws.ecr.kotlin.inputs.GetPullThroughCacheRulePlainArgsBuilder
import com.pulumi.aws.ecr.kotlin.inputs.GetRepositoryCreationTemplatePlainArgs
import com.pulumi.aws.ecr.kotlin.inputs.GetRepositoryCreationTemplatePlainArgsBuilder
import com.pulumi.aws.ecr.kotlin.inputs.GetRepositoryPlainArgs
import com.pulumi.aws.ecr.kotlin.inputs.GetRepositoryPlainArgsBuilder
import com.pulumi.aws.ecr.kotlin.outputs.GetAuthorizationTokenResult
import com.pulumi.aws.ecr.kotlin.outputs.GetCredentialsResult
import com.pulumi.aws.ecr.kotlin.outputs.GetImageResult
import com.pulumi.aws.ecr.kotlin.outputs.GetLifecyclePolicyDocumentResult
import com.pulumi.aws.ecr.kotlin.outputs.GetPullThroughCacheRuleResult
import com.pulumi.aws.ecr.kotlin.outputs.GetRepositoriesResult
import com.pulumi.aws.ecr.kotlin.outputs.GetRepositoryCreationTemplateResult
import com.pulumi.aws.ecr.kotlin.outputs.GetRepositoryResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ecr.kotlin.outputs.GetAuthorizationTokenResult.Companion.toKotlin as getAuthorizationTokenResultToKotlin
import com.pulumi.aws.ecr.kotlin.outputs.GetCredentialsResult.Companion.toKotlin as getCredentialsResultToKotlin
import com.pulumi.aws.ecr.kotlin.outputs.GetImageResult.Companion.toKotlin as getImageResultToKotlin
import com.pulumi.aws.ecr.kotlin.outputs.GetLifecyclePolicyDocumentResult.Companion.toKotlin as getLifecyclePolicyDocumentResultToKotlin
import com.pulumi.aws.ecr.kotlin.outputs.GetPullThroughCacheRuleResult.Companion.toKotlin as getPullThroughCacheRuleResultToKotlin
import com.pulumi.aws.ecr.kotlin.outputs.GetRepositoriesResult.Companion.toKotlin as getRepositoriesResultToKotlin
import com.pulumi.aws.ecr.kotlin.outputs.GetRepositoryCreationTemplateResult.Companion.toKotlin as getRepositoryCreationTemplateResultToKotlin
import com.pulumi.aws.ecr.kotlin.outputs.GetRepositoryResult.Companion.toKotlin as getRepositoryResultToKotlin

public object EcrFunctions {
    /**
     * The ECR Authorization Token data source allows the authorization token, proxy endpoint, token expiration date, user name and password to be retrieved for an ECR repository.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const token = aws.ecr.getAuthorizationToken({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * token = aws.ecr.get_authorization_token()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var token = Aws.Ecr.GetAuthorizationToken.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecr.GetAuthorizationToken(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecr.EcrFunctions;
     * import com.pulumi.aws.ecr.inputs.GetAuthorizationTokenArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var token = EcrFunctions.getAuthorizationToken();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   token:
     *     fn::invoke:
     *       Function: aws:ecr:getAuthorizationToken
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAuthorizationToken.
     * @return A collection of values returned by getAuthorizationToken.
     */
    public suspend fun getAuthorizationToken(argument: GetAuthorizationTokenPlainArgs): GetAuthorizationTokenResult =
        getAuthorizationTokenResultToKotlin(getAuthorizationTokenPlain(argument.toJava()).await())

    /**
     * @see [getAuthorizationToken].
     * @param registryId AWS account ID of the ECR Repository. If not specified the default account is assumed.
     * @return A collection of values returned by getAuthorizationToken.
     */
    public suspend fun getAuthorizationToken(registryId: String? = null): GetAuthorizationTokenResult {
        val argument = GetAuthorizationTokenPlainArgs(
            registryId = registryId,
        )
        return getAuthorizationTokenResultToKotlin(getAuthorizationTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuthorizationToken].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecr&#46;kotlin&#46;inputs&#46;GetAuthorizationTokenPlainArgs].
     * @return A collection of values returned by getAuthorizationToken.
     */
    public suspend fun getAuthorizationToken(argument: suspend GetAuthorizationTokenPlainArgsBuilder.() -> Unit): GetAuthorizationTokenResult {
        val builder = GetAuthorizationTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAuthorizationTokenResultToKotlin(getAuthorizationTokenPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * @param argument A collection of arguments for invoking getCredentials.
     * @return A collection of values returned by getCredentials.
     */
    public suspend fun getCredentials(argument: GetCredentialsPlainArgs): GetCredentialsResult =
        getCredentialsResultToKotlin(getCredentialsPlain(argument.toJava()).await())

    /**
     * @see [getCredentials].
     * @param registryId
     * @return A collection of values returned by getCredentials.
     */
    public suspend fun getCredentials(registryId: String): GetCredentialsResult {
        val argument = GetCredentialsPlainArgs(
            registryId = registryId,
        )
        return getCredentialsResultToKotlin(getCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecr&#46;kotlin&#46;inputs&#46;GetCredentialsPlainArgs].
     * @return A collection of values returned by getCredentials.
     */
    public suspend fun getCredentials(argument: suspend GetCredentialsPlainArgsBuilder.() -> Unit): GetCredentialsResult {
        val builder = GetCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCredentialsResultToKotlin(getCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * The ECR Image data source allows the details of an image with a particular tag or digest to be retrieved.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const serviceImage = aws.ecr.getImage({
     *     repositoryName: "my/service",
     *     imageTag: "latest",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * service_image = aws.ecr.get_image(repository_name="my/service",
     *     image_tag="latest")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var serviceImage = Aws.Ecr.GetImage.Invoke(new()
     *     {
     *         RepositoryName = "my/service",
     *         ImageTag = "latest",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecr.GetImage(ctx, &ecr.GetImageArgs{
     * 			RepositoryName: "my/service",
     * 			ImageTag:       pulumi.StringRef("latest"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecr.EcrFunctions;
     * import com.pulumi.aws.ecr.inputs.GetImageArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var serviceImage = EcrFunctions.getImage(GetImageArgs.builder()
     *             .repositoryName("my/service")
     *             .imageTag("latest")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   serviceImage:
     *     fn::invoke:
     *       Function: aws:ecr:getImage
     *       Arguments:
     *         repositoryName: my/service
     *         imageTag: latest
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getImage.
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(argument: GetImagePlainArgs): GetImageResult =
        getImageResultToKotlin(getImagePlain(argument.toJava()).await())

    /**
     * @see [getImage].
     * @param imageDigest Sha256 digest of the image manifest. At least one of `image_digest`, `image_tag`, or `most_recent` must be specified.
     * @param imageTag Tag associated with this image. At least one of `image_digest`, `image_tag`, or `most_recent` must be specified.
     * @param mostRecent Return the most recently pushed image. At least one of `image_digest`, `image_tag`, or `most_recent` must be specified.
     * @param registryId ID of the Registry where the repository resides.
     * @param repositoryName Name of the ECR Repository.
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(
        imageDigest: String? = null,
        imageTag: String? = null,
        mostRecent: Boolean? = null,
        registryId: String? = null,
        repositoryName: String,
    ): GetImageResult {
        val argument = GetImagePlainArgs(
            imageDigest = imageDigest,
            imageTag = imageTag,
            mostRecent = mostRecent,
            registryId = registryId,
            repositoryName = repositoryName,
        )
        return getImageResultToKotlin(getImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getImage].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecr&#46;kotlin&#46;inputs&#46;GetImagePlainArgs].
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(argument: suspend GetImagePlainArgsBuilder.() -> Unit): GetImageResult {
        val builder = GetImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImageResultToKotlin(getImagePlain(builtArgument.toJava()).await())
    }

    /**
     * Generates an ECR lifecycle policy document in JSON format. Can be used with resources such as the `aws.ecr.LifecyclePolicy` resource.
     * > For more information about building AWS ECR lifecycle policy documents, see the [AWS ECR Lifecycle Policy Document Guide](https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html).
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ecr.getLifecyclePolicyDocument({
     *     rules: [{
     *         priority: 1,
     *         description: "This is a test.",
     *         selection: {
     *             tagStatus: "tagged",
     *             tagPrefixLists: ["prod"],
     *             countType: "imageCountMoreThan",
     *             countNumber: 100,
     *         },
     *     }],
     * });
     * const exampleLifecyclePolicy = new aws.ecr.LifecyclePolicy("example", {
     *     repository: exampleAwsEcrRepository.name,
     *     policy: example.then(example => example.json),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ecr.get_lifecycle_policy_document(rules=[{
     *     "priority": 1,
     *     "description": "This is a test.",
     *     "selection": {
     *         "tag_status": "tagged",
     *         "tag_prefix_lists": ["prod"],
     *         "count_type": "imageCountMoreThan",
     *         "count_number": 100,
     *     },
     * }])
     * example_lifecycle_policy = aws.ecr.LifecyclePolicy("example",
     *     repository=example_aws_ecr_repository["name"],
     *     policy=example.json)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ecr.GetLifecyclePolicyDocument.Invoke(new()
     *     {
     *         Rules = new[]
     *         {
     *             new Aws.Ecr.Inputs.GetLifecyclePolicyDocumentRuleInputArgs
     *             {
     *                 Priority = 1,
     *                 Description = "This is a test.",
     *                 Selection = new Aws.Ecr.Inputs.GetLifecyclePolicyDocumentRuleSelectionInputArgs
     *                 {
     *                     TagStatus = "tagged",
     *                     TagPrefixLists = new[]
     *                     {
     *                         "prod",
     *                     },
     *                     CountType = "imageCountMoreThan",
     *                     CountNumber = 100,
     *                 },
     *             },
     *         },
     *     });
     *     var exampleLifecyclePolicy = new Aws.Ecr.LifecyclePolicy("example", new()
     *     {
     *         Repository = exampleAwsEcrRepository.Name,
     *         Policy = example.Apply(getLifecyclePolicyDocumentResult => getLifecyclePolicyDocumentResult.Json),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ecr.GetLifecyclePolicyDocument(ctx, &ecr.GetLifecyclePolicyDocumentArgs{
     * 			Rules: []ecr.GetLifecyclePolicyDocumentRule{
     * 				{
     * 					Priority:    1,
     * 					Description: pulumi.StringRef("This is a test."),
     * 					Selection: {
     * 						TagStatus: "tagged",
     * 						TagPrefixLists: []string{
     * 							"prod",
     * 						},
     * 						CountType:   "imageCountMoreThan",
     * 						CountNumber: 100,
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ecr.NewLifecyclePolicy(ctx, "example", &ecr.LifecyclePolicyArgs{
     * 			Repository: pulumi.Any(exampleAwsEcrRepository.Name),
     * 			Policy:     pulumi.String(example.Json),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecr.EcrFunctions;
     * import com.pulumi.aws.ecr.inputs.GetLifecyclePolicyDocumentArgs;
     * import com.pulumi.aws.ecr.LifecyclePolicy;
     * import com.pulumi.aws.ecr.LifecyclePolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcrFunctions.getLifecyclePolicyDocument(GetLifecyclePolicyDocumentArgs.builder()
     *             .rules(GetLifecyclePolicyDocumentRuleArgs.builder()
     *                 .priority(1)
     *                 .description("This is a test.")
     *                 .selection(GetLifecyclePolicyDocumentRuleSelectionArgs.builder()
     *                     .tagStatus("tagged")
     *                     .tagPrefixLists("prod")
     *                     .countType("imageCountMoreThan")
     *                     .countNumber(100)
     *                     .build())
     *                 .build())
     *             .build());
     *         var exampleLifecyclePolicy = new LifecyclePolicy("exampleLifecyclePolicy", LifecyclePolicyArgs.builder()
     *             .repository(exampleAwsEcrRepository.name())
     *             .policy(example.applyValue(getLifecyclePolicyDocumentResult -> getLifecyclePolicyDocumentResult.json()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   exampleLifecyclePolicy:
     *     type: aws:ecr:LifecyclePolicy
     *     name: example
     *     properties:
     *       repository: ${exampleAwsEcrRepository.name}
     *       policy: ${example.json}
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ecr:getLifecyclePolicyDocument
     *       Arguments:
     *         rules:
     *           - priority: 1
     *             description: This is a test.
     *             selection:
     *               tagStatus: tagged
     *               tagPrefixLists:
     *                 - prod
     *               countType: imageCountMoreThan
     *               countNumber: 100
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLifecyclePolicyDocument.
     * @return A collection of values returned by getLifecyclePolicyDocument.
     */
    public suspend fun getLifecyclePolicyDocument(argument: GetLifecyclePolicyDocumentPlainArgs): GetLifecyclePolicyDocumentResult =
        getLifecyclePolicyDocumentResultToKotlin(getLifecyclePolicyDocumentPlain(argument.toJava()).await())

    /**
     * @see [getLifecyclePolicyDocument].
     * @param rules
     * @return A collection of values returned by getLifecyclePolicyDocument.
     */
    public suspend fun getLifecyclePolicyDocument(
        rules: List<GetLifecyclePolicyDocumentRule>? =
            null,
    ): GetLifecyclePolicyDocumentResult {
        val argument = GetLifecyclePolicyDocumentPlainArgs(
            rules = rules,
        )
        return getLifecyclePolicyDocumentResultToKotlin(getLifecyclePolicyDocumentPlain(argument.toJava()).await())
    }

    /**
     * @see [getLifecyclePolicyDocument].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecr&#46;kotlin&#46;inputs&#46;GetLifecyclePolicyDocumentPlainArgs].
     * @return A collection of values returned by getLifecyclePolicyDocument.
     */
    public suspend fun getLifecyclePolicyDocument(argument: suspend GetLifecyclePolicyDocumentPlainArgsBuilder.() -> Unit): GetLifecyclePolicyDocumentResult {
        val builder = GetLifecyclePolicyDocumentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLifecyclePolicyDocumentResultToKotlin(getLifecyclePolicyDocumentPlain(builtArgument.toJava()).await())
    }

    /**
     * The ECR Pull Through Cache Rule data source allows the upstream registry URL and registry ID to be retrieved for a Pull Through Cache Rule.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ecrPublic = aws.ecr.getPullThroughCacheRule({
     *     ecrRepositoryPrefix: "ecr-public",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ecr_public = aws.ecr.get_pull_through_cache_rule(ecr_repository_prefix="ecr-public")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ecrPublic = Aws.Ecr.GetPullThroughCacheRule.Invoke(new()
     *     {
     *         EcrRepositoryPrefix = "ecr-public",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecr.LookupPullThroughCacheRule(ctx, &ecr.LookupPullThroughCacheRuleArgs{
     * 			EcrRepositoryPrefix: "ecr-public",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecr.EcrFunctions;
     * import com.pulumi.aws.ecr.inputs.GetPullThroughCacheRuleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ecrPublic = EcrFunctions.getPullThroughCacheRule(GetPullThroughCacheRuleArgs.builder()
     *             .ecrRepositoryPrefix("ecr-public")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ecrPublic:
     *     fn::invoke:
     *       Function: aws:ecr:getPullThroughCacheRule
     *       Arguments:
     *         ecrRepositoryPrefix: ecr-public
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPullThroughCacheRule.
     * @return A collection of values returned by getPullThroughCacheRule.
     */
    public suspend fun getPullThroughCacheRule(argument: GetPullThroughCacheRulePlainArgs): GetPullThroughCacheRuleResult =
        getPullThroughCacheRuleResultToKotlin(getPullThroughCacheRulePlain(argument.toJava()).await())

    /**
     * @see [getPullThroughCacheRule].
     * @param ecrRepositoryPrefix The repository name prefix to use when caching images from the source registry.
     * @return A collection of values returned by getPullThroughCacheRule.
     */
    public suspend fun getPullThroughCacheRule(ecrRepositoryPrefix: String): GetPullThroughCacheRuleResult {
        val argument = GetPullThroughCacheRulePlainArgs(
            ecrRepositoryPrefix = ecrRepositoryPrefix,
        )
        return getPullThroughCacheRuleResultToKotlin(getPullThroughCacheRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getPullThroughCacheRule].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecr&#46;kotlin&#46;inputs&#46;GetPullThroughCacheRulePlainArgs].
     * @return A collection of values returned by getPullThroughCacheRule.
     */
    public suspend fun getPullThroughCacheRule(argument: suspend GetPullThroughCacheRulePlainArgsBuilder.() -> Unit): GetPullThroughCacheRuleResult {
        val builder = GetPullThroughCacheRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPullThroughCacheRuleResultToKotlin(getPullThroughCacheRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for providing information on AWS ECR (Elastic Container Registry) Repositories.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ecr.getRepositories({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ecr.get_repositories()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ecr.GetRepositories.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecr.GetRepositories(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecr.EcrFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcrFunctions.getRepositories();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ecr:getRepositories
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument Data source for providing information on AWS ECR (Elastic Container Registry) Repositories.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ecr.getRepositories({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ecr.get_repositories()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ecr.GetRepositories.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecr.GetRepositories(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecr.EcrFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcrFunctions.getRepositories();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ecr:getRepositories
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getRepositories.
     */
    public suspend fun getRepositories(): GetRepositoriesResult =
        getRepositoriesResultToKotlin(getRepositoriesPlain().await())

    /**
     * The ECR Repository data source allows the ARN, Repository URI and Registry ID to be retrieved for an ECR repository.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const service = aws.ecr.getRepository({
     *     name: "ecr-repository",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * service = aws.ecr.get_repository(name="ecr-repository")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var service = Aws.Ecr.GetRepository.Invoke(new()
     *     {
     *         Name = "ecr-repository",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecr.LookupRepository(ctx, &ecr.LookupRepositoryArgs{
     * 			Name: "ecr-repository",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecr.EcrFunctions;
     * import com.pulumi.aws.ecr.inputs.GetRepositoryArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var service = EcrFunctions.getRepository(GetRepositoryArgs.builder()
     *             .name("ecr-repository")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   service:
     *     fn::invoke:
     *       Function: aws:ecr:getRepository
     *       Arguments:
     *         name: ecr-repository
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRepository.
     * @return A collection of values returned by getRepository.
     */
    public suspend fun getRepository(argument: GetRepositoryPlainArgs): GetRepositoryResult =
        getRepositoryResultToKotlin(getRepositoryPlain(argument.toJava()).await())

    /**
     * @see [getRepository].
     * @param name Name of the ECR Repository.
     * @param registryId Registry ID where the repository was created.
     * @param tags Map of tags assigned to the resource.
     * @return A collection of values returned by getRepository.
     */
    public suspend fun getRepository(
        name: String,
        registryId: String? = null,
        tags: Map<String, String>? = null,
    ): GetRepositoryResult {
        val argument = GetRepositoryPlainArgs(
            name = name,
            registryId = registryId,
            tags = tags,
        )
        return getRepositoryResultToKotlin(getRepositoryPlain(argument.toJava()).await())
    }

    /**
     * @see [getRepository].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecr&#46;kotlin&#46;inputs&#46;GetRepositoryPlainArgs].
     * @return A collection of values returned by getRepository.
     */
    public suspend fun getRepository(argument: suspend GetRepositoryPlainArgsBuilder.() -> Unit): GetRepositoryResult {
        val builder = GetRepositoryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRepositoryResultToKotlin(getRepositoryPlain(builtArgument.toJava()).await())
    }

    /**
     * The ECR Repository Creation Template data source allows the template details to be retrieved for a Repository Creation Template.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ecr.getRepositoryCreationTemplate({
     *     prefix: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ecr.get_repository_creation_template(prefix="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ecr.GetRepositoryCreationTemplate.Invoke(new()
     *     {
     *         Prefix = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecr.LookupRepositoryCreationTemplate(ctx, &ecr.LookupRepositoryCreationTemplateArgs{
     * 			Prefix: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecr.EcrFunctions;
     * import com.pulumi.aws.ecr.inputs.GetRepositoryCreationTemplateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcrFunctions.getRepositoryCreationTemplate(GetRepositoryCreationTemplateArgs.builder()
     *             .prefix("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ecr:getRepositoryCreationTemplate
     *       Arguments:
     *         prefix: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRepositoryCreationTemplate.
     * @return A collection of values returned by getRepositoryCreationTemplate.
     */
    public suspend fun getRepositoryCreationTemplate(argument: GetRepositoryCreationTemplatePlainArgs): GetRepositoryCreationTemplateResult =
        getRepositoryCreationTemplateResultToKotlin(getRepositoryCreationTemplatePlain(argument.toJava()).await())

    /**
     * @see [getRepositoryCreationTemplate].
     * @param prefix The repository name prefix that the template matches against.
     * @param resourceTags A map of tags to assign to any created repositories.
     * @return A collection of values returned by getRepositoryCreationTemplate.
     */
    public suspend fun getRepositoryCreationTemplate(
        prefix: String,
        resourceTags: Map<String, String>? = null,
    ): GetRepositoryCreationTemplateResult {
        val argument = GetRepositoryCreationTemplatePlainArgs(
            prefix = prefix,
            resourceTags = resourceTags,
        )
        return getRepositoryCreationTemplateResultToKotlin(getRepositoryCreationTemplatePlain(argument.toJava()).await())
    }

    /**
     * @see [getRepositoryCreationTemplate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecr&#46;kotlin&#46;inputs&#46;GetRepositoryCreationTemplatePlainArgs].
     * @return A collection of values returned by getRepositoryCreationTemplate.
     */
    public suspend fun getRepositoryCreationTemplate(argument: suspend GetRepositoryCreationTemplatePlainArgsBuilder.() -> Unit): GetRepositoryCreationTemplateResult {
        val builder = GetRepositoryCreationTemplatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRepositoryCreationTemplateResultToKotlin(getRepositoryCreationTemplatePlain(builtArgument.toJava()).await())
    }
}
