@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LifecyclePolicy].
 */
@PulumiTagMarker
public class LifecyclePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LifecyclePolicyArgs = LifecyclePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LifecyclePolicyArgsBuilder.() -> Unit) {
        val builder = LifecyclePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LifecyclePolicy {
        val builtJavaResource = com.pulumi.aws.ecr.LifecyclePolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LifecyclePolicy(builtJavaResource)
    }
}

/**
 * Manages an ECR repository lifecycle policy.
 * > **NOTE:** Only one `aws.ecr.LifecyclePolicy` resource can be used with the same ECR repository. To apply multiple rules, they must be combined in the `policy` JSON.
 * > **NOTE:** The AWS ECR API seems to reorder rules based on `rulePriority`. If you define multiple rules that are not sorted in ascending `rulePriority` order in the this provider code, the resource will be flagged for recreation every deployment.
 * ## Example Usage
 * ### Policy on untagged image
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecr.Repository("example", {name: "example-repo"});
 * const exampleLifecyclePolicy = new aws.ecr.LifecyclePolicy("example", {
 *     repository: example.name,
 *     policy: `{
 *     "rules": [
 *         {
 *             "rulePriority": 1,
 *             "description": "Expire images older than 14 days",
 *             "selection": {
 *                 "tagStatus": "untagged",
 *                 "countType": "sinceImagePushed",
 *                 "countUnit": "days",
 *                 "countNumber": 14
 *             },
 *             "action": {
 *                 "type": "expire"
 *             }
 *         }
 *     ]
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecr.Repository("example", name="example-repo")
 * example_lifecycle_policy = aws.ecr.LifecyclePolicy("example",
 *     repository=example.name,
 *     policy="""{
 *     "rules": [
 *         {
 *             "rulePriority": 1,
 *             "description": "Expire images older than 14 days",
 *             "selection": {
 *                 "tagStatus": "untagged",
 *                 "countType": "sinceImagePushed",
 *                 "countUnit": "days",
 *                 "countNumber": 14
 *             },
 *             "action": {
 *                 "type": "expire"
 *             }
 *         }
 *     ]
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecr.Repository("example", new()
 *     {
 *         Name = "example-repo",
 *     });
 *     var exampleLifecyclePolicy = new Aws.Ecr.LifecyclePolicy("example", new()
 *     {
 *         Repository = example.Name,
 *         Policy = @"{
 *     ""rules"": [
 *         {
 *             ""rulePriority"": 1,
 *             ""description"": ""Expire images older than 14 days"",
 *             ""selection"": {
 *                 ""tagStatus"": ""untagged"",
 *                 ""countType"": ""sinceImagePushed"",
 *                 ""countUnit"": ""days"",
 *                 ""countNumber"": 14
 *             },
 *             ""action"": {
 *                 ""type"": ""expire""
 *             }
 *         }
 *     ]
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ecr.NewRepository(ctx, "example", &ecr.RepositoryArgs{
 * 			Name: pulumi.String("example-repo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecr.NewLifecyclePolicy(ctx, "example", &ecr.LifecyclePolicyArgs{
 * 			Repository: example.Name,
 * 			Policy: pulumi.Any(`{
 *     "rules": [
 *         {
 *             "rulePriority": 1,
 *             "description": "Expire images older than 14 days",
 *             "selection": {
 *                 "tagStatus": "untagged",
 *                 "countType": "sinceImagePushed",
 *                 "countUnit": "days",
 *                 "countNumber": 14
 *             },
 *             "action": {
 *                 "type": "expire"
 *             }
 *         }
 *     ]
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.Repository;
 * import com.pulumi.aws.ecr.RepositoryArgs;
 * import com.pulumi.aws.ecr.LifecyclePolicy;
 * import com.pulumi.aws.ecr.LifecyclePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Repository("example", RepositoryArgs.builder()
 *             .name("example-repo")
 *             .build());
 *         var exampleLifecyclePolicy = new LifecyclePolicy("exampleLifecyclePolicy", LifecyclePolicyArgs.builder()
 *             .repository(example.name())
 *             .policy("""
 * {
 *     "rules": [
 *         {
 *             "rulePriority": 1,
 *             "description": "Expire images older than 14 days",
 *             "selection": {
 *                 "tagStatus": "untagged",
 *                 "countType": "sinceImagePushed",
 *                 "countUnit": "days",
 *                 "countNumber": 14
 *             },
 *             "action": {
 *                 "type": "expire"
 *             }
 *         }
 *     ]
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecr:Repository
 *     properties:
 *       name: example-repo
 *   exampleLifecyclePolicy:
 *     type: aws:ecr:LifecyclePolicy
 *     name: example
 *     properties:
 *       repository: ${example.name}
 *       policy: |
 *         {
 *             "rules": [
 *                 {
 *                     "rulePriority": 1,
 *                     "description": "Expire images older than 14 days",
 *                     "selection": {
 *                         "tagStatus": "untagged",
 *                         "countType": "sinceImagePushed",
 *                         "countUnit": "days",
 *                         "countNumber": 14
 *                     },
 *                     "action": {
 *                         "type": "expire"
 *                     }
 *                 }
 *             ]
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Policy on tagged image
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecr.Repository("example", {name: "example-repo"});
 * const exampleLifecyclePolicy = new aws.ecr.LifecyclePolicy("example", {
 *     repository: example.name,
 *     policy: `{
 *     "rules": [
 *         {
 *             "rulePriority": 1,
 *             "description": "Keep last 30 images",
 *             "selection": {
 *                 "tagStatus": "tagged",
 *                 "tagPrefixList": ["v"],
 *                 "countType": "imageCountMoreThan",
 *                 "countNumber": 30
 *             },
 *             "action": {
 *                 "type": "expire"
 *             }
 *         }
 *     ]
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecr.Repository("example", name="example-repo")
 * example_lifecycle_policy = aws.ecr.LifecyclePolicy("example",
 *     repository=example.name,
 *     policy="""{
 *     "rules": [
 *         {
 *             "rulePriority": 1,
 *             "description": "Keep last 30 images",
 *             "selection": {
 *                 "tagStatus": "tagged",
 *                 "tagPrefixList": ["v"],
 *                 "countType": "imageCountMoreThan",
 *                 "countNumber": 30
 *             },
 *             "action": {
 *                 "type": "expire"
 *             }
 *         }
 *     ]
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecr.Repository("example", new()
 *     {
 *         Name = "example-repo",
 *     });
 *     var exampleLifecyclePolicy = new Aws.Ecr.LifecyclePolicy("example", new()
 *     {
 *         Repository = example.Name,
 *         Policy = @"{
 *     ""rules"": [
 *         {
 *             ""rulePriority"": 1,
 *             ""description"": ""Keep last 30 images"",
 *             ""selection"": {
 *                 ""tagStatus"": ""tagged"",
 *                 ""tagPrefixList"": [""v""],
 *                 ""countType"": ""imageCountMoreThan"",
 *                 ""countNumber"": 30
 *             },
 *             ""action"": {
 *                 ""type"": ""expire""
 *             }
 *         }
 *     ]
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ecr.NewRepository(ctx, "example", &ecr.RepositoryArgs{
 * 			Name: pulumi.String("example-repo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecr.NewLifecyclePolicy(ctx, "example", &ecr.LifecyclePolicyArgs{
 * 			Repository: example.Name,
 * 			Policy: pulumi.Any(`{
 *     "rules": [
 *         {
 *             "rulePriority": 1,
 *             "description": "Keep last 30 images",
 *             "selection": {
 *                 "tagStatus": "tagged",
 *                 "tagPrefixList": ["v"],
 *                 "countType": "imageCountMoreThan",
 *                 "countNumber": 30
 *             },
 *             "action": {
 *                 "type": "expire"
 *             }
 *         }
 *     ]
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.Repository;
 * import com.pulumi.aws.ecr.RepositoryArgs;
 * import com.pulumi.aws.ecr.LifecyclePolicy;
 * import com.pulumi.aws.ecr.LifecyclePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Repository("example", RepositoryArgs.builder()
 *             .name("example-repo")
 *             .build());
 *         var exampleLifecyclePolicy = new LifecyclePolicy("exampleLifecyclePolicy", LifecyclePolicyArgs.builder()
 *             .repository(example.name())
 *             .policy("""
 * {
 *     "rules": [
 *         {
 *             "rulePriority": 1,
 *             "description": "Keep last 30 images",
 *             "selection": {
 *                 "tagStatus": "tagged",
 *                 "tagPrefixList": ["v"],
 *                 "countType": "imageCountMoreThan",
 *                 "countNumber": 30
 *             },
 *             "action": {
 *                 "type": "expire"
 *             }
 *         }
 *     ]
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecr:Repository
 *     properties:
 *       name: example-repo
 *   exampleLifecyclePolicy:
 *     type: aws:ecr:LifecyclePolicy
 *     name: example
 *     properties:
 *       repository: ${example.name}
 *       policy: |
 *         {
 *             "rules": [
 *                 {
 *                     "rulePriority": 1,
 *                     "description": "Keep last 30 images",
 *                     "selection": {
 *                         "tagStatus": "tagged",
 *                         "tagPrefixList": ["v"],
 *                         "countType": "imageCountMoreThan",
 *                         "countNumber": 30
 *                     },
 *                     "action": {
 *                         "type": "expire"
 *                     }
 *                 }
 *             ]
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECR Lifecycle Policy using the name of the repository. For example:
 * ```sh
 * $ pulumi import aws:ecr/lifecyclePolicy:LifecyclePolicy example tf-example
 * ```
 */
public class LifecyclePolicy internal constructor(
    override val javaResource: com.pulumi.aws.ecr.LifecyclePolicy,
) : KotlinCustomResource(javaResource, LifecyclePolicyMapper) {
    /**
     * The policy document. This is a JSON formatted string. See more details about [Policy Parameters](http://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html#lifecycle_policy_parameters) in the official AWS docs. Consider using the `aws.ecr.getLifecyclePolicyDocument` data_source to generate/manage the JSON document used for the `policy` argument.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The registry ID where the repository was created.
     */
    public val registryId: Output<String>
        get() = javaResource.registryId().applyValue({ args0 -> args0 })

    /**
     * Name of the repository to apply the policy.
     */
    public val repository: Output<String>
        get() = javaResource.repository().applyValue({ args0 -> args0 })
}

public object LifecyclePolicyMapper : ResourceMapper<LifecyclePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecr.LifecyclePolicy::class == javaResource::class

    override fun map(javaResource: Resource): LifecyclePolicy = LifecyclePolicy(
        javaResource as
            com.pulumi.aws.ecr.LifecyclePolicy,
    )
}

/**
 * @see [LifecyclePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LifecyclePolicy].
 */
public suspend fun lifecyclePolicy(
    name: String,
    block: suspend LifecyclePolicyResourceBuilder.() -> Unit,
): LifecyclePolicy {
    val builder = LifecyclePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LifecyclePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lifecyclePolicy(name: String): LifecyclePolicy {
    val builder = LifecyclePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
