@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.PullThroughCacheRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Container Registry Pull Through Cache Rule.
 * More information about pull through cache rules, including the set of supported
 * upstream repositories, see [Using pull through cache rules](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecr.PullThroughCacheRule("example", {
 *     ecrRepositoryPrefix: "ecr-public",
 *     upstreamRegistryUrl: "public.ecr.aws",
 *     credentialArn: "arn:aws:secretsmanager:us-east-1:123456789:secret:ecr-pullthroughcache/ecrpublic",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecr.PullThroughCacheRule("example",
 *     ecr_repository_prefix="ecr-public",
 *     upstream_registry_url="public.ecr.aws",
 *     credential_arn="arn:aws:secretsmanager:us-east-1:123456789:secret:ecr-pullthroughcache/ecrpublic")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecr.PullThroughCacheRule("example", new()
 *     {
 *         EcrRepositoryPrefix = "ecr-public",
 *         UpstreamRegistryUrl = "public.ecr.aws",
 *         CredentialArn = "arn:aws:secretsmanager:us-east-1:123456789:secret:ecr-pullthroughcache/ecrpublic",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecr.NewPullThroughCacheRule(ctx, "example", &ecr.PullThroughCacheRuleArgs{
 * 			EcrRepositoryPrefix: pulumi.String("ecr-public"),
 * 			UpstreamRegistryUrl: pulumi.String("public.ecr.aws"),
 * 			CredentialArn:       pulumi.String("arn:aws:secretsmanager:us-east-1:123456789:secret:ecr-pullthroughcache/ecrpublic"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.PullThroughCacheRule;
 * import com.pulumi.aws.ecr.PullThroughCacheRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PullThroughCacheRule("example", PullThroughCacheRuleArgs.builder()
 *             .ecrRepositoryPrefix("ecr-public")
 *             .upstreamRegistryUrl("public.ecr.aws")
 *             .credentialArn("arn:aws:secretsmanager:us-east-1:123456789:secret:ecr-pullthroughcache/ecrpublic")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecr:PullThroughCacheRule
 *     properties:
 *       ecrRepositoryPrefix: ecr-public
 *       upstreamRegistryUrl: public.ecr.aws
 *       credentialArn: arn:aws:secretsmanager:us-east-1:123456789:secret:ecr-pullthroughcache/ecrpublic
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a pull-through cache rule using the `ecr_repository_prefix`. For example:
 * ```sh
 * $ pulumi import aws:ecr/pullThroughCacheRule:PullThroughCacheRule example ecr-public
 * ```
 * @property credentialArn ARN of the Secret which will be used to authenticate against the registry.
 * @property ecrRepositoryPrefix The repository name prefix to use when caching images from the source registry.
 * @property upstreamRegistryUrl The registry URL of the upstream public registry to use as the source.
 */
public data class PullThroughCacheRuleArgs(
    public val credentialArn: Output<String>? = null,
    public val ecrRepositoryPrefix: Output<String>? = null,
    public val upstreamRegistryUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecr.PullThroughCacheRuleArgs> {
    override fun toJava(): com.pulumi.aws.ecr.PullThroughCacheRuleArgs =
        com.pulumi.aws.ecr.PullThroughCacheRuleArgs.builder()
            .credentialArn(credentialArn?.applyValue({ args0 -> args0 }))
            .ecrRepositoryPrefix(ecrRepositoryPrefix?.applyValue({ args0 -> args0 }))
            .upstreamRegistryUrl(upstreamRegistryUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PullThroughCacheRuleArgs].
 */
@PulumiTagMarker
public class PullThroughCacheRuleArgsBuilder internal constructor() {
    private var credentialArn: Output<String>? = null

    private var ecrRepositoryPrefix: Output<String>? = null

    private var upstreamRegistryUrl: Output<String>? = null

    /**
     * @param value ARN of the Secret which will be used to authenticate against the registry.
     */
    @JvmName("qcwlpfwuklpstnyf")
    public suspend fun credentialArn(`value`: Output<String>) {
        this.credentialArn = value
    }

    /**
     * @param value The repository name prefix to use when caching images from the source registry.
     */
    @JvmName("hehutdyhqxqwgstb")
    public suspend fun ecrRepositoryPrefix(`value`: Output<String>) {
        this.ecrRepositoryPrefix = value
    }

    /**
     * @param value The registry URL of the upstream public registry to use as the source.
     */
    @JvmName("smjadycrjjjiptov")
    public suspend fun upstreamRegistryUrl(`value`: Output<String>) {
        this.upstreamRegistryUrl = value
    }

    /**
     * @param value ARN of the Secret which will be used to authenticate against the registry.
     */
    @JvmName("sggrjurknytmqsen")
    public suspend fun credentialArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialArn = mapped
    }

    /**
     * @param value The repository name prefix to use when caching images from the source registry.
     */
    @JvmName("jdpqtdtojraedlkl")
    public suspend fun ecrRepositoryPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecrRepositoryPrefix = mapped
    }

    /**
     * @param value The registry URL of the upstream public registry to use as the source.
     */
    @JvmName("qkpobahxueddusnp")
    public suspend fun upstreamRegistryUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upstreamRegistryUrl = mapped
    }

    internal fun build(): PullThroughCacheRuleArgs = PullThroughCacheRuleArgs(
        credentialArn = credentialArn,
        ecrRepositoryPrefix = ecrRepositoryPrefix,
        upstreamRegistryUrl = upstreamRegistryUrl,
    )
}
