@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RegistryPolicy].
 */
@PulumiTagMarker
public class RegistryPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryPolicyArgs = RegistryPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryPolicyArgsBuilder.() -> Unit) {
        val builder = RegistryPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegistryPolicy {
        val builtJavaResource = com.pulumi.aws.ecr.RegistryPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RegistryPolicy(builtJavaResource)
    }
}

/**
 * Provides an Elastic Container Registry Policy.
 * > **NOTE on ECR Registry Policies:** While the AWS Management Console interface may suggest the ability to define multiple policies by creating multiple statements, ECR registry policies are effectively managed as singular entities at the regional level by the AWS APIs. Therefore, the `aws.ecr.RegistryPolicy` resource should be configured only once per region with all necessary statements defined in the same policy. Attempting to define multiple `aws.ecr.RegistryPolicy` resources may result in perpetual differences, with one policy overriding another.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const currentGetRegion = aws.getRegion({});
 * const currentGetPartition = aws.getPartition({});
 * const example = new aws.ecr.RegistryPolicy("example", {policy: JSON.stringify({
 *     Version: "2012-10-17",
 *     Statement: [{
 *         Sid: "testpolicy",
 *         Effect: "Allow",
 *         Principal: {
 *             AWS: Promise.all([currentGetPartition, current])&#46;then(([currentGetPartition, current]) => `arn:${currentGetPartition.partition}:iam::${current.accountId}:root`),
 *         },
 *         Action: ["ecr:ReplicateImage"],
 *         Resource: [Promise&#46;all([currentGetPartition, currentGetRegion, current])&#46;then(([currentGetPartition, currentGetRegion, current]) => `arn:${currentGetPartition&#46;partition}:ecr:${currentGetRegion&#46;name}:${current&#46;accountId}:repository/*`)],
 *     }],
 * })});
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * current_get_region = aws.get_region()
 * current_get_partition = aws.get_partition()
 * example = aws.ecr.RegistryPolicy("example", policy=json.dumps({
 *     "Version": "2012-10-17",
 *     "Statement": [{
 *         "Sid": "testpolicy",
 *         "Effect": "Allow",
 *         "Principal": {
 *             "AWS": f"arn:{current_get_partition.partition}:iam::{current.account_id}:root",
 *         },
 *         "Action": ["ecr:ReplicateImage"],
 *         "Resource": [f"arn:{current_get_partition&#46;partition}:ecr:{current_get_region&#46;name}:{current&#46;account_id}:repository/*"],
 *     }],
 * }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var currentGetRegion = Aws.GetRegion.Invoke();
 *     var currentGetPartition = Aws.GetPartition.Invoke();
 *     var example = new Aws.Ecr.RegistryPolicy("example", new()
 *     {
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "testpolicy",
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["AWS"] = Output.Tuple(currentGetPartition, current).Apply(values =>
 *                         {
 *                             var currentGetPartition = values.Item1;
 *                             var current = values.Item2;
 *                             return $"arn:{currentGetPartition.Apply(getPartitionResult => getPartitionResult.Partition)}:iam::{current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:root";
 *                         }),
 *                     },
 *                     ["Action"] = new[]
 *                     {
 *                         "ecr:ReplicateImage",
 *                     },
 *                     ["Resource"] = new[]
 *                     {
 *                         Output.Tuple(currentGetPartition, currentGetRegion, current).Apply(values =>
 *                         {
 *                             var currentGetPartition = values.Item1;
 *                             var currentGetRegion = values.Item2;
 *                             var current = values.Item3;
 *                             return $"arn:{currentGetPartition.Apply(getPartitionResult => getPartitionResult.Partition)}:ecr:{currentGetRegion.Apply(getRegionResult => getRegionResult.Name)}:{current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:repository/*";
 *                         }),
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		currentGetRegion, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		currentGetPartition, err := aws.GetPartition(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Sid":    "testpolicy",
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"AWS": fmt.Sprintf("arn:%v:iam::%v:root", currentGetPartition.Partition, current.AccountId),
 * 					},
 * 					"Action": []string{
 * 						"ecr:ReplicateImage",
 * 					},
 * 					"Resource": []string{
 * 						fmt.Sprintf("arn:%v:ecr:%v:%v:repository/*", currentGetPartition.Partition, currentGetRegion.Name, current.AccountId),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = ecr.NewRegistryPolicy(ctx, "example", &ecr.RegistryPolicyArgs{
 * 			Policy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.ecr.RegistryPolicy;
 * import com.pulumi.aws.ecr.RegistryPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var currentGetRegion = AwsFunctions.getRegion();
 *         final var currentGetPartition = AwsFunctions.getPartition();
 *         var example = new RegistryPolicy("example", RegistryPolicyArgs.builder()
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", "testpolicy"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", String.format("arn:%s:iam::%s:root", currentGetPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         )),
 *                         jsonProperty("Action", jsonArray("ecr:ReplicateImage")),
 *                         jsonProperty("Resource", jsonArray(String.format("arn:%s:ecr:%s:%s:repository/*", currentGetPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentGetRegion.applyValue(getRegionResult -> getRegionResult.name()),current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecr:RegistryPolicy
 *     properties:
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Sid: testpolicy
 *               Effect: Allow
 *               Principal:
 *                 AWS: arn:${currentGetPartition.partition}:iam::${current.accountId}:root
 *               Action:
 *                 - ecr:ReplicateImage
 *               Resource:
 *                 - arn:${currentGetPartition.partition}:ecr:${currentGetRegion.name}:${current.accountId}:repository/*
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   currentGetRegion:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 *   currentGetPartition:
 *     fn::invoke:
 *       Function: aws:getPartition
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECR Registry Policy using the registry id. For example:
 * ```sh
 * $ pulumi import aws:ecr/registryPolicy:RegistryPolicy example 123456789012
 * ```
 * */*/*/*/*/*/
 */
public class RegistryPolicy internal constructor(
    override val javaResource: com.pulumi.aws.ecr.RegistryPolicy,
) : KotlinCustomResource(javaResource, RegistryPolicyMapper) {
    /**
     * The policy document. This is a JSON formatted string.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The registry ID where the registry was created.
     */
    public val registryId: Output<String>
        get() = javaResource.registryId().applyValue({ args0 -> args0 })
}

public object RegistryPolicyMapper : ResourceMapper<RegistryPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecr.RegistryPolicy::class == javaResource::class

    override fun map(javaResource: Resource): RegistryPolicy = RegistryPolicy(
        javaResource as
            com.pulumi.aws.ecr.RegistryPolicy,
    )
}

/**
 * @see [RegistryPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryPolicy].
 */
public suspend fun registryPolicy(
    name: String,
    block: suspend RegistryPolicyResourceBuilder.() -> Unit,
): RegistryPolicy {
    val builder = RegistryPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryPolicy(name: String): RegistryPolicy {
    val builder = RegistryPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
