@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.RegistryScanningConfigurationArgs.builder
import com.pulumi.aws.ecr.kotlin.inputs.RegistryScanningConfigurationRuleArgs
import com.pulumi.aws.ecr.kotlin.inputs.RegistryScanningConfigurationRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Container Registry Scanning Configuration. Can't be completely deleted, instead reverts to the default `BASIC` scanning configuration without rules.
 * ## Example Usage
 * ### Basic example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const configuration = new aws.ecr.RegistryScanningConfiguration("configuration", {
 *     scanType: "ENHANCED",
 *     rules: [{
 *         scanFrequency: "CONTINUOUS_SCAN",
 *         repositoryFilters: [{
 *             filter: "example",
 *             filterType: "WILDCARD",
 *         }],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * configuration = aws.ecr.RegistryScanningConfiguration("configuration",
 *     scan_type="ENHANCED",
 *     rules=[{
 *         "scan_frequency": "CONTINUOUS_SCAN",
 *         "repository_filters": [{
 *             "filter": "example",
 *             "filter_type": "WILDCARD",
 *         }],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configuration = new Aws.Ecr.RegistryScanningConfiguration("configuration", new()
 *     {
 *         ScanType = "ENHANCED",
 *         Rules = new[]
 *         {
 *             new Aws.Ecr.Inputs.RegistryScanningConfigurationRuleArgs
 *             {
 *                 ScanFrequency = "CONTINUOUS_SCAN",
 *                 RepositoryFilters = new[]
 *                 {
 *                     new Aws.Ecr.Inputs.RegistryScanningConfigurationRuleRepositoryFilterArgs
 *                     {
 *                         Filter = "example",
 *                         FilterType = "WILDCARD",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecr.NewRegistryScanningConfiguration(ctx, "configuration", &ecr.RegistryScanningConfigurationArgs{
 * 			ScanType: pulumi.String("ENHANCED"),
 * 			Rules: ecr.RegistryScanningConfigurationRuleArray{
 * 				&ecr.RegistryScanningConfigurationRuleArgs{
 * 					ScanFrequency: pulumi.String("CONTINUOUS_SCAN"),
 * 					RepositoryFilters: ecr.RegistryScanningConfigurationRuleRepositoryFilterArray{
 * 						&ecr.RegistryScanningConfigurationRuleRepositoryFilterArgs{
 * 							Filter:     pulumi.String("example"),
 * 							FilterType: pulumi.String("WILDCARD"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.RegistryScanningConfiguration;
 * import com.pulumi.aws.ecr.RegistryScanningConfigurationArgs;
 * import com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configuration = new RegistryScanningConfiguration("configuration", RegistryScanningConfigurationArgs.builder()
 *             .scanType("ENHANCED")
 *             .rules(RegistryScanningConfigurationRuleArgs.builder()
 *                 .scanFrequency("CONTINUOUS_SCAN")
 *                 .repositoryFilters(RegistryScanningConfigurationRuleRepositoryFilterArgs.builder()
 *                     .filter("example")
 *                     .filterType("WILDCARD")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   configuration:
 *     type: aws:ecr:RegistryScanningConfiguration
 *     properties:
 *       scanType: ENHANCED
 *       rules:
 *         - scanFrequency: CONTINUOUS_SCAN
 *           repositoryFilters:
 *             - filter: example
 *               filterType: WILDCARD
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Multiple rules
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.ecr.RegistryScanningConfiguration("test", {
 *     scanType: "ENHANCED",
 *     rules: [
 *         {
 *             scanFrequency: "SCAN_ON_PUSH",
 *             repositoryFilters: [{
 *                 filter: "*",
 *                 filterType: "WILDCARD",
 *             }],
 *         },
 *         {
 *             scanFrequency: "CONTINUOUS_SCAN",
 *             repositoryFilters: [{
 *                 filter: "example",
 *                 filterType: "WILDCARD",
 *             }],
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ecr.RegistryScanningConfiguration("test",
 *     scan_type="ENHANCED",
 *     rules=[
 *         {
 *             "scan_frequency": "SCAN_ON_PUSH",
 *             "repository_filters": [{
 *                 "filter": "*",
 *                 "filter_type": "WILDCARD",
 *             }],
 *         },
 *         {
 *             "scan_frequency": "CONTINUOUS_SCAN",
 *             "repository_filters": [{
 *                 "filter": "example",
 *                 "filter_type": "WILDCARD",
 *             }],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Ecr.RegistryScanningConfiguration("test", new()
 *     {
 *         ScanType = "ENHANCED",
 *         Rules = new[]
 *         {
 *             new Aws.Ecr.Inputs.RegistryScanningConfigurationRuleArgs
 *             {
 *                 ScanFrequency = "SCAN_ON_PUSH",
 *                 RepositoryFilters = new[]
 *                 {
 *                     new Aws.Ecr.Inputs.RegistryScanningConfigurationRuleRepositoryFilterArgs
 *                     {
 *                         Filter = "*",
 *                         FilterType = "WILDCARD",
 *                     },
 *                 },
 *             },
 *             new Aws.Ecr.Inputs.RegistryScanningConfigurationRuleArgs
 *             {
 *                 ScanFrequency = "CONTINUOUS_SCAN",
 *                 RepositoryFilters = new[]
 *                 {
 *                     new Aws.Ecr.Inputs.RegistryScanningConfigurationRuleRepositoryFilterArgs
 *                     {
 *                         Filter = "example",
 *                         FilterType = "WILDCARD",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecr.NewRegistryScanningConfiguration(ctx, "test", &ecr.RegistryScanningConfigurationArgs{
 * 			ScanType: pulumi.String("ENHANCED"),
 * 			Rules: ecr.RegistryScanningConfigurationRuleArray{
 * 				&ecr.RegistryScanningConfigurationRuleArgs{
 * 					ScanFrequency: pulumi.String("SCAN_ON_PUSH"),
 * 					RepositoryFilters: ecr.RegistryScanningConfigurationRuleRepositoryFilterArray{
 * 						&ecr.RegistryScanningConfigurationRuleRepositoryFilterArgs{
 * 							Filter:     pulumi.String("*"),
 * 							FilterType: pulumi.String("WILDCARD"),
 * 						},
 * 					},
 * 				},
 * 				&ecr.RegistryScanningConfigurationRuleArgs{
 * 					ScanFrequency: pulumi.String("CONTINUOUS_SCAN"),
 * 					RepositoryFilters: ecr.RegistryScanningConfigurationRuleRepositoryFilterArray{
 * 						&ecr.RegistryScanningConfigurationRuleRepositoryFilterArgs{
 * 							Filter:     pulumi.String("example"),
 * 							FilterType: pulumi.String("WILDCARD"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.RegistryScanningConfiguration;
 * import com.pulumi.aws.ecr.RegistryScanningConfigurationArgs;
 * import com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new RegistryScanningConfiguration("test", RegistryScanningConfigurationArgs.builder()
 *             .scanType("ENHANCED")
 *             .rules(
 *                 RegistryScanningConfigurationRuleArgs.builder()
 *                     .scanFrequency("SCAN_ON_PUSH")
 *                     .repositoryFilters(RegistryScanningConfigurationRuleRepositoryFilterArgs.builder()
 *                         .filter("*")
 *                         .filterType("WILDCARD")
 *                         .build())
 *                     .build(),
 *                 RegistryScanningConfigurationRuleArgs.builder()
 *                     .scanFrequency("CONTINUOUS_SCAN")
 *                     .repositoryFilters(RegistryScanningConfigurationRuleRepositoryFilterArgs.builder()
 *                         .filter("example")
 *                         .filterType("WILDCARD")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ecr:RegistryScanningConfiguration
 *     properties:
 *       scanType: ENHANCED
 *       rules:
 *         - scanFrequency: SCAN_ON_PUSH
 *           repositoryFilters:
 *             - filter: '*'
 *               filterType: WILDCARD
 *         - scanFrequency: CONTINUOUS_SCAN
 *           repositoryFilters:
 *             - filter: example
 *               filterType: WILDCARD
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECR Scanning Configurations using the `registry_id`. For example:
 * ```sh
 * $ pulumi import aws:ecr/registryScanningConfiguration:RegistryScanningConfiguration example 012345678901
 * ```
 * @property rules One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
 * @property scanType the scanning type to set for the registry. Can be either `ENHANCED` or `BASIC`.
 */
public data class RegistryScanningConfigurationArgs(
    public val rules: Output<List<RegistryScanningConfigurationRuleArgs>>? = null,
    public val scanType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecr.RegistryScanningConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecr.RegistryScanningConfigurationArgs =
        com.pulumi.aws.ecr.RegistryScanningConfigurationArgs.builder()
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .scanType(scanType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryScanningConfigurationArgs].
 */
@PulumiTagMarker
public class RegistryScanningConfigurationArgsBuilder internal constructor() {
    private var rules: Output<List<RegistryScanningConfigurationRuleArgs>>? = null

    private var scanType: Output<String>? = null

    /**
     * @param value One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("cvdugqerufkxdywo")
    public suspend fun rules(`value`: Output<List<RegistryScanningConfigurationRuleArgs>>) {
        this.rules = value
    }

    @JvmName("lpoxhoeqskbjkdoi")
    public suspend fun rules(vararg values: Output<RegistryScanningConfigurationRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("bxqrljmdarldgrol")
    public suspend fun rules(values: List<Output<RegistryScanningConfigurationRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value the scanning type to set for the registry. Can be either `ENHANCED` or `BASIC`.
     */
    @JvmName("obnhhbbwnxxboamc")
    public suspend fun scanType(`value`: Output<String>) {
        this.scanType = value
    }

    /**
     * @param value One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("holpiwvsvejwilem")
    public suspend fun rules(`value`: List<RegistryScanningConfigurationRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("qcfmroxctdrrpgtm")
    public suspend fun rules(argument: List<suspend RegistryScanningConfigurationRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegistryScanningConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("lbhnvfiqhwbpjuag")
    public suspend fun rules(vararg argument: suspend RegistryScanningConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RegistryScanningConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("fxeibnoleewpjfgg")
    public suspend fun rules(argument: suspend RegistryScanningConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RegistryScanningConfigurationRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("dyxptyfopqtnkdcn")
    public suspend fun rules(vararg values: RegistryScanningConfigurationRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value the scanning type to set for the registry. Can be either `ENHANCED` or `BASIC`.
     */
    @JvmName("lfmyjvyttgrnwrck")
    public suspend fun scanType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanType = mapped
    }

    internal fun build(): RegistryScanningConfigurationArgs = RegistryScanningConfigurationArgs(
        rules = rules,
        scanType = scanType,
    )
}
