@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.kotlin.outputs.ReplicationConfigurationReplicationConfiguration
import com.pulumi.aws.ecr.kotlin.outputs.ReplicationConfigurationReplicationConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationConfiguration].
 */
@PulumiTagMarker
public class ReplicationConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationConfigurationArgs = ReplicationConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationConfigurationArgsBuilder.() -> Unit) {
        val builder = ReplicationConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReplicationConfiguration {
        val builtJavaResource = com.pulumi.aws.ecr.ReplicationConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicationConfiguration(builtJavaResource)
    }
}

/**
 * Provides an Elastic Container Registry Replication Configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const example = aws.getRegions({});
 * const exampleReplicationConfiguration = new aws.ecr.ReplicationConfiguration("example", {replicationConfiguration: {
 *     rules: [{
 *         destinations: [{
 *             region: example.then(example => example.names?.[0]),
 *             registryId: current.then(current => current.accountId),
 *         }],
 *     }],
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * example = aws.get_regions()
 * example_replication_configuration = aws.ecr.ReplicationConfiguration("example", replication_configuration={
 *     "rules": [{
 *         "destinations": [{
 *             "region": example.names[0],
 *             "registry_id": current.account_id,
 *         }],
 *     }],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var example = Aws.GetRegions.Invoke();
 *     var exampleReplicationConfiguration = new Aws.Ecr.ReplicationConfiguration("example", new()
 *     {
 *         ReplicationConfigurationDetails = new Aws.Ecr.Inputs.ReplicationConfigurationReplicationConfigurationArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new Aws.Ecr.Inputs.ReplicationConfigurationReplicationConfigurationRuleArgs
 *                 {
 *                     Destinations = new[]
 *                     {
 *                         new Aws.Ecr.Inputs.ReplicationConfigurationReplicationConfigurationRuleDestinationArgs
 *                         {
 *                             Region = example.Apply(getRegionsResult => getRegionsResult.Names[0]),
 *                             RegistryId = current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := aws.GetRegions(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecr.NewReplicationConfiguration(ctx, "example", &ecr.ReplicationConfigurationArgs{
 * 			ReplicationConfiguration: &ecr.ReplicationConfigurationReplicationConfigurationArgs{
 * 				Rules: ecr.ReplicationConfigurationReplicationConfigurationRuleArray{
 * 					&ecr.ReplicationConfigurationReplicationConfigurationRuleArgs{
 * 						Destinations: ecr.ReplicationConfigurationReplicationConfigurationRuleDestinationArray{
 * 							&ecr.ReplicationConfigurationReplicationConfigurationRuleDestinationArgs{
 * 								Region:     pulumi.String(example.Names[0]),
 * 								RegistryId: pulumi.String(current.AccountId),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionsArgs;
 * import com.pulumi.aws.ecr.ReplicationConfiguration;
 * import com.pulumi.aws.ecr.ReplicationConfigurationArgs;
 * import com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var example = AwsFunctions.getRegions();
 *         var exampleReplicationConfiguration = new ReplicationConfiguration("exampleReplicationConfiguration", ReplicationConfigurationArgs.builder()
 *             .replicationConfiguration(ReplicationConfigurationReplicationConfigurationArgs.builder()
 *                 .rules(ReplicationConfigurationReplicationConfigurationRuleArgs.builder()
 *                     .destinations(ReplicationConfigurationReplicationConfigurationRuleDestinationArgs.builder()
 *                         .region(example.applyValue(getRegionsResult -> getRegionsResult.names()[0]))
 *                         .registryId(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleReplicationConfiguration:
 *     type: aws:ecr:ReplicationConfiguration
 *     name: example
 *     properties:
 *       replicationConfiguration:
 *         rules:
 *           - destinations:
 *               - region: ${example.names[0]}
 *                 registryId: ${current.accountId}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   example:
 *     fn::invoke:
 *       Function: aws:getRegions
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Multiple Region Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const example = aws.getRegions({});
 * const exampleReplicationConfiguration = new aws.ecr.ReplicationConfiguration("example", {replicationConfiguration: {
 *     rules: [{
 *         destinations: [
 *             {
 *                 region: example.then(example => example.names?.[0]),
 *                 registryId: current.then(current => current.accountId),
 *             },
 *             {
 *                 region: example.then(example => example.names?.[1]),
 *                 registryId: current.then(current => current.accountId),
 *             },
 *         ],
 *     }],
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * example = aws.get_regions()
 * example_replication_configuration = aws.ecr.ReplicationConfiguration("example", replication_configuration={
 *     "rules": [{
 *         "destinations": [
 *             {
 *                 "region": example.names[0],
 *                 "registry_id": current.account_id,
 *             },
 *             {
 *                 "region": example.names[1],
 *                 "registry_id": current.account_id,
 *             },
 *         ],
 *     }],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var example = Aws.GetRegions.Invoke();
 *     var exampleReplicationConfiguration = new Aws.Ecr.ReplicationConfiguration("example", new()
 *     {
 *         ReplicationConfigurationDetails = new Aws.Ecr.Inputs.ReplicationConfigurationReplicationConfigurationArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new Aws.Ecr.Inputs.ReplicationConfigurationReplicationConfigurationRuleArgs
 *                 {
 *                     Destinations = new[]
 *                     {
 *                         new Aws.Ecr.Inputs.ReplicationConfigurationReplicationConfigurationRuleDestinationArgs
 *                         {
 *                             Region = example.Apply(getRegionsResult => getRegionsResult.Names[0]),
 *                             RegistryId = current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *                         },
 *                         new Aws.Ecr.Inputs.ReplicationConfigurationReplicationConfigurationRuleDestinationArgs
 *                         {
 *                             Region = example.Apply(getRegionsResult => getRegionsResult.Names[1]),
 *                             RegistryId = current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := aws.GetRegions(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecr.NewReplicationConfiguration(ctx, "example", &ecr.ReplicationConfigurationArgs{
 * 			ReplicationConfiguration: &ecr.ReplicationConfigurationReplicationConfigurationArgs{
 * 				Rules: ecr.ReplicationConfigurationReplicationConfigurationRuleArray{
 * 					&ecr.ReplicationConfigurationReplicationConfigurationRuleArgs{
 * 						Destinations: ecr.ReplicationConfigurationReplicationConfigurationRuleDestinationArray{
 * 							&ecr.ReplicationConfigurationReplicationConfigurationRuleDestinationArgs{
 * 								Region:     pulumi.String(example.Names[0]),
 * 								RegistryId: pulumi.String(current.AccountId),
 * 							},
 * 							&ecr.ReplicationConfigurationReplicationConfigurationRuleDestinationArgs{
 * 								Region:     pulumi.String(example.Names[1]),
 * 								RegistryId: pulumi.String(current.AccountId),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionsArgs;
 * import com.pulumi.aws.ecr.ReplicationConfiguration;
 * import com.pulumi.aws.ecr.ReplicationConfigurationArgs;
 * import com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var example = AwsFunctions.getRegions();
 *         var exampleReplicationConfiguration = new ReplicationConfiguration("exampleReplicationConfiguration", ReplicationConfigurationArgs.builder()
 *             .replicationConfiguration(ReplicationConfigurationReplicationConfigurationArgs.builder()
 *                 .rules(ReplicationConfigurationReplicationConfigurationRuleArgs.builder()
 *                     .destinations(
 *                         ReplicationConfigurationReplicationConfigurationRuleDestinationArgs.builder()
 *                             .region(example.applyValue(getRegionsResult -> getRegionsResult.names()[0]))
 *                             .registryId(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                             .build(),
 *                         ReplicationConfigurationReplicationConfigurationRuleDestinationArgs.builder()
 *                             .region(example.applyValue(getRegionsResult -> getRegionsResult.names()[1]))
 *                             .registryId(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleReplicationConfiguration:
 *     type: aws:ecr:ReplicationConfiguration
 *     name: example
 *     properties:
 *       replicationConfiguration:
 *         rules:
 *           - destinations:
 *               - region: ${example.names[0]}
 *                 registryId: ${current.accountId}
 *               - region: ${example.names[1]}
 *                 registryId: ${current.accountId}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   example:
 *     fn::invoke:
 *       Function: aws:getRegions
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Repository Filter Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const example = aws.getRegions({});
 * const exampleReplicationConfiguration = new aws.ecr.ReplicationConfiguration("example", {replicationConfiguration: {
 *     rules: [{
 *         destinations: [{
 *             region: example.then(example => example.names?.[0]),
 *             registryId: current.then(current => current.accountId),
 *         }],
 *         repositoryFilters: [{
 *             filter: "prod-microservice",
 *             filterType: "PREFIX_MATCH",
 *         }],
 *     }],
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * example = aws.get_regions()
 * example_replication_configuration = aws.ecr.ReplicationConfiguration("example", replication_configuration={
 *     "rules": [{
 *         "destinations": [{
 *             "region": example.names[0],
 *             "registry_id": current.account_id,
 *         }],
 *         "repository_filters": [{
 *             "filter": "prod-microservice",
 *             "filter_type": "PREFIX_MATCH",
 *         }],
 *     }],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var example = Aws.GetRegions.Invoke();
 *     var exampleReplicationConfiguration = new Aws.Ecr.ReplicationConfiguration("example", new()
 *     {
 *         ReplicationConfigurationDetails = new Aws.Ecr.Inputs.ReplicationConfigurationReplicationConfigurationArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new Aws.Ecr.Inputs.ReplicationConfigurationReplicationConfigurationRuleArgs
 *                 {
 *                     Destinations = new[]
 *                     {
 *                         new Aws.Ecr.Inputs.ReplicationConfigurationReplicationConfigurationRuleDestinationArgs
 *                         {
 *                             Region = example.Apply(getRegionsResult => getRegionsResult.Names[0]),
 *                             RegistryId = current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *                         },
 *                     },
 *                     RepositoryFilters = new[]
 *                     {
 *                         new Aws.Ecr.Inputs.ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs
 *                         {
 *                             Filter = "prod-microservice",
 *                             FilterType = "PREFIX_MATCH",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := aws.GetRegions(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecr.NewReplicationConfiguration(ctx, "example", &ecr.ReplicationConfigurationArgs{
 * 			ReplicationConfiguration: &ecr.ReplicationConfigurationReplicationConfigurationArgs{
 * 				Rules: ecr.ReplicationConfigurationReplicationConfigurationRuleArray{
 * 					&ecr.ReplicationConfigurationReplicationConfigurationRuleArgs{
 * 						Destinations: ecr.ReplicationConfigurationReplicationConfigurationRuleDestinationArray{
 * 							&ecr.ReplicationConfigurationReplicationConfigurationRuleDestinationArgs{
 * 								Region:     pulumi.String(example.Names[0]),
 * 								RegistryId: pulumi.String(current.AccountId),
 * 							},
 * 						},
 * 						RepositoryFilters: ecr.ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArray{
 * 							&ecr.ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs{
 * 								Filter:     pulumi.String("prod-microservice"),
 * 								FilterType: pulumi.String("PREFIX_MATCH"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionsArgs;
 * import com.pulumi.aws.ecr.ReplicationConfiguration;
 * import com.pulumi.aws.ecr.ReplicationConfigurationArgs;
 * import com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var example = AwsFunctions.getRegions();
 *         var exampleReplicationConfiguration = new ReplicationConfiguration("exampleReplicationConfiguration", ReplicationConfigurationArgs.builder()
 *             .replicationConfiguration(ReplicationConfigurationReplicationConfigurationArgs.builder()
 *                 .rules(ReplicationConfigurationReplicationConfigurationRuleArgs.builder()
 *                     .destinations(ReplicationConfigurationReplicationConfigurationRuleDestinationArgs.builder()
 *                         .region(example.applyValue(getRegionsResult -> getRegionsResult.names()[0]))
 *                         .registryId(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                         .build())
 *                     .repositoryFilters(ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs.builder()
 *                         .filter("prod-microservice")
 *                         .filterType("PREFIX_MATCH")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleReplicationConfiguration:
 *     type: aws:ecr:ReplicationConfiguration
 *     name: example
 *     properties:
 *       replicationConfiguration:
 *         rules:
 *           - destinations:
 *               - region: ${example.names[0]}
 *                 registryId: ${current.accountId}
 *             repositoryFilters:
 *               - filter: prod-microservice
 *                 filterType: PREFIX_MATCH
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   example:
 *     fn::invoke:
 *       Function: aws:getRegions
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECR Replication Configuration using the `registry_id`. For example:
 * ```sh
 * $ pulumi import aws:ecr/replicationConfiguration:ReplicationConfiguration service 012345678912
 * ```
 */
public class ReplicationConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.ecr.ReplicationConfiguration,
) : KotlinCustomResource(javaResource, ReplicationConfigurationMapper) {
    /**
     * The registry ID where the replication configuration was created.
     */
    public val registryId: Output<String>
        get() = javaResource.registryId().applyValue({ args0 -> args0 })

    /**
     * Replication configuration for a registry. See Replication Configuration.
     */
    public val replicationConfiguration: Output<ReplicationConfigurationReplicationConfiguration>?
        get() = javaResource.replicationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })
}

public object ReplicationConfigurationMapper : ResourceMapper<ReplicationConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecr.ReplicationConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationConfiguration =
        ReplicationConfiguration(javaResource as com.pulumi.aws.ecr.ReplicationConfiguration)
}

/**
 * @see [ReplicationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationConfiguration].
 */
public suspend fun replicationConfiguration(
    name: String,
    block: suspend ReplicationConfigurationResourceBuilder.() -> Unit,
): ReplicationConfiguration {
    val builder = ReplicationConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationConfiguration(name: String): ReplicationConfiguration {
    val builder = ReplicationConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
