@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.RepositoryArgs.builder
import com.pulumi.aws.ecr.kotlin.inputs.RepositoryEncryptionConfigurationArgs
import com.pulumi.aws.ecr.kotlin.inputs.RepositoryEncryptionConfigurationArgsBuilder
import com.pulumi.aws.ecr.kotlin.inputs.RepositoryImageScanningConfigurationArgs
import com.pulumi.aws.ecr.kotlin.inputs.RepositoryImageScanningConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Container Registry Repository.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.ecr.Repository("foo", {
 *     name: "bar",
 *     imageTagMutability: "MUTABLE",
 *     imageScanningConfiguration: {
 *         scanOnPush: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.ecr.Repository("foo",
 *     name="bar",
 *     image_tag_mutability="MUTABLE",
 *     image_scanning_configuration={
 *         "scan_on_push": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.Ecr.Repository("foo", new()
 *     {
 *         Name = "bar",
 *         ImageTagMutability = "MUTABLE",
 *         ImageScanningConfiguration = new Aws.Ecr.Inputs.RepositoryImageScanningConfigurationArgs
 *         {
 *             ScanOnPush = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecr.NewRepository(ctx, "foo", &ecr.RepositoryArgs{
 * 			Name:               pulumi.String("bar"),
 * 			ImageTagMutability: pulumi.String("MUTABLE"),
 * 			ImageScanningConfiguration: &ecr.RepositoryImageScanningConfigurationArgs{
 * 				ScanOnPush: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.Repository;
 * import com.pulumi.aws.ecr.RepositoryArgs;
 * import com.pulumi.aws.ecr.inputs.RepositoryImageScanningConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Repository("foo", RepositoryArgs.builder()
 *             .name("bar")
 *             .imageTagMutability("MUTABLE")
 *             .imageScanningConfiguration(RepositoryImageScanningConfigurationArgs.builder()
 *                 .scanOnPush(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:ecr:Repository
 *     properties:
 *       name: bar
 *       imageTagMutability: MUTABLE
 *       imageScanningConfiguration:
 *         scanOnPush: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECR Repositories using the `name`. For example:
 * ```sh
 * $ pulumi import aws:ecr/repository:Repository service test-service
 * ```
 * @property encryptionConfigurations Encryption configuration for the repository. See below for schema.
 * @property forceDelete If `true`, will delete the repository even if it contains images.
 * Defaults to `false`.
 * @property imageScanningConfiguration Configuration block that defines image scanning configuration for the repository. By default, image scanning must be manually triggered. See the [ECR User Guide](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html) for more information about image scanning.
 * @property imageTagMutability The tag mutability setting for the repository. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
 * @property name Name of the repository.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RepositoryArgs(
    public val encryptionConfigurations: Output<List<RepositoryEncryptionConfigurationArgs>>? = null,
    public val forceDelete: Output<Boolean>? = null,
    public val imageScanningConfiguration: Output<RepositoryImageScanningConfigurationArgs>? = null,
    public val imageTagMutability: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecr.RepositoryArgs> {
    override fun toJava(): com.pulumi.aws.ecr.RepositoryArgs =
        com.pulumi.aws.ecr.RepositoryArgs.builder()
            .encryptionConfigurations(
                encryptionConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .forceDelete(forceDelete?.applyValue({ args0 -> args0 }))
            .imageScanningConfiguration(
                imageScanningConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .imageTagMutability(imageTagMutability?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RepositoryArgs].
 */
@PulumiTagMarker
public class RepositoryArgsBuilder internal constructor() {
    private var encryptionConfigurations: Output<List<RepositoryEncryptionConfigurationArgs>>? = null

    private var forceDelete: Output<Boolean>? = null

    private var imageScanningConfiguration: Output<RepositoryImageScanningConfigurationArgs>? = null

    private var imageTagMutability: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Encryption configuration for the repository. See below for schema.
     */
    @JvmName("fqeynrjvmkoylvpo")
    public suspend fun encryptionConfigurations(`value`: Output<List<RepositoryEncryptionConfigurationArgs>>) {
        this.encryptionConfigurations = value
    }

    @JvmName("owkvuqtxkfntgrxh")
    public suspend fun encryptionConfigurations(vararg values: Output<RepositoryEncryptionConfigurationArgs>) {
        this.encryptionConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Encryption configuration for the repository. See below for schema.
     */
    @JvmName("ghocmiunmmprywog")
    public suspend fun encryptionConfigurations(values: List<Output<RepositoryEncryptionConfigurationArgs>>) {
        this.encryptionConfigurations = Output.all(values)
    }

    /**
     * @param value If `true`, will delete the repository even if it contains images.
     * Defaults to `false`.
     */
    @JvmName("lhhaclddilvqgokp")
    public suspend fun forceDelete(`value`: Output<Boolean>) {
        this.forceDelete = value
    }

    /**
     * @param value Configuration block that defines image scanning configuration for the repository. By default, image scanning must be manually triggered. See the [ECR User Guide](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html) for more information about image scanning.
     */
    @JvmName("qkwknifdnruyrhas")
    public suspend fun imageScanningConfiguration(`value`: Output<RepositoryImageScanningConfigurationArgs>) {
        this.imageScanningConfiguration = value
    }

    /**
     * @param value The tag mutability setting for the repository. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
     */
    @JvmName("yshkkkmsoucilyfu")
    public suspend fun imageTagMutability(`value`: Output<String>) {
        this.imageTagMutability = value
    }

    /**
     * @param value Name of the repository.
     */
    @JvmName("bcxwxpbxqoaefbid")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bjmsrfntakaivbrp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Encryption configuration for the repository. See below for schema.
     */
    @JvmName("gfgydqtjfpdvkeva")
    public suspend fun encryptionConfigurations(`value`: List<RepositoryEncryptionConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfigurations = mapped
    }

    /**
     * @param argument Encryption configuration for the repository. See below for schema.
     */
    @JvmName("nyhmvqjkslilmnxu")
    public suspend fun encryptionConfigurations(argument: List<suspend RepositoryEncryptionConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RepositoryEncryptionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.encryptionConfigurations = mapped
    }

    /**
     * @param argument Encryption configuration for the repository. See below for schema.
     */
    @JvmName("fcvndeceqrfmkclr")
    public suspend fun encryptionConfigurations(vararg argument: suspend RepositoryEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RepositoryEncryptionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.encryptionConfigurations = mapped
    }

    /**
     * @param argument Encryption configuration for the repository. See below for schema.
     */
    @JvmName("jomigsiddiwvcuss")
    public suspend fun encryptionConfigurations(argument: suspend RepositoryEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RepositoryEncryptionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.encryptionConfigurations = mapped
    }

    /**
     * @param values Encryption configuration for the repository. See below for schema.
     */
    @JvmName("gebcpgwxvnyelaqv")
    public suspend fun encryptionConfigurations(vararg values: RepositoryEncryptionConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionConfigurations = mapped
    }

    /**
     * @param value If `true`, will delete the repository even if it contains images.
     * Defaults to `false`.
     */
    @JvmName("ujrkcbuggftalrwh")
    public suspend fun forceDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDelete = mapped
    }

    /**
     * @param value Configuration block that defines image scanning configuration for the repository. By default, image scanning must be manually triggered. See the [ECR User Guide](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html) for more information about image scanning.
     */
    @JvmName("okdosyudrtpwgmok")
    public suspend fun imageScanningConfiguration(`value`: RepositoryImageScanningConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageScanningConfiguration = mapped
    }

    /**
     * @param argument Configuration block that defines image scanning configuration for the repository. By default, image scanning must be manually triggered. See the [ECR User Guide](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html) for more information about image scanning.
     */
    @JvmName("jajjsdfwmpleotxe")
    public suspend fun imageScanningConfiguration(argument: suspend RepositoryImageScanningConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryImageScanningConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.imageScanningConfiguration = mapped
    }

    /**
     * @param value The tag mutability setting for the repository. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
     */
    @JvmName("fjbewtrdykykijsm")
    public suspend fun imageTagMutability(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageTagMutability = mapped
    }

    /**
     * @param value Name of the repository.
     */
    @JvmName("cctgiebyqsxbibti")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lhkjpfhtsbqwkddf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gyagdwleqbhptmdq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RepositoryArgs = RepositoryArgs(
        encryptionConfigurations = encryptionConfigurations,
        forceDelete = forceDelete,
        imageScanningConfiguration = imageScanningConfiguration,
        imageTagMutability = imageTagMutability,
        name = name,
        tags = tags,
    )
}
