@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.kotlin.outputs.RepositoryCreationTemplateEncryptionConfiguration
import com.pulumi.aws.ecr.kotlin.outputs.RepositoryCreationTemplateEncryptionConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [RepositoryCreationTemplate].
 */
@PulumiTagMarker
public class RepositoryCreationTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RepositoryCreationTemplateArgs = RepositoryCreationTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RepositoryCreationTemplateArgsBuilder.() -> Unit) {
        val builder = RepositoryCreationTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RepositoryCreationTemplate {
        val builtJavaResource = com.pulumi.aws.ecr.RepositoryCreationTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RepositoryCreationTemplate(builtJavaResource)
    }
}

/**
 * Provides an Elastic Container Registry Repository Creation Template.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "new policy",
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: ["123456789012"],
 *         }],
 *         actions: [
 *             "ecr:GetDownloadUrlForLayer",
 *             "ecr:BatchGetImage",
 *             "ecr:BatchCheckLayerAvailability",
 *             "ecr:PutImage",
 *             "ecr:InitiateLayerUpload",
 *             "ecr:UploadLayerPart",
 *             "ecr:CompleteLayerUpload",
 *             "ecr:DescribeRepositories",
 *             "ecr:GetRepositoryPolicy",
 *             "ecr:ListImages",
 *             "ecr:DeleteRepository",
 *             "ecr:BatchDeleteImage",
 *             "ecr:SetRepositoryPolicy",
 *             "ecr:DeleteRepositoryPolicy",
 *         ],
 *     }],
 * });
 * const exampleRepositoryCreationTemplate = new aws.ecr.RepositoryCreationTemplate("example", {
 *     prefix: "example",
 *     description: "An example template",
 *     imageTagMutability: "IMMUTABLE",
 *     customRoleArn: "arn:aws:iam::123456789012:role/example",
 *     appliedFors: ["PULL_THROUGH_CACHE"],
 *     encryptionConfigurations: [{
 *         encryptionType: "AES256",
 *     }],
 *     repositoryPolicy: example.then(example => example.json),
 *     lifecyclePolicy: `{
 *   "rules": [
 *     {
 *       "rulePriority": 1,
 *       "description": "Expire images older than 14 days",
 *       "selection": {
 *         "tagStatus": "untagged",
 *         "countType": "sinceImagePushed",
 *         "countUnit": "days",
 *         "countNumber": 14
 *       },
 *       "action": {
 *         "type": "expire"
 *       }
 *     }
 *   ]
 * }
 * `,
 *     resourceTags: {
 *         Foo: "Bar",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iam.get_policy_document(statements=[{
 *     "sid": "new policy",
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": ["123456789012"],
 *     }],
 *     "actions": [
 *         "ecr:GetDownloadUrlForLayer",
 *         "ecr:BatchGetImage",
 *         "ecr:BatchCheckLayerAvailability",
 *         "ecr:PutImage",
 *         "ecr:InitiateLayerUpload",
 *         "ecr:UploadLayerPart",
 *         "ecr:CompleteLayerUpload",
 *         "ecr:DescribeRepositories",
 *         "ecr:GetRepositoryPolicy",
 *         "ecr:ListImages",
 *         "ecr:DeleteRepository",
 *         "ecr:BatchDeleteImage",
 *         "ecr:SetRepositoryPolicy",
 *         "ecr:DeleteRepositoryPolicy",
 *     ],
 * }])
 * example_repository_creation_template = aws.ecr.RepositoryCreationTemplate("example",
 *     prefix="example",
 *     description="An example template",
 *     image_tag_mutability="IMMUTABLE",
 *     custom_role_arn="arn:aws:iam::123456789012:role/example",
 *     applied_fors=["PULL_THROUGH_CACHE"],
 *     encryption_configurations=[{
 *         "encryption_type": "AES256",
 *     }],
 *     repository_policy=example.json,
 *     lifecycle_policy="""{
 *   "rules": [
 *     {
 *       "rulePriority": 1,
 *       "description": "Expire images older than 14 days",
 *       "selection": {
 *         "tagStatus": "untagged",
 *         "countType": "sinceImagePushed",
 *         "countUnit": "days",
 *         "countNumber": 14
 *       },
 *       "action": {
 *         "type": "expire"
 *       }
 *     }
 *   ]
 * }
 * """,
 *     resource_tags={
 *         "Foo": "Bar",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "new policy",
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "123456789012",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "ecr:GetDownloadUrlForLayer",
 *                     "ecr:BatchGetImage",
 *                     "ecr:BatchCheckLayerAvailability",
 *                     "ecr:PutImage",
 *                     "ecr:InitiateLayerUpload",
 *                     "ecr:UploadLayerPart",
 *                     "ecr:CompleteLayerUpload",
 *                     "ecr:DescribeRepositories",
 *                     "ecr:GetRepositoryPolicy",
 *                     "ecr:ListImages",
 *                     "ecr:DeleteRepository",
 *                     "ecr:BatchDeleteImage",
 *                     "ecr:SetRepositoryPolicy",
 *                     "ecr:DeleteRepositoryPolicy",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRepositoryCreationTemplate = new Aws.Ecr.RepositoryCreationTemplate("example", new()
 *     {
 *         Prefix = "example",
 *         Description = "An example template",
 *         ImageTagMutability = "IMMUTABLE",
 *         CustomRoleArn = "arn:aws:iam::123456789012:role/example",
 *         AppliedFors = new[]
 *         {
 *             "PULL_THROUGH_CACHE",
 *         },
 *         EncryptionConfigurations = new[]
 *         {
 *             new Aws.Ecr.Inputs.RepositoryCreationTemplateEncryptionConfigurationArgs
 *             {
 *                 EncryptionType = "AES256",
 *             },
 *         },
 *         RepositoryPolicy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         LifecyclePolicy = @"{
 *   ""rules"": [
 *     {
 *       ""rulePriority"": 1,
 *       ""description"": ""Expire images older than 14 days"",
 *       ""selection"": {
 *         ""tagStatus"": ""untagged"",
 *         ""countType"": ""sinceImagePushed"",
 *         ""countUnit"": ""days"",
 *         ""countNumber"": 14
 *       },
 *       ""action"": {
 *         ""type"": ""expire""
 *       }
 *     }
 *   ]
 * }
 * ",
 *         ResourceTags =
 *         {
 *             { "Foo", "Bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid:    pulumi.StringRef("new policy"),
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "AWS",
 * 							Identifiers: []string{
 * 								"123456789012",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"ecr:GetDownloadUrlForLayer",
 * 						"ecr:BatchGetImage",
 * 						"ecr:BatchCheckLayerAvailability",
 * 						"ecr:PutImage",
 * 						"ecr:InitiateLayerUpload",
 * 						"ecr:UploadLayerPart",
 * 						"ecr:CompleteLayerUpload",
 * 						"ecr:DescribeRepositories",
 * 						"ecr:GetRepositoryPolicy",
 * 						"ecr:ListImages",
 * 						"ecr:DeleteRepository",
 * 						"ecr:BatchDeleteImage",
 * 						"ecr:SetRepositoryPolicy",
 * 						"ecr:DeleteRepositoryPolicy",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecr.NewRepositoryCreationTemplate(ctx, "example", &ecr.RepositoryCreationTemplateArgs{
 * 			Prefix:             pulumi.String("example"),
 * 			Description:        pulumi.String("An example template"),
 * 			ImageTagMutability: pulumi.String("IMMUTABLE"),
 * 			CustomRoleArn:      pulumi.String("arn:aws:iam::123456789012:role/example"),
 * 			AppliedFors: pulumi.StringArray{
 * 				pulumi.String("PULL_THROUGH_CACHE"),
 * 			},
 * 			EncryptionConfigurations: ecr.RepositoryCreationTemplateEncryptionConfigurationArray{
 * 				&ecr.RepositoryCreationTemplateEncryptionConfigurationArgs{
 * 					EncryptionType: pulumi.String("AES256"),
 * 				},
 * 			},
 * 			RepositoryPolicy: pulumi.String(example.Json),
 * 			LifecyclePolicy: pulumi.String(`{
 *   "rules": [
 *     {
 *       "rulePriority": 1,
 *       "description": "Expire images older than 14 days",
 *       "selection": {
 *         "tagStatus": "untagged",
 *         "countType": "sinceImagePushed",
 *         "countUnit": "days",
 *         "countNumber": 14
 *       },
 *       "action": {
 *         "type": "expire"
 *       }
 *     }
 *   ]
 * }
 * `),
 * 			ResourceTags: pulumi.StringMap{
 * 				"Foo": pulumi.String("Bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ecr.RepositoryCreationTemplate;
 * import com.pulumi.aws.ecr.RepositoryCreationTemplateArgs;
 * import com.pulumi.aws.ecr.inputs.RepositoryCreationTemplateEncryptionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("new policy")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .actions(
 *                     "ecr:GetDownloadUrlForLayer",
 *                     "ecr:BatchGetImage",
 *                     "ecr:BatchCheckLayerAvailability",
 *                     "ecr:PutImage",
 *                     "ecr:InitiateLayerUpload",
 *                     "ecr:UploadLayerPart",
 *                     "ecr:CompleteLayerUpload",
 *                     "ecr:DescribeRepositories",
 *                     "ecr:GetRepositoryPolicy",
 *                     "ecr:ListImages",
 *                     "ecr:DeleteRepository",
 *                     "ecr:BatchDeleteImage",
 *                     "ecr:SetRepositoryPolicy",
 *                     "ecr:DeleteRepositoryPolicy")
 *                 .build())
 *             .build());
 *         var exampleRepositoryCreationTemplate = new RepositoryCreationTemplate("exampleRepositoryCreationTemplate", RepositoryCreationTemplateArgs.builder()
 *             .prefix("example")
 *             .description("An example template")
 *             .imageTagMutability("IMMUTABLE")
 *             .customRoleArn("arn:aws:iam::123456789012:role/example")
 *             .appliedFors("PULL_THROUGH_CACHE")
 *             .encryptionConfigurations(RepositoryCreationTemplateEncryptionConfigurationArgs.builder()
 *                 .encryptionType("AES256")
 *                 .build())
 *             .repositoryPolicy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .lifecyclePolicy("""
 * {
 *   "rules": [
 *     {
 *       "rulePriority": 1,
 *       "description": "Expire images older than 14 days",
 *       "selection": {
 *         "tagStatus": "untagged",
 *         "countType": "sinceImagePushed",
 *         "countUnit": "days",
 *         "countNumber": 14
 *       },
 *       "action": {
 *         "type": "expire"
 *       }
 *     }
 *   ]
 * }
 *             """)
 *             .resourceTags(Map.of("Foo", "Bar"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleRepositoryCreationTemplate:
 *     type: aws:ecr:RepositoryCreationTemplate
 *     name: example
 *     properties:
 *       prefix: example
 *       description: An example template
 *       imageTagMutability: IMMUTABLE
 *       customRoleArn: arn:aws:iam::123456789012:role/example
 *       appliedFors:
 *         - PULL_THROUGH_CACHE
 *       encryptionConfigurations:
 *         - encryptionType: AES256
 *       repositoryPolicy: ${example.json}
 *       lifecyclePolicy: |
 *         {
 *           "rules": [
 *             {
 *               "rulePriority": 1,
 *               "description": "Expire images older than 14 days",
 *               "selection": {
 *                 "tagStatus": "untagged",
 *                 "countType": "sinceImagePushed",
 *                 "countUnit": "days",
 *                 "countNumber": 14
 *               },
 *               "action": {
 *                 "type": "expire"
 *               }
 *             }
 *           ]
 *         }
 *       resourceTags:
 *         Foo: Bar
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: new policy
 *             effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '123456789012'
 *             actions:
 *               - ecr:GetDownloadUrlForLayer
 *               - ecr:BatchGetImage
 *               - ecr:BatchCheckLayerAvailability
 *               - ecr:PutImage
 *               - ecr:InitiateLayerUpload
 *               - ecr:UploadLayerPart
 *               - ecr:CompleteLayerUpload
 *               - ecr:DescribeRepositories
 *               - ecr:GetRepositoryPolicy
 *               - ecr:ListImages
 *               - ecr:DeleteRepository
 *               - ecr:BatchDeleteImage
 *               - ecr:SetRepositoryPolicy
 *               - ecr:DeleteRepositoryPolicy
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the ECR Repository Creating Templates using the `prefix`. For example:
 * ```sh
 * $ pulumi import aws:ecr/repositoryCreationTemplate:RepositoryCreationTemplate example example
 * ```
 */
public class RepositoryCreationTemplate internal constructor(
    override val javaResource: com.pulumi.aws.ecr.RepositoryCreationTemplate,
) : KotlinCustomResource(javaResource, RepositoryCreationTemplateMapper) {
    /**
     * Which features this template applies to. Must contain one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
     */
    public val appliedFors: Output<List<String>>
        get() = javaResource.appliedFors().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A custom IAM role to use for repository creation. Required if using repository tags or KMS encryption.
     */
    public val customRoleArn: Output<String>?
        get() = javaResource.customRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description for this template.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Encryption configuration for any created repositories. See below for schema.
     */
    public val encryptionConfigurations:
        Output<List<RepositoryCreationTemplateEncryptionConfiguration>>?
        get() = javaResource.encryptionConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The tag mutability setting for any created repositories. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
     */
    public val imageTagMutability: Output<String>?
        get() = javaResource.imageTagMutability().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The lifecycle policy document to apply to any created repositories. See more details about [Policy Parameters](http://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html#lifecycle_policy_parameters) in the official AWS docs. Consider using the `aws.ecr.getLifecyclePolicyDocument` data_source to generate/manage the JSON document used for the `lifecycle_policy` argument.
     */
    public val lifecyclePolicy: Output<String>?
        get() = javaResource.lifecyclePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The repository name prefix to match against. Use `ROOT` to match any prefix that doesn't explicitly match another template.
     */
    public val prefix: Output<String>
        get() = javaResource.prefix().applyValue({ args0 -> args0 })

    /**
     * The registry ID the repository creation template applies to.
     */
    public val registryId: Output<String>
        get() = javaResource.registryId().applyValue({ args0 -> args0 })

    public val repositoryPolicy: Output<String>?
        get() = javaResource.repositoryPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to any created repositories.
     */
    public val resourceTags: Output<Map<String, String>>?
        get() = javaResource.resourceTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object RepositoryCreationTemplateMapper : ResourceMapper<RepositoryCreationTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecr.RepositoryCreationTemplate::class == javaResource::class

    override fun map(javaResource: Resource): RepositoryCreationTemplate =
        RepositoryCreationTemplate(javaResource as com.pulumi.aws.ecr.RepositoryCreationTemplate)
}

/**
 * @see [RepositoryCreationTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RepositoryCreationTemplate].
 */
public suspend fun repositoryCreationTemplate(
    name: String,
    block: suspend RepositoryCreationTemplateResourceBuilder.() -> Unit,
): RepositoryCreationTemplate {
    val builder = RepositoryCreationTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RepositoryCreationTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun repositoryCreationTemplate(name: String): RepositoryCreationTemplate {
    val builder = RepositoryCreationTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
