@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.RepositoryCreationTemplateArgs.builder
import com.pulumi.aws.ecr.kotlin.inputs.RepositoryCreationTemplateEncryptionConfigurationArgs
import com.pulumi.aws.ecr.kotlin.inputs.RepositoryCreationTemplateEncryptionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Container Registry Repository Creation Template.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "new policy",
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: ["123456789012"],
 *         }],
 *         actions: [
 *             "ecr:GetDownloadUrlForLayer",
 *             "ecr:BatchGetImage",
 *             "ecr:BatchCheckLayerAvailability",
 *             "ecr:PutImage",
 *             "ecr:InitiateLayerUpload",
 *             "ecr:UploadLayerPart",
 *             "ecr:CompleteLayerUpload",
 *             "ecr:DescribeRepositories",
 *             "ecr:GetRepositoryPolicy",
 *             "ecr:ListImages",
 *             "ecr:DeleteRepository",
 *             "ecr:BatchDeleteImage",
 *             "ecr:SetRepositoryPolicy",
 *             "ecr:DeleteRepositoryPolicy",
 *         ],
 *     }],
 * });
 * const exampleRepositoryCreationTemplate = new aws.ecr.RepositoryCreationTemplate("example", {
 *     prefix: "example",
 *     description: "An example template",
 *     imageTagMutability: "IMMUTABLE",
 *     customRoleArn: "arn:aws:iam::123456789012:role/example",
 *     appliedFors: ["PULL_THROUGH_CACHE"],
 *     encryptionConfigurations: [{
 *         encryptionType: "AES256",
 *     }],
 *     repositoryPolicy: example.then(example => example.json),
 *     lifecyclePolicy: `{
 *   "rules": [
 *     {
 *       "rulePriority": 1,
 *       "description": "Expire images older than 14 days",
 *       "selection": {
 *         "tagStatus": "untagged",
 *         "countType": "sinceImagePushed",
 *         "countUnit": "days",
 *         "countNumber": 14
 *       },
 *       "action": {
 *         "type": "expire"
 *       }
 *     }
 *   ]
 * }
 * `,
 *     resourceTags: {
 *         Foo: "Bar",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iam.get_policy_document(statements=[{
 *     "sid": "new policy",
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": ["123456789012"],
 *     }],
 *     "actions": [
 *         "ecr:GetDownloadUrlForLayer",
 *         "ecr:BatchGetImage",
 *         "ecr:BatchCheckLayerAvailability",
 *         "ecr:PutImage",
 *         "ecr:InitiateLayerUpload",
 *         "ecr:UploadLayerPart",
 *         "ecr:CompleteLayerUpload",
 *         "ecr:DescribeRepositories",
 *         "ecr:GetRepositoryPolicy",
 *         "ecr:ListImages",
 *         "ecr:DeleteRepository",
 *         "ecr:BatchDeleteImage",
 *         "ecr:SetRepositoryPolicy",
 *         "ecr:DeleteRepositoryPolicy",
 *     ],
 * }])
 * example_repository_creation_template = aws.ecr.RepositoryCreationTemplate("example",
 *     prefix="example",
 *     description="An example template",
 *     image_tag_mutability="IMMUTABLE",
 *     custom_role_arn="arn:aws:iam::123456789012:role/example",
 *     applied_fors=["PULL_THROUGH_CACHE"],
 *     encryption_configurations=[{
 *         "encryption_type": "AES256",
 *     }],
 *     repository_policy=example.json,
 *     lifecycle_policy="""{
 *   "rules": [
 *     {
 *       "rulePriority": 1,
 *       "description": "Expire images older than 14 days",
 *       "selection": {
 *         "tagStatus": "untagged",
 *         "countType": "sinceImagePushed",
 *         "countUnit": "days",
 *         "countNumber": 14
 *       },
 *       "action": {
 *         "type": "expire"
 *       }
 *     }
 *   ]
 * }
 * """,
 *     resource_tags={
 *         "Foo": "Bar",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "new policy",
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "123456789012",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "ecr:GetDownloadUrlForLayer",
 *                     "ecr:BatchGetImage",
 *                     "ecr:BatchCheckLayerAvailability",
 *                     "ecr:PutImage",
 *                     "ecr:InitiateLayerUpload",
 *                     "ecr:UploadLayerPart",
 *                     "ecr:CompleteLayerUpload",
 *                     "ecr:DescribeRepositories",
 *                     "ecr:GetRepositoryPolicy",
 *                     "ecr:ListImages",
 *                     "ecr:DeleteRepository",
 *                     "ecr:BatchDeleteImage",
 *                     "ecr:SetRepositoryPolicy",
 *                     "ecr:DeleteRepositoryPolicy",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRepositoryCreationTemplate = new Aws.Ecr.RepositoryCreationTemplate("example", new()
 *     {
 *         Prefix = "example",
 *         Description = "An example template",
 *         ImageTagMutability = "IMMUTABLE",
 *         CustomRoleArn = "arn:aws:iam::123456789012:role/example",
 *         AppliedFors = new[]
 *         {
 *             "PULL_THROUGH_CACHE",
 *         },
 *         EncryptionConfigurations = new[]
 *         {
 *             new Aws.Ecr.Inputs.RepositoryCreationTemplateEncryptionConfigurationArgs
 *             {
 *                 EncryptionType = "AES256",
 *             },
 *         },
 *         RepositoryPolicy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         LifecyclePolicy = @"{
 *   ""rules"": [
 *     {
 *       ""rulePriority"": 1,
 *       ""description"": ""Expire images older than 14 days"",
 *       ""selection"": {
 *         ""tagStatus"": ""untagged"",
 *         ""countType"": ""sinceImagePushed"",
 *         ""countUnit"": ""days"",
 *         ""countNumber"": 14
 *       },
 *       ""action"": {
 *         ""type"": ""expire""
 *       }
 *     }
 *   ]
 * }
 * ",
 *         ResourceTags =
 *         {
 *             { "Foo", "Bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid:    pulumi.StringRef("new policy"),
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "AWS",
 * 							Identifiers: []string{
 * 								"123456789012",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"ecr:GetDownloadUrlForLayer",
 * 						"ecr:BatchGetImage",
 * 						"ecr:BatchCheckLayerAvailability",
 * 						"ecr:PutImage",
 * 						"ecr:InitiateLayerUpload",
 * 						"ecr:UploadLayerPart",
 * 						"ecr:CompleteLayerUpload",
 * 						"ecr:DescribeRepositories",
 * 						"ecr:GetRepositoryPolicy",
 * 						"ecr:ListImages",
 * 						"ecr:DeleteRepository",
 * 						"ecr:BatchDeleteImage",
 * 						"ecr:SetRepositoryPolicy",
 * 						"ecr:DeleteRepositoryPolicy",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecr.NewRepositoryCreationTemplate(ctx, "example", &ecr.RepositoryCreationTemplateArgs{
 * 			Prefix:             pulumi.String("example"),
 * 			Description:        pulumi.String("An example template"),
 * 			ImageTagMutability: pulumi.String("IMMUTABLE"),
 * 			CustomRoleArn:      pulumi.String("arn:aws:iam::123456789012:role/example"),
 * 			AppliedFors: pulumi.StringArray{
 * 				pulumi.String("PULL_THROUGH_CACHE"),
 * 			},
 * 			EncryptionConfigurations: ecr.RepositoryCreationTemplateEncryptionConfigurationArray{
 * 				&ecr.RepositoryCreationTemplateEncryptionConfigurationArgs{
 * 					EncryptionType: pulumi.String("AES256"),
 * 				},
 * 			},
 * 			RepositoryPolicy: pulumi.String(example.Json),
 * 			LifecyclePolicy: pulumi.String(`{
 *   "rules": [
 *     {
 *       "rulePriority": 1,
 *       "description": "Expire images older than 14 days",
 *       "selection": {
 *         "tagStatus": "untagged",
 *         "countType": "sinceImagePushed",
 *         "countUnit": "days",
 *         "countNumber": 14
 *       },
 *       "action": {
 *         "type": "expire"
 *       }
 *     }
 *   ]
 * }
 * `),
 * 			ResourceTags: pulumi.StringMap{
 * 				"Foo": pulumi.String("Bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ecr.RepositoryCreationTemplate;
 * import com.pulumi.aws.ecr.RepositoryCreationTemplateArgs;
 * import com.pulumi.aws.ecr.inputs.RepositoryCreationTemplateEncryptionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("new policy")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .actions(
 *                     "ecr:GetDownloadUrlForLayer",
 *                     "ecr:BatchGetImage",
 *                     "ecr:BatchCheckLayerAvailability",
 *                     "ecr:PutImage",
 *                     "ecr:InitiateLayerUpload",
 *                     "ecr:UploadLayerPart",
 *                     "ecr:CompleteLayerUpload",
 *                     "ecr:DescribeRepositories",
 *                     "ecr:GetRepositoryPolicy",
 *                     "ecr:ListImages",
 *                     "ecr:DeleteRepository",
 *                     "ecr:BatchDeleteImage",
 *                     "ecr:SetRepositoryPolicy",
 *                     "ecr:DeleteRepositoryPolicy")
 *                 .build())
 *             .build());
 *         var exampleRepositoryCreationTemplate = new RepositoryCreationTemplate("exampleRepositoryCreationTemplate", RepositoryCreationTemplateArgs.builder()
 *             .prefix("example")
 *             .description("An example template")
 *             .imageTagMutability("IMMUTABLE")
 *             .customRoleArn("arn:aws:iam::123456789012:role/example")
 *             .appliedFors("PULL_THROUGH_CACHE")
 *             .encryptionConfigurations(RepositoryCreationTemplateEncryptionConfigurationArgs.builder()
 *                 .encryptionType("AES256")
 *                 .build())
 *             .repositoryPolicy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .lifecyclePolicy("""
 * {
 *   "rules": [
 *     {
 *       "rulePriority": 1,
 *       "description": "Expire images older than 14 days",
 *       "selection": {
 *         "tagStatus": "untagged",
 *         "countType": "sinceImagePushed",
 *         "countUnit": "days",
 *         "countNumber": 14
 *       },
 *       "action": {
 *         "type": "expire"
 *       }
 *     }
 *   ]
 * }
 *             """)
 *             .resourceTags(Map.of("Foo", "Bar"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleRepositoryCreationTemplate:
 *     type: aws:ecr:RepositoryCreationTemplate
 *     name: example
 *     properties:
 *       prefix: example
 *       description: An example template
 *       imageTagMutability: IMMUTABLE
 *       customRoleArn: arn:aws:iam::123456789012:role/example
 *       appliedFors:
 *         - PULL_THROUGH_CACHE
 *       encryptionConfigurations:
 *         - encryptionType: AES256
 *       repositoryPolicy: ${example.json}
 *       lifecyclePolicy: |
 *         {
 *           "rules": [
 *             {
 *               "rulePriority": 1,
 *               "description": "Expire images older than 14 days",
 *               "selection": {
 *                 "tagStatus": "untagged",
 *                 "countType": "sinceImagePushed",
 *                 "countUnit": "days",
 *                 "countNumber": 14
 *               },
 *               "action": {
 *                 "type": "expire"
 *               }
 *             }
 *           ]
 *         }
 *       resourceTags:
 *         Foo: Bar
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: new policy
 *             effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '123456789012'
 *             actions:
 *               - ecr:GetDownloadUrlForLayer
 *               - ecr:BatchGetImage
 *               - ecr:BatchCheckLayerAvailability
 *               - ecr:PutImage
 *               - ecr:InitiateLayerUpload
 *               - ecr:UploadLayerPart
 *               - ecr:CompleteLayerUpload
 *               - ecr:DescribeRepositories
 *               - ecr:GetRepositoryPolicy
 *               - ecr:ListImages
 *               - ecr:DeleteRepository
 *               - ecr:BatchDeleteImage
 *               - ecr:SetRepositoryPolicy
 *               - ecr:DeleteRepositoryPolicy
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the ECR Repository Creating Templates using the `prefix`. For example:
 * ```sh
 * $ pulumi import aws:ecr/repositoryCreationTemplate:RepositoryCreationTemplate example example
 * ```
 * @property appliedFors Which features this template applies to. Must contain one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
 * @property customRoleArn A custom IAM role to use for repository creation. Required if using repository tags or KMS encryption.
 * @property description The description for this template.
 * @property encryptionConfigurations Encryption configuration for any created repositories. See below for schema.
 * @property imageTagMutability The tag mutability setting for any created repositories. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
 * @property lifecyclePolicy The lifecycle policy document to apply to any created repositories. See more details about [Policy Parameters](http://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html#lifecycle_policy_parameters) in the official AWS docs. Consider using the `aws.ecr.getLifecyclePolicyDocument` data_source to generate/manage the JSON document used for the `lifecycle_policy` argument.
 * @property prefix The repository name prefix to match against. Use `ROOT` to match any prefix that doesn't explicitly match another template.
 * @property repositoryPolicy
 * @property resourceTags A map of tags to assign to any created repositories.
 */
public data class RepositoryCreationTemplateArgs(
    public val appliedFors: Output<List<String>>? = null,
    public val customRoleArn: Output<String>? = null,
    public val description: Output<String>? = null,
    public val encryptionConfigurations: Output<List<RepositoryCreationTemplateEncryptionConfigurationArgs>>? = null,
    public val imageTagMutability: Output<String>? = null,
    public val lifecyclePolicy: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val repositoryPolicy: Output<String>? = null,
    public val resourceTags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecr.RepositoryCreationTemplateArgs> {
    override fun toJava(): com.pulumi.aws.ecr.RepositoryCreationTemplateArgs =
        com.pulumi.aws.ecr.RepositoryCreationTemplateArgs.builder()
            .appliedFors(appliedFors?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customRoleArn(customRoleArn?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptionConfigurations(
                encryptionConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .imageTagMutability(imageTagMutability?.applyValue({ args0 -> args0 }))
            .lifecyclePolicy(lifecyclePolicy?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .repositoryPolicy(repositoryPolicy?.applyValue({ args0 -> args0 }))
            .resourceTags(
                resourceTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RepositoryCreationTemplateArgs].
 */
@PulumiTagMarker
public class RepositoryCreationTemplateArgsBuilder internal constructor() {
    private var appliedFors: Output<List<String>>? = null

    private var customRoleArn: Output<String>? = null

    private var description: Output<String>? = null

    private var encryptionConfigurations:
        Output<List<RepositoryCreationTemplateEncryptionConfigurationArgs>>? = null

    private var imageTagMutability: Output<String>? = null

    private var lifecyclePolicy: Output<String>? = null

    private var prefix: Output<String>? = null

    private var repositoryPolicy: Output<String>? = null

    private var resourceTags: Output<Map<String, String>>? = null

    /**
     * @param value Which features this template applies to. Must contain one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
     */
    @JvmName("npcrniyccikpkaer")
    public suspend fun appliedFors(`value`: Output<List<String>>) {
        this.appliedFors = value
    }

    @JvmName("jjijimubthenapaw")
    public suspend fun appliedFors(vararg values: Output<String>) {
        this.appliedFors = Output.all(values.asList())
    }

    /**
     * @param values Which features this template applies to. Must contain one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
     */
    @JvmName("dnhdwitvhwvchnxw")
    public suspend fun appliedFors(values: List<Output<String>>) {
        this.appliedFors = Output.all(values)
    }

    /**
     * @param value A custom IAM role to use for repository creation. Required if using repository tags or KMS encryption.
     */
    @JvmName("pqiskidqjqglnhjo")
    public suspend fun customRoleArn(`value`: Output<String>) {
        this.customRoleArn = value
    }

    /**
     * @param value The description for this template.
     */
    @JvmName("ofgpiaualygfkqhu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Encryption configuration for any created repositories. See below for schema.
     */
    @JvmName("adiculjupnjkdhpi")
    public suspend fun encryptionConfigurations(`value`: Output<List<RepositoryCreationTemplateEncryptionConfigurationArgs>>) {
        this.encryptionConfigurations = value
    }

    @JvmName("psoskmcpujjcaemx")
    public suspend fun encryptionConfigurations(vararg values: Output<RepositoryCreationTemplateEncryptionConfigurationArgs>) {
        this.encryptionConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Encryption configuration for any created repositories. See below for schema.
     */
    @JvmName("kshlebjbydikqone")
    public suspend fun encryptionConfigurations(values: List<Output<RepositoryCreationTemplateEncryptionConfigurationArgs>>) {
        this.encryptionConfigurations = Output.all(values)
    }

    /**
     * @param value The tag mutability setting for any created repositories. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
     */
    @JvmName("sqgcidtxckljjubk")
    public suspend fun imageTagMutability(`value`: Output<String>) {
        this.imageTagMutability = value
    }

    /**
     * @param value The lifecycle policy document to apply to any created repositories. See more details about [Policy Parameters](http://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html#lifecycle_policy_parameters) in the official AWS docs. Consider using the `aws.ecr.getLifecyclePolicyDocument` data_source to generate/manage the JSON document used for the `lifecycle_policy` argument.
     */
    @JvmName("uhkpnhhypiywuraj")
    public suspend fun lifecyclePolicy(`value`: Output<String>) {
        this.lifecyclePolicy = value
    }

    /**
     * @param value The repository name prefix to match against. Use `ROOT` to match any prefix that doesn't explicitly match another template.
     */
    @JvmName("bacnchkcgqxlyeau")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value
     */
    @JvmName("rduyuiylydswvsby")
    public suspend fun repositoryPolicy(`value`: Output<String>) {
        this.repositoryPolicy = value
    }

    /**
     * @param value A map of tags to assign to any created repositories.
     */
    @JvmName("wsmvnymqmpcwypgl")
    public suspend fun resourceTags(`value`: Output<Map<String, String>>) {
        this.resourceTags = value
    }

    /**
     * @param value Which features this template applies to. Must contain one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
     */
    @JvmName("kngtiojrrqpkaycx")
    public suspend fun appliedFors(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appliedFors = mapped
    }

    /**
     * @param values Which features this template applies to. Must contain one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
     */
    @JvmName("cndijbmkjgjbxcqx")
    public suspend fun appliedFors(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appliedFors = mapped
    }

    /**
     * @param value A custom IAM role to use for repository creation. Required if using repository tags or KMS encryption.
     */
    @JvmName("djripknxcynnfkim")
    public suspend fun customRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRoleArn = mapped
    }

    /**
     * @param value The description for this template.
     */
    @JvmName("dajasiopnmqxuefr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Encryption configuration for any created repositories. See below for schema.
     */
    @JvmName("cgcwhbtlpoqkbree")
    public suspend fun encryptionConfigurations(`value`: List<RepositoryCreationTemplateEncryptionConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfigurations = mapped
    }

    /**
     * @param argument Encryption configuration for any created repositories. See below for schema.
     */
    @JvmName("fqjqpreatararbkv")
    public suspend fun encryptionConfigurations(argument: List<suspend RepositoryCreationTemplateEncryptionConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RepositoryCreationTemplateEncryptionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.encryptionConfigurations = mapped
    }

    /**
     * @param argument Encryption configuration for any created repositories. See below for schema.
     */
    @JvmName("ddofghmtgecbokgm")
    public suspend fun encryptionConfigurations(vararg argument: suspend RepositoryCreationTemplateEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RepositoryCreationTemplateEncryptionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.encryptionConfigurations = mapped
    }

    /**
     * @param argument Encryption configuration for any created repositories. See below for schema.
     */
    @JvmName("vjbcahneeongcxpk")
    public suspend fun encryptionConfigurations(argument: suspend RepositoryCreationTemplateEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RepositoryCreationTemplateEncryptionConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.encryptionConfigurations = mapped
    }

    /**
     * @param values Encryption configuration for any created repositories. See below for schema.
     */
    @JvmName("ggujupmraptdlgor")
    public suspend fun encryptionConfigurations(vararg values: RepositoryCreationTemplateEncryptionConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionConfigurations = mapped
    }

    /**
     * @param value The tag mutability setting for any created repositories. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
     */
    @JvmName("ifxemhpyfkujpfto")
    public suspend fun imageTagMutability(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageTagMutability = mapped
    }

    /**
     * @param value The lifecycle policy document to apply to any created repositories. See more details about [Policy Parameters](http://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html#lifecycle_policy_parameters) in the official AWS docs. Consider using the `aws.ecr.getLifecyclePolicyDocument` data_source to generate/manage the JSON document used for the `lifecycle_policy` argument.
     */
    @JvmName("whowrghabiuwnnwr")
    public suspend fun lifecyclePolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecyclePolicy = mapped
    }

    /**
     * @param value The repository name prefix to match against. Use `ROOT` to match any prefix that doesn't explicitly match another template.
     */
    @JvmName("caurhcvchhmpuoxq")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("epnocwcvvxwqporc")
    public suspend fun repositoryPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryPolicy = mapped
    }

    /**
     * @param value A map of tags to assign to any created repositories.
     */
    @JvmName("qyydpxxgbilqstru")
    public suspend fun resourceTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param values A map of tags to assign to any created repositories.
     */
    @JvmName("ygytlddjrcagikuc")
    public fun resourceTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    internal fun build(): RepositoryCreationTemplateArgs = RepositoryCreationTemplateArgs(
        appliedFors = appliedFors,
        customRoleArn = customRoleArn,
        description = description,
        encryptionConfigurations = encryptionConfigurations,
        imageTagMutability = imageTagMutability,
        lifecyclePolicy = lifecyclePolicy,
        prefix = prefix,
        repositoryPolicy = repositoryPolicy,
        resourceTags = resourceTags,
    )
}
