@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.GetCredentialsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCredentials.
 * @property registryId
 */
public data class GetCredentialsPlainArgs(
    public val registryId: String,
) : ConvertibleToJava<com.pulumi.aws.ecr.inputs.GetCredentialsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ecr.inputs.GetCredentialsPlainArgs =
        com.pulumi.aws.ecr.inputs.GetCredentialsPlainArgs.builder()
            .registryId(registryId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCredentialsPlainArgs].
 */
@PulumiTagMarker
public class GetCredentialsPlainArgsBuilder internal constructor() {
    private var registryId: String? = null

    /**
     * @param value
     */
    @JvmName("nuebhsyvfjhmaskv")
    public suspend fun registryId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryId = mapped
    }

    internal fun build(): GetCredentialsPlainArgs = GetCredentialsPlainArgs(
        registryId = registryId ?: throw PulumiNullFieldException("registryId"),
    )
}
