@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.GetImagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getImage.
 * @property imageDigest Sha256 digest of the image manifest. At least one of `image_digest`, `image_tag`, or `most_recent` must be specified.
 * @property imageTag Tag associated with this image. At least one of `image_digest`, `image_tag`, or `most_recent` must be specified.
 * @property mostRecent Return the most recently pushed image. At least one of `image_digest`, `image_tag`, or `most_recent` must be specified.
 * @property registryId ID of the Registry where the repository resides.
 * @property repositoryName Name of the ECR Repository.
 */
public data class GetImagePlainArgs(
    public val imageDigest: String? = null,
    public val imageTag: String? = null,
    public val mostRecent: Boolean? = null,
    public val registryId: String? = null,
    public val repositoryName: String,
) : ConvertibleToJava<com.pulumi.aws.ecr.inputs.GetImagePlainArgs> {
    override fun toJava(): com.pulumi.aws.ecr.inputs.GetImagePlainArgs =
        com.pulumi.aws.ecr.inputs.GetImagePlainArgs.builder()
            .imageDigest(imageDigest?.let({ args0 -> args0 }))
            .imageTag(imageTag?.let({ args0 -> args0 }))
            .mostRecent(mostRecent?.let({ args0 -> args0 }))
            .registryId(registryId?.let({ args0 -> args0 }))
            .repositoryName(repositoryName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImagePlainArgs].
 */
@PulumiTagMarker
public class GetImagePlainArgsBuilder internal constructor() {
    private var imageDigest: String? = null

    private var imageTag: String? = null

    private var mostRecent: Boolean? = null

    private var registryId: String? = null

    private var repositoryName: String? = null

    /**
     * @param value Sha256 digest of the image manifest. At least one of `image_digest`, `image_tag`, or `most_recent` must be specified.
     */
    @JvmName("wvokspiiovvqrqfe")
    public suspend fun imageDigest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageDigest = mapped
    }

    /**
     * @param value Tag associated with this image. At least one of `image_digest`, `image_tag`, or `most_recent` must be specified.
     */
    @JvmName("tfvvjowqgrtysbmq")
    public suspend fun imageTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageTag = mapped
    }

    /**
     * @param value Return the most recently pushed image. At least one of `image_digest`, `image_tag`, or `most_recent` must be specified.
     */
    @JvmName("pnaiulkuqnjgtece")
    public suspend fun mostRecent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mostRecent = mapped
    }

    /**
     * @param value ID of the Registry where the repository resides.
     */
    @JvmName("kxmpymodrtcuwcmb")
    public suspend fun registryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.registryId = mapped
    }

    /**
     * @param value Name of the ECR Repository.
     */
    @JvmName("grecsptvncqijxth")
    public suspend fun repositoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.repositoryName = mapped
    }

    internal fun build(): GetImagePlainArgs = GetImagePlainArgs(
        imageDigest = imageDigest,
        imageTag = imageTag,
        mostRecent = mostRecent,
        registryId = registryId,
        repositoryName = repositoryName ?: throw PulumiNullFieldException("repositoryName"),
    )
}
