@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.GetLifecyclePolicyDocumentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLifecyclePolicyDocument.
 * @property rules
 */
public data class GetLifecyclePolicyDocumentPlainArgs(
    public val rules: List<GetLifecyclePolicyDocumentRule>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecr.inputs.GetLifecyclePolicyDocumentPlainArgs> {
    override fun toJava(): com.pulumi.aws.ecr.inputs.GetLifecyclePolicyDocumentPlainArgs =
        com.pulumi.aws.ecr.inputs.GetLifecyclePolicyDocumentPlainArgs.builder()
            .rules(rules?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) })).build()
}

/**
 * Builder for [GetLifecyclePolicyDocumentPlainArgs].
 */
@PulumiTagMarker
public class GetLifecyclePolicyDocumentPlainArgsBuilder internal constructor() {
    private var rules: List<GetLifecyclePolicyDocumentRule>? = null

    /**
     * @param value
     */
    @JvmName("xfvbpkncufhbsxdr")
    public suspend fun rules(`value`: List<GetLifecyclePolicyDocumentRule>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.rules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cvlgvaturheshnlf")
    public suspend fun rules(argument: List<suspend GetLifecyclePolicyDocumentRuleBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetLifecyclePolicyDocumentRuleBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.rules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fgwepyfsfauteoah")
    public suspend fun rules(vararg argument: suspend GetLifecyclePolicyDocumentRuleBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetLifecyclePolicyDocumentRuleBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.rules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dwmonemqxxtqmsvg")
    public suspend fun rules(argument: suspend GetLifecyclePolicyDocumentRuleBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetLifecyclePolicyDocumentRuleBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.rules = mapped
    }

    /**
     * @param values
     */
    @JvmName("hrgcdnscxjlkujmq")
    public suspend fun rules(vararg values: GetLifecyclePolicyDocumentRule) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.rules = mapped
    }

    internal fun build(): GetLifecyclePolicyDocumentPlainArgs = GetLifecyclePolicyDocumentPlainArgs(
        rules = rules,
    )
}
