@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.GetLifecyclePolicyDocumentRuleAction.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The supported value is `expire`.
 */
public data class GetLifecyclePolicyDocumentRuleAction(
    public val type: String,
) : ConvertibleToJava<com.pulumi.aws.ecr.inputs.GetLifecyclePolicyDocumentRuleAction> {
    override fun toJava(): com.pulumi.aws.ecr.inputs.GetLifecyclePolicyDocumentRuleAction =
        com.pulumi.aws.ecr.inputs.GetLifecyclePolicyDocumentRuleAction.builder()
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLifecyclePolicyDocumentRuleAction].
 */
@PulumiTagMarker
public class GetLifecyclePolicyDocumentRuleActionBuilder internal constructor() {
    private var type: String? = null

    /**
     * @param value The supported value is `expire`.
     */
    @JvmName("hscjjofibubsmysk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetLifecyclePolicyDocumentRuleAction = GetLifecyclePolicyDocumentRuleAction(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
