@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.GetPullThroughCacheRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPullThroughCacheRule.
 * @property ecrRepositoryPrefix The repository name prefix to use when caching images from the source registry.
 */
public data class GetPullThroughCacheRulePlainArgs(
    public val ecrRepositoryPrefix: String,
) : ConvertibleToJava<com.pulumi.aws.ecr.inputs.GetPullThroughCacheRulePlainArgs> {
    override fun toJava(): com.pulumi.aws.ecr.inputs.GetPullThroughCacheRulePlainArgs =
        com.pulumi.aws.ecr.inputs.GetPullThroughCacheRulePlainArgs.builder()
            .ecrRepositoryPrefix(ecrRepositoryPrefix.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPullThroughCacheRulePlainArgs].
 */
@PulumiTagMarker
public class GetPullThroughCacheRulePlainArgsBuilder internal constructor() {
    private var ecrRepositoryPrefix: String? = null

    /**
     * @param value The repository name prefix to use when caching images from the source registry.
     */
    @JvmName("jkthtafkeyemyqgn")
    public suspend fun ecrRepositoryPrefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ecrRepositoryPrefix = mapped
    }

    internal fun build(): GetPullThroughCacheRulePlainArgs = GetPullThroughCacheRulePlainArgs(
        ecrRepositoryPrefix = ecrRepositoryPrefix ?: throw PulumiNullFieldException("ecrRepositoryPrefix"),
    )
}
