@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.GetRepositoryCreationTemplatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRepositoryCreationTemplate.
 * @property prefix The repository name prefix that the template matches against.
 * @property resourceTags A map of tags to assign to any created repositories.
 */
public data class GetRepositoryCreationTemplatePlainArgs(
    public val prefix: String,
    public val resourceTags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecr.inputs.GetRepositoryCreationTemplatePlainArgs> {
    override fun toJava(): com.pulumi.aws.ecr.inputs.GetRepositoryCreationTemplatePlainArgs =
        com.pulumi.aws.ecr.inputs.GetRepositoryCreationTemplatePlainArgs.builder()
            .prefix(prefix.let({ args0 -> args0 }))
            .resourceTags(
                resourceTags?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GetRepositoryCreationTemplatePlainArgs].
 */
@PulumiTagMarker
public class GetRepositoryCreationTemplatePlainArgsBuilder internal constructor() {
    private var prefix: String? = null

    private var resourceTags: Map<String, String>? = null

    /**
     * @param value The repository name prefix that the template matches against.
     */
    @JvmName("hjpfhdgftfvhrpmg")
    public suspend fun prefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.prefix = mapped
    }

    /**
     * @param value A map of tags to assign to any created repositories.
     */
    @JvmName("qpihejmkijggeibt")
    public suspend fun resourceTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceTags = mapped
    }

    /**
     * @param values A map of tags to assign to any created repositories.
     */
    @JvmName("hocialyiboaarcin")
    public fun resourceTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceTags = mapped
    }

    internal fun build(): GetRepositoryCreationTemplatePlainArgs =
        GetRepositoryCreationTemplatePlainArgs(
            prefix = prefix ?: throw PulumiNullFieldException("prefix"),
            resourceTags = resourceTags,
        )
}
