@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationRuleDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property region A Region to replicate to.
 * @property registryId The account ID of the destination registry to replicate to.
 */
public data class ReplicationConfigurationReplicationConfigurationRuleDestinationArgs(
    public val region: Output<String>,
    public val registryId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationRuleDestinationArgs> {
    override fun toJava(): com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationRuleDestinationArgs =
        com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationRuleDestinationArgs.builder()
            .region(region.applyValue({ args0 -> args0 }))
            .registryId(registryId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationConfigurationReplicationConfigurationRuleDestinationArgs].
 */
@PulumiTagMarker
public class ReplicationConfigurationReplicationConfigurationRuleDestinationArgsBuilder internal constructor() {
    private var region: Output<String>? = null

    private var registryId: Output<String>? = null

    /**
     * @param value A Region to replicate to.
     */
    @JvmName("jnrypaguqpbfrmis")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The account ID of the destination registry to replicate to.
     */
    @JvmName("ijjxvtdxmshqkemb")
    public suspend fun registryId(`value`: Output<String>) {
        this.registryId = value
    }

    /**
     * @param value A Region to replicate to.
     */
    @JvmName("brlgpgoahdlhpnqq")
    public suspend fun region(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The account ID of the destination registry to replicate to.
     */
    @JvmName("siqerwjvtlesxnnq")
    public suspend fun registryId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registryId = mapped
    }

    internal fun build(): ReplicationConfigurationReplicationConfigurationRuleDestinationArgs =
        ReplicationConfigurationReplicationConfigurationRuleDestinationArgs(
            region = region ?: throw PulumiNullFieldException("region"),
            registryId = registryId ?: throw PulumiNullFieldException("registryId"),
        )
}
