@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.inputs

import com.pulumi.aws.ecr.inputs.RepositoryEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionType The encryption type to use for the repository. Valid values are `AES256` or `KMS`. Defaults to `AES256`.
 * @property kmsKey The ARN of the KMS key to use when `encryption_type` is `KMS`. If not specified, uses the default AWS managed key for ECR.
 */
public data class RepositoryEncryptionConfigurationArgs(
    public val encryptionType: Output<String>? = null,
    public val kmsKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecr.inputs.RepositoryEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecr.inputs.RepositoryEncryptionConfigurationArgs =
        com.pulumi.aws.ecr.inputs.RepositoryEncryptionConfigurationArgs.builder()
            .encryptionType(encryptionType?.applyValue({ args0 -> args0 }))
            .kmsKey(kmsKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class RepositoryEncryptionConfigurationArgsBuilder internal constructor() {
    private var encryptionType: Output<String>? = null

    private var kmsKey: Output<String>? = null

    /**
     * @param value The encryption type to use for the repository. Valid values are `AES256` or `KMS`. Defaults to `AES256`.
     */
    @JvmName("qspsprjlamjkclje")
    public suspend fun encryptionType(`value`: Output<String>) {
        this.encryptionType = value
    }

    /**
     * @param value The ARN of the KMS key to use when `encryption_type` is `KMS`. If not specified, uses the default AWS managed key for ECR.
     */
    @JvmName("aroksfpsbbwcfkdv")
    public suspend fun kmsKey(`value`: Output<String>) {
        this.kmsKey = value
    }

    /**
     * @param value The encryption type to use for the repository. Valid values are `AES256` or `KMS`. Defaults to `AES256`.
     */
    @JvmName("impbmifncwafyxjj")
    public suspend fun encryptionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value The ARN of the KMS key to use when `encryption_type` is `KMS`. If not specified, uses the default AWS managed key for ECR.
     */
    @JvmName("mipmlekaiuepoads")
    public suspend fun kmsKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKey = mapped
    }

    internal fun build(): RepositoryEncryptionConfigurationArgs =
        RepositoryEncryptionConfigurationArgs(
            encryptionType = encryptionType,
            kmsKey = kmsKey,
        )
}
