@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getCredentials.
 * @property authorizationToken
 * @property expiresAt
 * @property id The provider-assigned unique ID for this managed resource.
 * @property proxyEndpoint
 * @property registryId
 */
public data class GetCredentialsResult(
    public val authorizationToken: String,
    public val expiresAt: String,
    public val id: String,
    public val proxyEndpoint: String,
    public val registryId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecr.outputs.GetCredentialsResult): GetCredentialsResult = GetCredentialsResult(
            authorizationToken = javaType.authorizationToken(),
            expiresAt = javaType.expiresAt(),
            id = javaType.id(),
            proxyEndpoint = javaType.proxyEndpoint(),
            registryId = javaType.registryId(),
        )
    }
}
