@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getLifecyclePolicyDocument.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property json The above arguments serialized as a standard JSON policy document.
 * @property rules
 */
public data class GetLifecyclePolicyDocumentResult(
    public val id: String,
    public val json: String,
    public val rules: List<GetLifecyclePolicyDocumentRule>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecr.outputs.GetLifecyclePolicyDocumentResult): GetLifecyclePolicyDocumentResult = GetLifecyclePolicyDocumentResult(
            id = javaType.id(),
            json = javaType.json(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecr.kotlin.outputs.GetLifecyclePolicyDocumentRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
