@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action Specifies the action type.
 * @property description Describes the purpose of a rule within a lifecycle policy.
 * @property priority Sets the order in which rules are evaluated, lowest to highest. When you add rules to a lifecycle policy, you must give them each a unique value for `priority`. Values do not need to be sequential across rules in a policy. A rule with a `tag_status` value of "any" must have the highest value for `priority` and be evaluated last.
 * @property selection Collects parameters describing the selection criteria for the ECR lifecycle policy:
 */
public data class GetLifecyclePolicyDocumentRule(
    public val action: GetLifecyclePolicyDocumentRuleAction? = null,
    public val description: String? = null,
    public val priority: Int,
    public val selection: GetLifecyclePolicyDocumentRuleSelection? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecr.outputs.GetLifecyclePolicyDocumentRule): GetLifecyclePolicyDocumentRule = GetLifecyclePolicyDocumentRule(
            action = javaType.action().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecr.kotlin.outputs.GetLifecyclePolicyDocumentRuleAction.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority(),
            selection = javaType.selection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecr.kotlin.outputs.GetLifecyclePolicyDocumentRuleSelection.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
