@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getPullThroughCacheRule.
 * @property credentialArn ARN of the Secret which will be used to authenticate against the registry.
 * @property ecrRepositoryPrefix
 * @property id The provider-assigned unique ID for this managed resource.
 * @property registryId The registry ID where the repository was created.
 * @property upstreamRegistryUrl The registry URL of the upstream public registry to use as the source.
 */
public data class GetPullThroughCacheRuleResult(
    public val credentialArn: String,
    public val ecrRepositoryPrefix: String,
    public val id: String,
    public val registryId: String,
    public val upstreamRegistryUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecr.outputs.GetPullThroughCacheRuleResult): GetPullThroughCacheRuleResult = GetPullThroughCacheRuleResult(
            credentialArn = javaType.credentialArn(),
            ecrRepositoryPrefix = javaType.ecrRepositoryPrefix(),
            id = javaType.id(),
            registryId = javaType.registryId(),
            upstreamRegistryUrl = javaType.upstreamRegistryUrl(),
        )
    }
}
