@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRepositories.
 * @property id AWS Region.
 * @property names A list if AWS Elastic Container Registries for the region.
 */
public data class GetRepositoriesResult(
    public val id: String,
    public val names: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecr.outputs.GetRepositoriesResult): GetRepositoriesResult = GetRepositoriesResult(
            id = javaType.id(),
            names = javaType.names().map({ args0 -> args0 }),
        )
    }
}
