@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getRepositoryCreationTemplate.
 * @property appliedFors Which features this template applies to. Contains one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
 * @property customRoleArn The ARN of the custom role used for repository creation.
 * @property description The description for this template.
 * @property encryptionConfigurations Encryption configuration for any created repositories. See Encryption Configuration below.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property imageTagMutability The tag mutability setting for any created repositories.
 * @property lifecyclePolicy The lifecycle policy document to apply to any created repositories.
 * @property prefix
 * @property registryId The registry ID the repository creation template applies to.
 * @property repositoryPolicy The registry policy document to apply to any created repositories.
 * @property resourceTags A map of tags to assign to any created repositories.
 */
public data class GetRepositoryCreationTemplateResult(
    public val appliedFors: List<String>,
    public val customRoleArn: String,
    public val description: String,
    public val encryptionConfigurations: List<GetRepositoryCreationTemplateEncryptionConfiguration>,
    public val id: String,
    public val imageTagMutability: String,
    public val lifecyclePolicy: String,
    public val prefix: String,
    public val registryId: String,
    public val repositoryPolicy: String,
    public val resourceTags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecr.outputs.GetRepositoryCreationTemplateResult): GetRepositoryCreationTemplateResult = GetRepositoryCreationTemplateResult(
            appliedFors = javaType.appliedFors().map({ args0 -> args0 }),
            customRoleArn = javaType.customRoleArn(),
            description = javaType.description(),
            encryptionConfigurations = javaType.encryptionConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecr.kotlin.outputs.GetRepositoryCreationTemplateEncryptionConfiguration.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            imageTagMutability = javaType.imageTagMutability(),
            lifecyclePolicy = javaType.lifecyclePolicy(),
            prefix = javaType.prefix(),
            registryId = javaType.registryId(),
            repositoryPolicy = javaType.repositoryPolicy(),
            resourceTags = javaType.resourceTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
