@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property encryptionType Encryption type to use for the repository, either `AES256` or `KMS`.
 * @property kmsKey If `encryption_type` is `KMS`, the ARN of the KMS key used.
 */
public data class GetRepositoryEncryptionConfiguration(
    public val encryptionType: String,
    public val kmsKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecr.outputs.GetRepositoryEncryptionConfiguration): GetRepositoryEncryptionConfiguration = GetRepositoryEncryptionConfiguration(
            encryptionType = javaType.encryptionType(),
            kmsKey = javaType.kmsKey(),
        )
    }
}
