@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property repositoryFilters One or more repository filter blocks, containing a `filter` (required string filtering repositories, see pattern regex [here](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_ScanningRepositoryFilter.html)) and a `filter_type` (required string, currently only `WILDCARD` is supported).
 * @property scanFrequency The frequency that scans are performed at for a private registry. Can be `SCAN_ON_PUSH`, `CONTINUOUS_SCAN`, or `MANUAL`.
 */
public data class RegistryScanningConfigurationRule(
    public val repositoryFilters: List<RegistryScanningConfigurationRuleRepositoryFilter>,
    public val scanFrequency: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecr.outputs.RegistryScanningConfigurationRule): RegistryScanningConfigurationRule = RegistryScanningConfigurationRule(
            repositoryFilters = javaType.repositoryFilters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecr.kotlin.outputs.RegistryScanningConfigurationRuleRepositoryFilter.Companion.toKotlin(args0)
                })
            }),
            scanFrequency = javaType.scanFrequency(),
        )
    }
}
