@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecrpublic.kotlin

import com.pulumi.aws.ecrpublic.RepositoryArgs.builder
import com.pulumi.aws.ecrpublic.kotlin.inputs.RepositoryCatalogDataArgs
import com.pulumi.aws.ecrpublic.kotlin.inputs.RepositoryCatalogDataArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Public Elastic Container Registry Repository.
 * > **NOTE:** This resource can only be used in the `us-east-1` region.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const foo = new aws.ecrpublic.Repository("foo", {
 *     repositoryName: "bar",
 *     catalogData: {
 *         aboutText: "About Text",
 *         architectures: ["ARM"],
 *         description: "Description",
 *         logoImageBlob: std.filebase64({
 *             input: png,
 *         }).then(invoke => invoke.result),
 *         operatingSystems: ["Linux"],
 *         usageText: "Usage Text",
 *     },
 *     tags: {
 *         env: "production",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * foo = aws.ecrpublic.Repository("foo",
 *     repository_name="bar",
 *     catalog_data={
 *         "about_text": "About Text",
 *         "architectures": ["ARM"],
 *         "description": "Description",
 *         "logo_image_blob": std.filebase64(input=png).result,
 *         "operating_systems": ["Linux"],
 *         "usage_text": "Usage Text",
 *     },
 *     tags={
 *         "env": "production",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.EcrPublic.Repository("foo", new()
 *     {
 *         RepositoryName = "bar",
 *         CatalogData = new Aws.EcrPublic.Inputs.RepositoryCatalogDataArgs
 *         {
 *             AboutText = "About Text",
 *             Architectures = new[]
 *             {
 *                 "ARM",
 *             },
 *             Description = "Description",
 *             LogoImageBlob = Std.Filebase64.Invoke(new()
 *             {
 *                 Input = png,
 *             }).Apply(invoke => invoke.Result),
 *             OperatingSystems = new[]
 *             {
 *                 "Linux",
 *             },
 *             UsageText = "Usage Text",
 *         },
 *         Tags =
 *         {
 *             { "env", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecrpublic"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFilebase64, err := std.Filebase64(ctx, &std.Filebase64Args{
 * 			Input: png,
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecrpublic.NewRepository(ctx, "foo", &ecrpublic.RepositoryArgs{
 * 			RepositoryName: pulumi.String("bar"),
 * 			CatalogData: &ecrpublic.RepositoryCatalogDataArgs{
 * 				AboutText: pulumi.String("About Text"),
 * 				Architectures: pulumi.StringArray{
 * 					pulumi.String("ARM"),
 * 				},
 * 				Description:   pulumi.String("Description"),
 * 				LogoImageBlob: pulumi.String(invokeFilebase64.Result),
 * 				OperatingSystems: pulumi.StringArray{
 * 					pulumi.String("Linux"),
 * 				},
 * 				UsageText: pulumi.String("Usage Text"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"env": pulumi.String("production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecrpublic.Repository;
 * import com.pulumi.aws.ecrpublic.RepositoryArgs;
 * import com.pulumi.aws.ecrpublic.inputs.RepositoryCatalogDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Repository("foo", RepositoryArgs.builder()
 *             .repositoryName("bar")
 *             .catalogData(RepositoryCatalogDataArgs.builder()
 *                 .aboutText("About Text")
 *                 .architectures("ARM")
 *                 .description("Description")
 *                 .logoImageBlob(StdFunctions.filebase64(Filebase64Args.builder()
 *                     .input(png)
 *                     .build()).result())
 *                 .operatingSystems("Linux")
 *                 .usageText("Usage Text")
 *                 .build())
 *             .tags(Map.of("env", "production"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:ecrpublic:Repository
 *     properties:
 *       repositoryName: bar
 *       catalogData:
 *         aboutText: About Text
 *         architectures:
 *           - ARM
 *         description: Description
 *         logoImageBlob:
 *           fn::invoke:
 *             Function: std:filebase64
 *             Arguments:
 *               input: ${png}
 *             Return: result
 *         operatingSystems:
 *           - Linux
 *         usageText: Usage Text
 *       tags:
 *         env: production
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECR Public Repositories using the `repository_name`. For example:
 * ```sh
 * $ pulumi import aws:ecrpublic/repository:Repository example example
 * ```
 * @property catalogData Catalog data configuration for the repository. See below for schema.
 * @property forceDestroy
 * @property repositoryName Name of the repository.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RepositoryArgs(
    public val catalogData: Output<RepositoryCatalogDataArgs>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val repositoryName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecrpublic.RepositoryArgs> {
    override fun toJava(): com.pulumi.aws.ecrpublic.RepositoryArgs =
        com.pulumi.aws.ecrpublic.RepositoryArgs.builder()
            .catalogData(catalogData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .repositoryName(repositoryName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RepositoryArgs].
 */
@PulumiTagMarker
public class RepositoryArgsBuilder internal constructor() {
    private var catalogData: Output<RepositoryCatalogDataArgs>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var repositoryName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Catalog data configuration for the repository. See below for schema.
     */
    @JvmName("tdpdatvmjtufbbru")
    public suspend fun catalogData(`value`: Output<RepositoryCatalogDataArgs>) {
        this.catalogData = value
    }

    /**
     * @param value
     */
    @JvmName("kehmomjtdhvmuhoc")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value Name of the repository.
     */
    @JvmName("yrlyepshjrfoevyn")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ukbqgohwqdemvptg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Catalog data configuration for the repository. See below for schema.
     */
    @JvmName("bcixshtruairjvgf")
    public suspend fun catalogData(`value`: RepositoryCatalogDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogData = mapped
    }

    /**
     * @param argument Catalog data configuration for the repository. See below for schema.
     */
    @JvmName("tmnmvtdulnvhpipl")
    public suspend fun catalogData(argument: suspend RepositoryCatalogDataArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryCatalogDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.catalogData = mapped
    }

    /**
     * @param value
     */
    @JvmName("myrlaesadbnhyhmj")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value Name of the repository.
     */
    @JvmName("mprstcuagymouyvs")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mtlfjqwstqexocbe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ewjiudowytejwfcl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RepositoryArgs = RepositoryArgs(
        catalogData = catalogData,
        forceDestroy = forceDestroy,
        repositoryName = repositoryName,
        tags = tags,
    )
}
