@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecrpublic.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RepositoryPolicy].
 */
@PulumiTagMarker
public class RepositoryPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RepositoryPolicyArgs = RepositoryPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RepositoryPolicyArgsBuilder.() -> Unit) {
        val builder = RepositoryPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RepositoryPolicy {
        val builtJavaResource = com.pulumi.aws.ecrpublic.RepositoryPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RepositoryPolicy(builtJavaResource)
    }
}

/**
 * Provides an Elastic Container Registry Public Repository Policy.
 * Note that currently only one policy may be applied to a repository.
 * > **NOTE:** This resource can only be used in the `us-east-1` region.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleRepository = new aws.ecrpublic.Repository("example", {repositoryName: "example"});
 * const example = aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "new policy",
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: ["123456789012"],
 *         }],
 *         actions: [
 *             "ecr:GetDownloadUrlForLayer",
 *             "ecr:BatchGetImage",
 *             "ecr:BatchCheckLayerAvailability",
 *             "ecr:PutImage",
 *             "ecr:InitiateLayerUpload",
 *             "ecr:UploadLayerPart",
 *             "ecr:CompleteLayerUpload",
 *             "ecr:DescribeRepositories",
 *             "ecr:GetRepositoryPolicy",
 *             "ecr:ListImages",
 *             "ecr:DeleteRepository",
 *             "ecr:BatchDeleteImage",
 *             "ecr:SetRepositoryPolicy",
 *             "ecr:DeleteRepositoryPolicy",
 *         ],
 *     }],
 * });
 * const exampleRepositoryPolicy = new aws.ecrpublic.RepositoryPolicy("example", {
 *     repositoryName: exampleRepository.repositoryName,
 *     policy: example.then(example => example.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_repository = aws.ecrpublic.Repository("example", repository_name="example")
 * example = aws.iam.get_policy_document(statements=[{
 *     "sid": "new policy",
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": ["123456789012"],
 *     }],
 *     "actions": [
 *         "ecr:GetDownloadUrlForLayer",
 *         "ecr:BatchGetImage",
 *         "ecr:BatchCheckLayerAvailability",
 *         "ecr:PutImage",
 *         "ecr:InitiateLayerUpload",
 *         "ecr:UploadLayerPart",
 *         "ecr:CompleteLayerUpload",
 *         "ecr:DescribeRepositories",
 *         "ecr:GetRepositoryPolicy",
 *         "ecr:ListImages",
 *         "ecr:DeleteRepository",
 *         "ecr:BatchDeleteImage",
 *         "ecr:SetRepositoryPolicy",
 *         "ecr:DeleteRepositoryPolicy",
 *     ],
 * }])
 * example_repository_policy = aws.ecrpublic.RepositoryPolicy("example",
 *     repository_name=example_repository.repository_name,
 *     policy=example.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleRepository = new Aws.EcrPublic.Repository("example", new()
 *     {
 *         RepositoryName = "example",
 *     });
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "new policy",
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "123456789012",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "ecr:GetDownloadUrlForLayer",
 *                     "ecr:BatchGetImage",
 *                     "ecr:BatchCheckLayerAvailability",
 *                     "ecr:PutImage",
 *                     "ecr:InitiateLayerUpload",
 *                     "ecr:UploadLayerPart",
 *                     "ecr:CompleteLayerUpload",
 *                     "ecr:DescribeRepositories",
 *                     "ecr:GetRepositoryPolicy",
 *                     "ecr:ListImages",
 *                     "ecr:DeleteRepository",
 *                     "ecr:BatchDeleteImage",
 *                     "ecr:SetRepositoryPolicy",
 *                     "ecr:DeleteRepositoryPolicy",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRepositoryPolicy = new Aws.EcrPublic.RepositoryPolicy("example", new()
 *     {
 *         RepositoryName = exampleRepository.RepositoryName,
 *         Policy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecrpublic"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleRepository, err := ecrpublic.NewRepository(ctx, "example", &ecrpublic.RepositoryArgs{
 * 			RepositoryName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid:    pulumi.StringRef("new policy"),
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "AWS",
 * 							Identifiers: []string{
 * 								"123456789012",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"ecr:GetDownloadUrlForLayer",
 * 						"ecr:BatchGetImage",
 * 						"ecr:BatchCheckLayerAvailability",
 * 						"ecr:PutImage",
 * 						"ecr:InitiateLayerUpload",
 * 						"ecr:UploadLayerPart",
 * 						"ecr:CompleteLayerUpload",
 * 						"ecr:DescribeRepositories",
 * 						"ecr:GetRepositoryPolicy",
 * 						"ecr:ListImages",
 * 						"ecr:DeleteRepository",
 * 						"ecr:BatchDeleteImage",
 * 						"ecr:SetRepositoryPolicy",
 * 						"ecr:DeleteRepositoryPolicy",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecrpublic.NewRepositoryPolicy(ctx, "example", &ecrpublic.RepositoryPolicyArgs{
 * 			RepositoryName: exampleRepository.RepositoryName,
 * 			Policy:         pulumi.String(example.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecrpublic.Repository;
 * import com.pulumi.aws.ecrpublic.RepositoryArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ecrpublic.RepositoryPolicy;
 * import com.pulumi.aws.ecrpublic.RepositoryPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRepository = new Repository("exampleRepository", RepositoryArgs.builder()
 *             .repositoryName("example")
 *             .build());
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("new policy")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .actions(
 *                     "ecr:GetDownloadUrlForLayer",
 *                     "ecr:BatchGetImage",
 *                     "ecr:BatchCheckLayerAvailability",
 *                     "ecr:PutImage",
 *                     "ecr:InitiateLayerUpload",
 *                     "ecr:UploadLayerPart",
 *                     "ecr:CompleteLayerUpload",
 *                     "ecr:DescribeRepositories",
 *                     "ecr:GetRepositoryPolicy",
 *                     "ecr:ListImages",
 *                     "ecr:DeleteRepository",
 *                     "ecr:BatchDeleteImage",
 *                     "ecr:SetRepositoryPolicy",
 *                     "ecr:DeleteRepositoryPolicy")
 *                 .build())
 *             .build());
 *         var exampleRepositoryPolicy = new RepositoryPolicy("exampleRepositoryPolicy", RepositoryPolicyArgs.builder()
 *             .repositoryName(exampleRepository.repositoryName())
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleRepository:
 *     type: aws:ecrpublic:Repository
 *     name: example
 *     properties:
 *       repositoryName: example
 *   exampleRepositoryPolicy:
 *     type: aws:ecrpublic:RepositoryPolicy
 *     name: example
 *     properties:
 *       repositoryName: ${exampleRepository.repositoryName}
 *       policy: ${example.json}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: new policy
 *             effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '123456789012'
 *             actions:
 *               - ecr:GetDownloadUrlForLayer
 *               - ecr:BatchGetImage
 *               - ecr:BatchCheckLayerAvailability
 *               - ecr:PutImage
 *               - ecr:InitiateLayerUpload
 *               - ecr:UploadLayerPart
 *               - ecr:CompleteLayerUpload
 *               - ecr:DescribeRepositories
 *               - ecr:GetRepositoryPolicy
 *               - ecr:ListImages
 *               - ecr:DeleteRepository
 *               - ecr:BatchDeleteImage
 *               - ecr:SetRepositoryPolicy
 *               - ecr:DeleteRepositoryPolicy
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECR Public Repository Policy using the repository name. For example:
 * ```sh
 * $ pulumi import aws:ecrpublic/repositoryPolicy:RepositoryPolicy example example
 * ```
 */
public class RepositoryPolicy internal constructor(
    override val javaResource: com.pulumi.aws.ecrpublic.RepositoryPolicy,
) : KotlinCustomResource(javaResource, RepositoryPolicyMapper) {
    /**
     * The policy document. This is a JSON formatted string.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The registry ID where the repository was created.
     */
    public val registryId: Output<String>
        get() = javaResource.registryId().applyValue({ args0 -> args0 })

    /**
     * Name of the repository to apply the policy.
     */
    public val repositoryName: Output<String>
        get() = javaResource.repositoryName().applyValue({ args0 -> args0 })
}

public object RepositoryPolicyMapper : ResourceMapper<RepositoryPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecrpublic.RepositoryPolicy::class == javaResource::class

    override fun map(javaResource: Resource): RepositoryPolicy = RepositoryPolicy(
        javaResource as
            com.pulumi.aws.ecrpublic.RepositoryPolicy,
    )
}

/**
 * @see [RepositoryPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RepositoryPolicy].
 */
public suspend fun repositoryPolicy(
    name: String,
    block: suspend RepositoryPolicyResourceBuilder.() -> Unit,
): RepositoryPolicy {
    val builder = RepositoryPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RepositoryPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun repositoryPolicy(name: String): RepositoryPolicy {
    val builder = RepositoryPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
