@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecrpublic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aboutText A detailed description of the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The text must be in markdown format.
 * @property architectures The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures will appear as badges on the repository and are used as search filters: `ARM`, `ARM 64`, `x86`, `x86-64`
 * @property description A short description of the contents of the repository. This text appears in both the image details and also when searching for repositories on the Amazon ECR Public Gallery.
 * @property logoImageBlob The base64-encoded repository logo payload. (Only visible for verified accounts) Note that drift detection is disabled for this attribute.
 * @property operatingSystems The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems will appear as badges on the repository and are used as search filters: `Linux`, `Windows`
 * @property usageText Detailed information on how to use the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The usage text provides context, support information, and additional usage details for users of the repository. The text must be in markdown format.
 */
public data class RepositoryCatalogData(
    public val aboutText: String? = null,
    public val architectures: List<String>? = null,
    public val description: String? = null,
    public val logoImageBlob: String? = null,
    public val operatingSystems: List<String>? = null,
    public val usageText: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecrpublic.outputs.RepositoryCatalogData): RepositoryCatalogData = RepositoryCatalogData(
            aboutText = javaType.aboutText().map({ args0 -> args0 }).orElse(null),
            architectures = javaType.architectures().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            logoImageBlob = javaType.logoImageBlob().map({ args0 -> args0 }).orElse(null),
            operatingSystems = javaType.operatingSystems().map({ args0 -> args0 }),
            usageText = javaType.usageText().map({ args0 -> args0 }).orElse(null),
        )
    }
}
