@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.AccountSettingDefaultArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an ECS default account setting for a specific ECS Resource name within a specific region. More information can be found on the [ECS Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html).
 * > **NOTE:** The AWS API does not delete this resource. When you run `destroy`, the provider will attempt to disable the setting.
 * > **NOTE:** Your AWS account may not support disabling `containerInstanceLongArnFormat`, `serviceLongArnFormat`, and `taskLongArnFormat`. If your account does not support disabling these, "destroying" this resource will not disable the setting nor cause a provider error. However, the AWS Provider will log an AWS error: `InvalidParameterException: You can no longer disable Long Arn settings`.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.ecs.AccountSettingDefault("test", {
 *     name: "taskLongArnFormat",
 *     value: "enabled",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ecs.AccountSettingDefault("test",
 *     name="taskLongArnFormat",
 *     value="enabled")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Ecs.AccountSettingDefault("test", new()
 *     {
 *         Name = "taskLongArnFormat",
 *         Value = "enabled",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewAccountSettingDefault(ctx, "test", &ecs.AccountSettingDefaultArgs{
 * 			Name:  pulumi.String("taskLongArnFormat"),
 * 			Value: pulumi.String("enabled"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.AccountSettingDefault;
 * import com.pulumi.aws.ecs.AccountSettingDefaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AccountSettingDefault("test", AccountSettingDefaultArgs.builder()
 *             .name("taskLongArnFormat")
 *             .value("enabled")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ecs:AccountSettingDefault
 *     properties:
 *       name: taskLongArnFormat
 *       value: enabled
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECS Account Setting defaults using the `name`. For example:
 * ```sh
 * $ pulumi import aws:ecs/accountSettingDefault:AccountSettingDefault example taskLongArnFormat
 * ```
 * @property name Name of the account setting to set.
 * @property value State of the setting.
 */
public data class AccountSettingDefaultArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.AccountSettingDefaultArgs> {
    override fun toJava(): com.pulumi.aws.ecs.AccountSettingDefaultArgs =
        com.pulumi.aws.ecs.AccountSettingDefaultArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountSettingDefaultArgs].
 */
@PulumiTagMarker
public class AccountSettingDefaultArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the account setting to set.
     */
    @JvmName("iqfatwiibgkgxdlh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value State of the setting.
     */
    @JvmName("jtodsmyyovagmxqj")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the account setting to set.
     */
    @JvmName("ndduidtgmegssroy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value State of the setting.
     */
    @JvmName("laijdqljniexsyvm")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AccountSettingDefaultArgs = AccountSettingDefaultArgs(
        name = name,
        `value` = `value`,
    )
}
