@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.kotlin.outputs.CapacityProviderAutoScalingGroupProvider
import com.pulumi.aws.ecs.kotlin.outputs.CapacityProviderAutoScalingGroupProvider.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [CapacityProvider].
 */
@PulumiTagMarker
public class CapacityProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CapacityProviderArgs = CapacityProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CapacityProviderArgsBuilder.() -> Unit) {
        val builder = CapacityProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CapacityProvider {
        val builtJavaResource = com.pulumi.aws.ecs.CapacityProvider(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CapacityProvider(builtJavaResource)
    }
}

/**
 * Provides an ECS cluster capacity provider. More information can be found on the [ECS Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-capacity-providers.html).
 * > **NOTE:** Associating an ECS Capacity Provider to an Auto Scaling Group will automatically add the `AmazonECSManaged` tag to the Auto Scaling Group. This tag should be included in the `aws.autoscaling.Group` resource configuration to prevent the provider from removing it in subsequent executions as well as ensuring the `AmazonECSManaged` tag is propagated to all EC2 Instances in the Auto Scaling Group if `min_size` is above 0 on creation. Any EC2 Instances in the Auto Scaling Group without this tag must be manually be updated, otherwise they may cause unexpected scaling behavior and metrics.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.autoscaling.Group("test", {tags: [{
 *     key: "AmazonECSManaged",
 *     value: "true",
 *     propagateAtLaunch: true,
 * }]});
 * const testCapacityProvider = new aws.ecs.CapacityProvider("test", {
 *     name: "test",
 *     autoScalingGroupProvider: {
 *         autoScalingGroupArn: test.arn,
 *         managedTerminationProtection: "ENABLED",
 *         managedScaling: {
 *             maximumScalingStepSize: 1000,
 *             minimumScalingStepSize: 1,
 *             status: "ENABLED",
 *             targetCapacity: 10,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.autoscaling.Group("test", tags=[{
 *     "key": "AmazonECSManaged",
 *     "value": "true",
 *     "propagate_at_launch": True,
 * }])
 * test_capacity_provider = aws.ecs.CapacityProvider("test",
 *     name="test",
 *     auto_scaling_group_provider={
 *         "auto_scaling_group_arn": test.arn,
 *         "managed_termination_protection": "ENABLED",
 *         "managed_scaling": {
 *             "maximum_scaling_step_size": 1000,
 *             "minimum_scaling_step_size": 1,
 *             "status": "ENABLED",
 *             "target_capacity": 10,
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.AutoScaling.Group("test", new()
 *     {
 *         Tags = new[]
 *         {
 *             new Aws.AutoScaling.Inputs.GroupTagArgs
 *             {
 *                 Key = "AmazonECSManaged",
 *                 Value = "true",
 *                 PropagateAtLaunch = true,
 *             },
 *         },
 *     });
 *     var testCapacityProvider = new Aws.Ecs.CapacityProvider("test", new()
 *     {
 *         Name = "test",
 *         AutoScalingGroupProvider = new Aws.Ecs.Inputs.CapacityProviderAutoScalingGroupProviderArgs
 *         {
 *             AutoScalingGroupArn = test.Arn,
 *             ManagedTerminationProtection = "ENABLED",
 *             ManagedScaling = new Aws.Ecs.Inputs.CapacityProviderAutoScalingGroupProviderManagedScalingArgs
 *             {
 *                 MaximumScalingStepSize = 1000,
 *                 MinimumScalingStepSize = 1,
 *                 Status = "ENABLED",
 *                 TargetCapacity = 10,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/autoscaling"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := autoscaling.NewGroup(ctx, "test", &autoscaling.GroupArgs{
 * 			Tags: autoscaling.GroupTagArray{
 * 				&autoscaling.GroupTagArgs{
 * 					Key:               pulumi.String("AmazonECSManaged"),
 * 					Value:             pulumi.String("true"),
 * 					PropagateAtLaunch: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewCapacityProvider(ctx, "test", &ecs.CapacityProviderArgs{
 * 			Name: pulumi.String("test"),
 * 			AutoScalingGroupProvider: &ecs.CapacityProviderAutoScalingGroupProviderArgs{
 * 				AutoScalingGroupArn:          test.Arn,
 * 				ManagedTerminationProtection: pulumi.String("ENABLED"),
 * 				ManagedScaling: &ecs.CapacityProviderAutoScalingGroupProviderManagedScalingArgs{
 * 					MaximumScalingStepSize: pulumi.Int(1000),
 * 					MinimumScalingStepSize: pulumi.Int(1),
 * 					Status:                 pulumi.String("ENABLED"),
 * 					TargetCapacity:         pulumi.Int(10),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.inputs.GroupTagArgs;
 * import com.pulumi.aws.ecs.CapacityProvider;
 * import com.pulumi.aws.ecs.CapacityProviderArgs;
 * import com.pulumi.aws.ecs.inputs.CapacityProviderAutoScalingGroupProviderArgs;
 * import com.pulumi.aws.ecs.inputs.CapacityProviderAutoScalingGroupProviderManagedScalingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Group("test", GroupArgs.builder()
 *             .tags(GroupTagArgs.builder()
 *                 .key("AmazonECSManaged")
 *                 .value(true)
 *                 .propagateAtLaunch(true)
 *                 .build())
 *             .build());
 *         var testCapacityProvider = new CapacityProvider("testCapacityProvider", CapacityProviderArgs.builder()
 *             .name("test")
 *             .autoScalingGroupProvider(CapacityProviderAutoScalingGroupProviderArgs.builder()
 *                 .autoScalingGroupArn(test.arn())
 *                 .managedTerminationProtection("ENABLED")
 *                 .managedScaling(CapacityProviderAutoScalingGroupProviderManagedScalingArgs.builder()
 *                     .maximumScalingStepSize(1000)
 *                     .minimumScalingStepSize(1)
 *                     .status("ENABLED")
 *                     .targetCapacity(10)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:autoscaling:Group
 *     properties:
 *       tags:
 *         - key: AmazonECSManaged
 *           value: true
 *           propagateAtLaunch: true
 *   testCapacityProvider:
 *     type: aws:ecs:CapacityProvider
 *     name: test
 *     properties:
 *       name: test
 *       autoScalingGroupProvider:
 *         autoScalingGroupArn: ${test.arn}
 *         managedTerminationProtection: ENABLED
 *         managedScaling:
 *           maximumScalingStepSize: 1000
 *           minimumScalingStepSize: 1
 *           status: ENABLED
 *           targetCapacity: 10
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECS Capacity Providers using the `name`. For example:
 * ```sh
 * $ pulumi import aws:ecs/capacityProvider:CapacityProvider example example
 * ```
 */
public class CapacityProvider internal constructor(
    override val javaResource: com.pulumi.aws.ecs.CapacityProvider,
) : KotlinCustomResource(javaResource, CapacityProviderMapper) {
    /**
     * ARN that identifies the capacity provider.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the provider for the ECS auto scaling group. Detailed below.
     */
    public val autoScalingGroupProvider: Output<CapacityProviderAutoScalingGroupProvider>
        get() = javaResource.autoScalingGroupProvider().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Name of the capacity provider.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CapacityProviderMapper : ResourceMapper<CapacityProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecs.CapacityProvider::class == javaResource::class

    override fun map(javaResource: Resource): CapacityProvider = CapacityProvider(
        javaResource as
            com.pulumi.aws.ecs.CapacityProvider,
    )
}

/**
 * @see [CapacityProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CapacityProvider].
 */
public suspend fun capacityProvider(
    name: String,
    block: suspend CapacityProviderResourceBuilder.() -> Unit,
): CapacityProvider {
    val builder = CapacityProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CapacityProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun capacityProvider(name: String): CapacityProvider {
    val builder = CapacityProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
