@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.ClusterArgs.builder
import com.pulumi.aws.ecs.kotlin.inputs.ClusterConfigurationArgs
import com.pulumi.aws.ecs.kotlin.inputs.ClusterConfigurationArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ClusterServiceConnectDefaultsArgs
import com.pulumi.aws.ecs.kotlin.inputs.ClusterServiceConnectDefaultsArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ClusterSettingArgs
import com.pulumi.aws.ecs.kotlin.inputs.ClusterSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ECS cluster.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.ecs.Cluster("foo", {
 *     name: "white-hart",
 *     settings: [{
 *         name: "containerInsights",
 *         value: "enabled",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.ecs.Cluster("foo",
 *     name="white-hart",
 *     settings=[{
 *         "name": "containerInsights",
 *         "value": "enabled",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.Ecs.Cluster("foo", new()
 *     {
 *         Name = "white-hart",
 *         Settings = new[]
 *         {
 *             new Aws.Ecs.Inputs.ClusterSettingArgs
 *             {
 *                 Name = "containerInsights",
 *                 Value = "enabled",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewCluster(ctx, "foo", &ecs.ClusterArgs{
 * 			Name: pulumi.String("white-hart"),
 * 			Settings: ecs.ClusterSettingArray{
 * 				&ecs.ClusterSettingArgs{
 * 					Name:  pulumi.String("containerInsights"),
 * 					Value: pulumi.String("enabled"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Cluster;
 * import com.pulumi.aws.ecs.ClusterArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Cluster("foo", ClusterArgs.builder()
 *             .name("white-hart")
 *             .settings(ClusterSettingArgs.builder()
 *                 .name("containerInsights")
 *                 .value("enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:ecs:Cluster
 *     properties:
 *       name: white-hart
 *       settings:
 *         - name: containerInsights
 *           value: enabled
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Execute Command Configuration with Override Logging
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "example",
 *     deletionWindowInDays: 7,
 * });
 * const exampleLogGroup = new aws.cloudwatch.LogGroup("example", {name: "example"});
 * const test = new aws.ecs.Cluster("test", {
 *     name: "example",
 *     configuration: {
 *         executeCommandConfiguration: {
 *             kmsKeyId: example.arn,
 *             logging: "OVERRIDE",
 *             logConfiguration: {
 *                 cloudWatchEncryptionEnabled: true,
 *                 cloudWatchLogGroupName: exampleLogGroup.name,
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="example",
 *     deletion_window_in_days=7)
 * example_log_group = aws.cloudwatch.LogGroup("example", name="example")
 * test = aws.ecs.Cluster("test",
 *     name="example",
 *     configuration={
 *         "execute_command_configuration": {
 *             "kms_key_id": example.arn,
 *             "logging": "OVERRIDE",
 *             "log_configuration": {
 *                 "cloud_watch_encryption_enabled": True,
 *                 "cloud_watch_log_group_name": example_log_group.name,
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "example",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleLogGroup = new Aws.CloudWatch.LogGroup("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var test = new Aws.Ecs.Cluster("test", new()
 *     {
 *         Name = "example",
 *         Configuration = new Aws.Ecs.Inputs.ClusterConfigurationArgs
 *         {
 *             ExecuteCommandConfiguration = new Aws.Ecs.Inputs.ClusterConfigurationExecuteCommandConfigurationArgs
 *             {
 *                 KmsKeyId = example.Arn,
 *                 Logging = "OVERRIDE",
 *                 LogConfiguration = new Aws.Ecs.Inputs.ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs
 *                 {
 *                     CloudWatchEncryptionEnabled = true,
 *                     CloudWatchLogGroupName = exampleLogGroup.Name,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("example"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleLogGroup, err := cloudwatch.NewLogGroup(ctx, "example", &cloudwatch.LogGroupArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewCluster(ctx, "test", &ecs.ClusterArgs{
 * 			Name: pulumi.String("example"),
 * 			Configuration: &ecs.ClusterConfigurationArgs{
 * 				ExecuteCommandConfiguration: &ecs.ClusterConfigurationExecuteCommandConfigurationArgs{
 * 					KmsKeyId: example.Arn,
 * 					Logging:  pulumi.String("OVERRIDE"),
 * 					LogConfiguration: &ecs.ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs{
 * 						CloudWatchEncryptionEnabled: pulumi.Bool(true),
 * 						CloudWatchLogGroupName:      exampleLogGroup.Name,
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.ecs.Cluster;
 * import com.pulumi.aws.ecs.ClusterArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("example")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleLogGroup = new LogGroup("exampleLogGroup", LogGroupArgs.builder()
 *             .name("example")
 *             .build());
 *         var test = new Cluster("test", ClusterArgs.builder()
 *             .name("example")
 *             .configuration(ClusterConfigurationArgs.builder()
 *                 .executeCommandConfiguration(ClusterConfigurationExecuteCommandConfigurationArgs.builder()
 *                     .kmsKeyId(example.arn())
 *                     .logging("OVERRIDE")
 *                     .logConfiguration(ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs.builder()
 *                         .cloudWatchEncryptionEnabled(true)
 *                         .cloudWatchLogGroupName(exampleLogGroup.name())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: example
 *       deletionWindowInDays: 7
 *   exampleLogGroup:
 *     type: aws:cloudwatch:LogGroup
 *     name: example
 *     properties:
 *       name: example
 *   test:
 *     type: aws:ecs:Cluster
 *     properties:
 *       name: example
 *       configuration:
 *         executeCommandConfiguration:
 *           kmsKeyId: ${example.arn}
 *           logging: OVERRIDE
 *           logConfiguration:
 *             cloudWatchEncryptionEnabled: true
 *             cloudWatchLogGroupName: ${exampleLogGroup.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Fargate Ephemeral Storage Encryption with Customer-Managed KMS Key
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const example = new aws.kms.Key("example", {
 *     description: "example",
 *     deletionWindowInDays: 7,
 * });
 * const exampleKeyPolicy = new aws.kms.KeyPolicy("example", {
 *     keyId: example.id,
 *     policy: JSON.stringify({
 *         Id: "ECSClusterFargatePolicy",
 *         Statement: [
 *             {
 *                 Sid: "Enable IAM User Permissions",
 *                 Effect: "Allow",
 *                 Principal: {
 *                     AWS: "*",
 *                 },
 *                 Action: "kms:*",
 *                 Resource: "*",
 *             },
 *             {
 *                 Sid: "Allow generate data key access for Fargate tasks.",
 *                 Effect: "Allow",
 *                 Principal: {
 *                     Service: "fargate.amazonaws.com",
 *                 },
 *                 Action: ["kms:GenerateDataKeyWithoutPlaintext"],
 *                 Condition: {
 *                     StringEquals: {
 *                         "kms:EncryptionContext:aws:ecs:clusterAccount": [current&#46;then(current => current&#46;accountId)],
 *                         "kms:EncryptionContext:aws:ecs:clusterName": ["example"],
 *                     },
 *                 },
 *                 Resource: "*",
 *             },
 *             {
 *                 Sid: "Allow grant creation permission for Fargate tasks.",
 *                 Effect: "Allow",
 *                 Principal: {
 *                     Service: "fargate.amazonaws.com",
 *                 },
 *                 Action: ["kms:CreateGrant"],
 *                 Condition: {
 *                     StringEquals: {
 *                         "kms:EncryptionContext:aws:ecs:clusterAccount": [current&#46;then(current => current&#46;accountId)],
 *                         "kms:EncryptionContext:aws:ecs:clusterName": ["example"],
 *                     },
 *                     "ForAllValues:StringEquals": {
 *                         "kms:GrantOperations": ["Decrypt"],
 *                     },
 *                 },
 *                 Resource: "*",
 *             },
 *         ],
 *         Version: "2012-10-17",
 *     }),
 * });
 * const test = new aws.ecs.Cluster("test", {
 *     name: "example",
 *     configuration: {
 *         managedStorageConfiguration: {
 *             fargateEphemeralStorageKmsKeyId: example.id,
 *         },
 *     },
 * }, {
 *     dependsOn: [exampleKeyPolicy],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * example = aws.kms.Key("example",
 *     description="example",
 *     deletion_window_in_days=7)
 * example_key_policy = aws.kms.KeyPolicy("example",
 *     key_id=example.id,
 *     policy=json.dumps({
 *         "Id": "ECSClusterFargatePolicy",
 *         "Statement": [
 *             {
 *                 "Sid": "Enable IAM User Permissions",
 *                 "Effect": "Allow",
 *                 "Principal": {
 *                     "AWS": "*",
 *                 },
 *                 "Action": "kms:*",
 *                 "Resource": "*",
 *             },
 *             {
 *                 "Sid": "Allow generate data key access for Fargate tasks.",
 *                 "Effect": "Allow",
 *                 "Principal": {
 *                     "Service": "fargate.amazonaws.com",
 *                 },
 *                 "Action": ["kms:GenerateDataKeyWithoutPlaintext"],
 *                 "Condition": {
 *                     "StringEquals": {
 *                         "kms:EncryptionContext:aws:ecs:clusterAccount": [current&#46;account_id],
 *                         "kms:EncryptionContext:aws:ecs:clusterName": ["example"],
 *                     },
 *                 },
 *                 "Resource": "*",
 *             },
 *             {
 *                 "Sid": "Allow grant creation permission for Fargate tasks.",
 *                 "Effect": "Allow",
 *                 "Principal": {
 *                     "Service": "fargate.amazonaws.com",
 *                 },
 *                 "Action": ["kms:CreateGrant"],
 *                 "Condition": {
 *                     "StringEquals": {
 *                         "kms:EncryptionContext:aws:ecs:clusterAccount": [current&#46;account_id],
 *                         "kms:EncryptionContext:aws:ecs:clusterName": ["example"],
 *                     },
 *                     "ForAllValues:StringEquals": {
 *                         "kms:GrantOperations": ["Decrypt"],
 *                     },
 *                 },
 *                 "Resource": "*",
 *             },
 *         ],
 *         "Version": "2012-10-17",
 *     }))
 * test = aws.ecs.Cluster("test",
 *     name="example",
 *     configuration={
 *         "managed_storage_configuration": {
 *             "fargate_ephemeral_storage_kms_key_id": example.id,
 *         },
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_key_policy]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "example",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleKeyPolicy = new Aws.Kms.KeyPolicy("example", new()
 *     {
 *         KeyId = example.Id,
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Id"] = "ECSClusterFargatePolicy",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "Enable IAM User Permissions",
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["AWS"] = "*",
 *                     },
 *                     ["Action"] = "kms:*",
 *                     ["Resource"] = "*",
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "Allow generate data key access for Fargate tasks.",
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "fargate.amazonaws.com",
 *                     },
 *                     ["Action"] = new[]
 *                     {
 *                         "kms:GenerateDataKeyWithoutPlaintext",
 *                     },
 *                     ["Condition"] = new Dictionary<string, object?>
 *                     {
 *                         ["StringEquals"] = new Dictionary<string, object?>
 *                         {
 *                             ["kms:EncryptionContext:aws:ecs:clusterAccount"] = new[]
 *                             {
 *                                 current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *                             },
 *                             ["kms:EncryptionContext:aws:ecs:clusterName"] = new[]
 *                             {
 *                                 "example",
 *                             },
 *                         },
 *                     },
 *                     ["Resource"] = "*",
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "Allow grant creation permission for Fargate tasks.",
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "fargate.amazonaws.com",
 *                     },
 *                     ["Action"] = new[]
 *                     {
 *                         "kms:CreateGrant",
 *                     },
 *                     ["Condition"] = new Dictionary<string, object?>
 *                     {
 *                         ["StringEquals"] = new Dictionary<string, object?>
 *                         {
 *                             ["kms:EncryptionContext:aws:ecs:clusterAccount"] = new[]
 *                             {
 *                                 current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *                             },
 *                             ["kms:EncryptionContext:aws:ecs:clusterName"] = new[]
 *                             {
 *                                 "example",
 *                             },
 *                         },
 *                         ["ForAllValues:StringEquals"] = new Dictionary<string, object?>
 *                         {
 *                             ["kms:GrantOperations"] = new[]
 *                             {
 *                                 "Decrypt",
 *                             },
 *                         },
 *                     },
 *                     ["Resource"] = "*",
 *                 },
 *             },
 *             ["Version"] = "2012-10-17",
 *         }),
 *     });
 *     var test = new Aws.Ecs.Cluster("test", new()
 *     {
 *         Name = "example",
 *         Configuration = new Aws.Ecs.Inputs.ClusterConfigurationArgs
 *         {
 *             ManagedStorageConfiguration = new Aws.Ecs.Inputs.ClusterConfigurationManagedStorageConfigurationArgs
 *             {
 *                 FargateEphemeralStorageKmsKeyId = example.Id,
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleKeyPolicy,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("example"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Id": "ECSClusterFargatePolicy",
 * 			"Statement": []interface{}{
 * 				map[string]interface{}{
 * 					"Sid":    "Enable IAM User Permissions",
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"AWS": "*",
 * 					},
 * 					"Action":   "kms:*",
 * 					"Resource": "*",
 * 				},
 * 				map[string]interface{}{
 * 					"Sid":    "Allow generate data key access for Fargate tasks.",
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "fargate.amazonaws.com",
 * 					},
 * 					"Action": []string{
 * 						"kms:GenerateDataKeyWithoutPlaintext",
 * 					},
 * 					"Condition": map[string]interface{}{
 * 						"StringEquals": map[string]interface{}{
 * 							"kms:EncryptionContext:aws:ecs:clusterAccount": []*string{
 * 								current.AccountId,
 * 							},
 * 							"kms:EncryptionContext:aws:ecs:clusterName": []string{
 * 								"example",
 * 							},
 * 						},
 * 					},
 * 					"Resource": "*",
 * 				},
 * 				map[string]interface{}{
 * 					"Sid":    "Allow grant creation permission for Fargate tasks.",
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "fargate.amazonaws.com",
 * 					},
 * 					"Action": []string{
 * 						"kms:CreateGrant",
 * 					},
 * 					"Condition": map[string]interface{}{
 * 						"StringEquals": map[string]interface{}{
 * 							"kms:EncryptionContext:aws:ecs:clusterAccount": []*string{
 * 								current.AccountId,
 * 							},
 * 							"kms:EncryptionContext:aws:ecs:clusterName": []string{
 * 								"example",
 * 							},
 * 						},
 * 						"ForAllValues:StringEquals": map[string]interface{}{
 * 							"kms:GrantOperations": []string{
 * 								"Decrypt",
 * 							},
 * 						},
 * 					},
 * 					"Resource": "*",
 * 				},
 * 			},
 * 			"Version": "2012-10-17",
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		exampleKeyPolicy, err := kms.NewKeyPolicy(ctx, "example", &kms.KeyPolicyArgs{
 * 			KeyId:  example.ID(),
 * 			Policy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewCluster(ctx, "test", &ecs.ClusterArgs{
 * 			Name: pulumi.String("example"),
 * 			Configuration: &ecs.ClusterConfigurationArgs{
 * 				ManagedStorageConfiguration: &ecs.ClusterConfigurationManagedStorageConfigurationArgs{
 * 					FargateEphemeralStorageKmsKeyId: example.ID(),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleKeyPolicy,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.kms.KeyPolicy;
 * import com.pulumi.aws.kms.KeyPolicyArgs;
 * import com.pulumi.aws.ecs.Cluster;
 * import com.pulumi.aws.ecs.ClusterArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationManagedStorageConfigurationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("example")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleKeyPolicy = new KeyPolicy("exampleKeyPolicy", KeyPolicyArgs.builder()
 *             .keyId(example.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Id", "ECSClusterFargatePolicy"),
 *                     jsonProperty("Statement", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("Sid", "Enable IAM User Permissions"),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("AWS", "*")
 *                             )),
 *                             jsonProperty("Action", "kms:*"),
 *                             jsonProperty("Resource", "*")
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Sid", "Allow generate data key access for Fargate tasks."),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("Service", "fargate.amazonaws.com")
 *                             )),
 *                             jsonProperty("Action", jsonArray("kms:GenerateDataKeyWithoutPlaintext")),
 *                             jsonProperty("Condition", jsonObject(
 *                                 jsonProperty("StringEquals", jsonObject(
 *                                     jsonProperty("kms:EncryptionContext:aws:ecs:clusterAccount", jsonArray(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))),
 *                                     jsonProperty("kms:EncryptionContext:aws:ecs:clusterName", jsonArray("example"))
 *                                 ))
 *                             )),
 *                             jsonProperty("Resource", "*")
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Sid", "Allow grant creation permission for Fargate tasks."),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("Service", "fargate.amazonaws.com")
 *                             )),
 *                             jsonProperty("Action", jsonArray("kms:CreateGrant")),
 *                             jsonProperty("Condition", jsonObject(
 *                                 jsonProperty("StringEquals", jsonObject(
 *                                     jsonProperty("kms:EncryptionContext:aws:ecs:clusterAccount", jsonArray(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))),
 *                                     jsonProperty("kms:EncryptionContext:aws:ecs:clusterName", jsonArray("example"))
 *                                 )),
 *                                 jsonProperty("ForAllValues:StringEquals", jsonObject(
 *                                     jsonProperty("kms:GrantOperations", jsonArray("Decrypt"))
 *                                 ))
 *                             )),
 *                             jsonProperty("Resource", "*")
 *                         )
 *                     )),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *         var test = new Cluster("test", ClusterArgs.builder()
 *             .name("example")
 *             .configuration(ClusterConfigurationArgs.builder()
 *                 .managedStorageConfiguration(ClusterConfigurationManagedStorageConfigurationArgs.builder()
 *                     .fargateEphemeralStorageKmsKeyId(example.id())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleKeyPolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: example
 *       deletionWindowInDays: 7
 *   exampleKeyPolicy:
 *     type: aws:kms:KeyPolicy
 *     name: example
 *     properties:
 *       keyId: ${example.id}
 *       policy:
 *         fn::toJSON:
 *           Id: ECSClusterFargatePolicy
 *           Statement:
 *             - Sid: Enable IAM User Permissions
 *               Effect: Allow
 *               Principal:
 *                 AWS: '*'
 *               Action: kms:*
 *               Resource: '*'
 *             - Sid: Allow generate data key access for Fargate tasks.
 *               Effect: Allow
 *               Principal:
 *                 Service: fargate.amazonaws.com
 *               Action:
 *                 - kms:GenerateDataKeyWithoutPlaintext
 *               Condition:
 *                 StringEquals:
 *                   kms:EncryptionContext:aws:ecs:clusterAccount:
 *                     - ${current.accountId}
 *                   kms:EncryptionContext:aws:ecs:clusterName:
 *                     - example
 *               Resource: '*'
 *             - Sid: Allow grant creation permission for Fargate tasks.
 *               Effect: Allow
 *               Principal:
 *                 Service: fargate.amazonaws.com
 *               Action:
 *                 - kms:CreateGrant
 *               Condition:
 *                 StringEquals:
 *                   kms:EncryptionContext:aws:ecs:clusterAccount:
 *                     - ${current.accountId}
 *                   kms:EncryptionContext:aws:ecs:clusterName:
 *                     - example
 *                 ForAllValues:StringEquals:
 *                   kms:GrantOperations:
 *                     - Decrypt
 *               Resource: '*'
 *           Version: 2012-10-17
 *   test:
 *     type: aws:ecs:Cluster
 *     properties:
 *       name: example
 *       configuration:
 *         managedStorageConfiguration:
 *           fargateEphemeralStorageKmsKeyId: ${example.id}
 *     options:
 *       dependson:
 *         - ${exampleKeyPolicy}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECS clusters using the cluster name. For example:
 * ```sh
 * $ pulumi import aws:ecs/cluster:Cluster stateless stateless-app
 * ```
 * @property configuration Execute command configuration for the cluster. See `configuration` Block for details.
 * @property name Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)
 * The following arguments are optional:
 * @property serviceConnectDefaults Default Service Connect namespace. See `service_connect_defaults` Block for details.
 * @property settings Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterArgs(
    public val configuration: Output<ClusterConfigurationArgs>? = null,
    public val name: Output<String>? = null,
    public val serviceConnectDefaults: Output<ClusterServiceConnectDefaultsArgs>? = null,
    public val settings: Output<List<ClusterSettingArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.ClusterArgs> {
    override fun toJava(): com.pulumi.aws.ecs.ClusterArgs = com.pulumi.aws.ecs.ClusterArgs.builder()
        .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .name(name?.applyValue({ args0 -> args0 }))
        .serviceConnectDefaults(
            serviceConnectDefaults?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .settings(
            settings?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var configuration: Output<ClusterConfigurationArgs>? = null

    private var name: Output<String>? = null

    private var serviceConnectDefaults: Output<ClusterServiceConnectDefaultsArgs>? = null

    private var settings: Output<List<ClusterSettingArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Execute command configuration for the cluster. See `configuration` Block for details.
     */
    @JvmName("onrfjphviflamdkk")
    public suspend fun configuration(`value`: Output<ClusterConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)
     * The following arguments are optional:
     */
    @JvmName("fvjtfgxdkrilcsgf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Default Service Connect namespace. See `service_connect_defaults` Block for details.
     */
    @JvmName("xqhqoamuircmepxr")
    public suspend fun serviceConnectDefaults(`value`: Output<ClusterServiceConnectDefaultsArgs>) {
        this.serviceConnectDefaults = value
    }

    /**
     * @param value Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
     */
    @JvmName("tbbrmwrryxuiwjrq")
    public suspend fun settings(`value`: Output<List<ClusterSettingArgs>>) {
        this.settings = value
    }

    @JvmName("ghbgsfvnyejkobyx")
    public suspend fun settings(vararg values: Output<ClusterSettingArgs>) {
        this.settings = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
     */
    @JvmName("tteimmvlyosaqpee")
    public suspend fun settings(values: List<Output<ClusterSettingArgs>>) {
        this.settings = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qlxtftlyivaytdaw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Execute command configuration for the cluster. See `configuration` Block for details.
     */
    @JvmName("tstfxjfopqrdjrsq")
    public suspend fun configuration(`value`: ClusterConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Execute command configuration for the cluster. See `configuration` Block for details.
     */
    @JvmName("gooayshvnqwwuqxq")
    public suspend fun configuration(argument: suspend ClusterConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)
     * The following arguments are optional:
     */
    @JvmName("wehnuenuupyuufic")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Default Service Connect namespace. See `service_connect_defaults` Block for details.
     */
    @JvmName("rbpsedxenbecpjtt")
    public suspend fun serviceConnectDefaults(`value`: ClusterServiceConnectDefaultsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceConnectDefaults = mapped
    }

    /**
     * @param argument Default Service Connect namespace. See `service_connect_defaults` Block for details.
     */
    @JvmName("ugujbjqyqkpkxeey")
    public suspend fun serviceConnectDefaults(argument: suspend ClusterServiceConnectDefaultsArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterServiceConnectDefaultsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceConnectDefaults = mapped
    }

    /**
     * @param value Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
     */
    @JvmName("qavxblmtsswrsudu")
    public suspend fun settings(`value`: List<ClusterSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
     */
    @JvmName("ftvslgtakxmauajo")
    public suspend fun settings(argument: List<suspend ClusterSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
     */
    @JvmName("ycdgimbpalyyfqtv")
    public suspend fun settings(vararg argument: suspend ClusterSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
     */
    @JvmName("spsnqxehpmfqjalh")
    public suspend fun settings(argument: suspend ClusterSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ClusterSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param values Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
     */
    @JvmName("bagwaflvafnnutvk")
    public suspend fun settings(vararg values: ClusterSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bytveeqnkxeoslgu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("euecleopkovbcigo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        configuration = configuration,
        name = name,
        serviceConnectDefaults = serviceConnectDefaults,
        settings = settings,
        tags = tags,
    )
}
