@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.ClusterCapacityProvidersArgs.builder
import com.pulumi.aws.ecs.kotlin.inputs.ClusterCapacityProvidersDefaultCapacityProviderStrategyArgs
import com.pulumi.aws.ecs.kotlin.inputs.ClusterCapacityProvidersDefaultCapacityProviderStrategyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages the capacity providers of an ECS Cluster.
 * More information about capacity providers can be found in the [ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-capacity-providers.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecs.Cluster("example", {name: "my-cluster"});
 * const exampleClusterCapacityProviders = new aws.ecs.ClusterCapacityProviders("example", {
 *     clusterName: example.name,
 *     capacityProviders: ["FARGATE"],
 *     defaultCapacityProviderStrategies: [{
 *         base: 1,
 *         weight: 100,
 *         capacityProvider: "FARGATE",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecs.Cluster("example", name="my-cluster")
 * example_cluster_capacity_providers = aws.ecs.ClusterCapacityProviders("example",
 *     cluster_name=example.name,
 *     capacity_providers=["FARGATE"],
 *     default_capacity_provider_strategies=[{
 *         "base": 1,
 *         "weight": 100,
 *         "capacity_provider": "FARGATE",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecs.Cluster("example", new()
 *     {
 *         Name = "my-cluster",
 *     });
 *     var exampleClusterCapacityProviders = new Aws.Ecs.ClusterCapacityProviders("example", new()
 *     {
 *         ClusterName = example.Name,
 *         CapacityProviders = new[]
 *         {
 *             "FARGATE",
 *         },
 *         DefaultCapacityProviderStrategies = new[]
 *         {
 *             new Aws.Ecs.Inputs.ClusterCapacityProvidersDefaultCapacityProviderStrategyArgs
 *             {
 *                 Base = 1,
 *                 Weight = 100,
 *                 CapacityProvider = "FARGATE",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ecs.NewCluster(ctx, "example", &ecs.ClusterArgs{
 * 			Name: pulumi.String("my-cluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewClusterCapacityProviders(ctx, "example", &ecs.ClusterCapacityProvidersArgs{
 * 			ClusterName: example.Name,
 * 			CapacityProviders: pulumi.StringArray{
 * 				pulumi.String("FARGATE"),
 * 			},
 * 			DefaultCapacityProviderStrategies: ecs.ClusterCapacityProvidersDefaultCapacityProviderStrategyArray{
 * 				&ecs.ClusterCapacityProvidersDefaultCapacityProviderStrategyArgs{
 * 					Base:             pulumi.Int(1),
 * 					Weight:           pulumi.Int(100),
 * 					CapacityProvider: pulumi.String("FARGATE"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Cluster;
 * import com.pulumi.aws.ecs.ClusterArgs;
 * import com.pulumi.aws.ecs.ClusterCapacityProviders;
 * import com.pulumi.aws.ecs.ClusterCapacityProvidersArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterCapacityProvidersDefaultCapacityProviderStrategyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .name("my-cluster")
 *             .build());
 *         var exampleClusterCapacityProviders = new ClusterCapacityProviders("exampleClusterCapacityProviders", ClusterCapacityProvidersArgs.builder()
 *             .clusterName(example.name())
 *             .capacityProviders("FARGATE")
 *             .defaultCapacityProviderStrategies(ClusterCapacityProvidersDefaultCapacityProviderStrategyArgs.builder()
 *                 .base(1)
 *                 .weight(100)
 *                 .capacityProvider("FARGATE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecs:Cluster
 *     properties:
 *       name: my-cluster
 *   exampleClusterCapacityProviders:
 *     type: aws:ecs:ClusterCapacityProviders
 *     name: example
 *     properties:
 *       clusterName: ${example.name}
 *       capacityProviders:
 *         - FARGATE
 *       defaultCapacityProviderStrategies:
 *         - base: 1
 *           weight: 100
 *           capacityProvider: FARGATE
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECS cluster capacity providers using the `cluster_name` attribute. For example:
 * ```sh
 * $ pulumi import aws:ecs/clusterCapacityProviders:ClusterCapacityProviders example my-cluster
 * ```
 * @property capacityProviders Set of names of one or more capacity providers to associate with the cluster. Valid values also include `FARGATE` and `FARGATE_SPOT`.
 * @property clusterName Name of the ECS cluster to manage capacity providers for.
 * @property defaultCapacityProviderStrategies Set of capacity provider strategies to use by default for the cluster. Detailed below.
 */
public data class ClusterCapacityProvidersArgs(
    public val capacityProviders: Output<List<String>>? = null,
    public val clusterName: Output<String>? = null,
    public val defaultCapacityProviderStrategies: Output<List<ClusterCapacityProvidersDefaultCapacityProviderStrategyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.ClusterCapacityProvidersArgs> {
    override fun toJava(): com.pulumi.aws.ecs.ClusterCapacityProvidersArgs =
        com.pulumi.aws.ecs.ClusterCapacityProvidersArgs.builder()
            .capacityProviders(capacityProviders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .defaultCapacityProviderStrategies(
                defaultCapacityProviderStrategies?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ClusterCapacityProvidersArgs].
 */
@PulumiTagMarker
public class ClusterCapacityProvidersArgsBuilder internal constructor() {
    private var capacityProviders: Output<List<String>>? = null

    private var clusterName: Output<String>? = null

    private var defaultCapacityProviderStrategies:
        Output<List<ClusterCapacityProvidersDefaultCapacityProviderStrategyArgs>>? = null

    /**
     * @param value Set of names of one or more capacity providers to associate with the cluster. Valid values also include `FARGATE` and `FARGATE_SPOT`.
     */
    @JvmName("pvdyppjokwrxvpam")
    public suspend fun capacityProviders(`value`: Output<List<String>>) {
        this.capacityProviders = value
    }

    @JvmName("rejicqnayqlydrxe")
    public suspend fun capacityProviders(vararg values: Output<String>) {
        this.capacityProviders = Output.all(values.asList())
    }

    /**
     * @param values Set of names of one or more capacity providers to associate with the cluster. Valid values also include `FARGATE` and `FARGATE_SPOT`.
     */
    @JvmName("mivsbdpsncegrvux")
    public suspend fun capacityProviders(values: List<Output<String>>) {
        this.capacityProviders = Output.all(values)
    }

    /**
     * @param value Name of the ECS cluster to manage capacity providers for.
     */
    @JvmName("olbnctajgvnohtpu")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Set of capacity provider strategies to use by default for the cluster. Detailed below.
     */
    @JvmName("jnmuqdppaeiwlsvy")
    public suspend fun defaultCapacityProviderStrategies(`value`: Output<List<ClusterCapacityProvidersDefaultCapacityProviderStrategyArgs>>) {
        this.defaultCapacityProviderStrategies = value
    }

    @JvmName("berffoyvhcoqirhp")
    public suspend fun defaultCapacityProviderStrategies(vararg values: Output<ClusterCapacityProvidersDefaultCapacityProviderStrategyArgs>) {
        this.defaultCapacityProviderStrategies = Output.all(values.asList())
    }

    /**
     * @param values Set of capacity provider strategies to use by default for the cluster. Detailed below.
     */
    @JvmName("siepnfpsyakjefwm")
    public suspend fun defaultCapacityProviderStrategies(values: List<Output<ClusterCapacityProvidersDefaultCapacityProviderStrategyArgs>>) {
        this.defaultCapacityProviderStrategies = Output.all(values)
    }

    /**
     * @param value Set of names of one or more capacity providers to associate with the cluster. Valid values also include `FARGATE` and `FARGATE_SPOT`.
     */
    @JvmName("yuwuoougxosgwxub")
    public suspend fun capacityProviders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityProviders = mapped
    }

    /**
     * @param values Set of names of one or more capacity providers to associate with the cluster. Valid values also include `FARGATE` and `FARGATE_SPOT`.
     */
    @JvmName("xofgkdentbneisdu")
    public suspend fun capacityProviders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacityProviders = mapped
    }

    /**
     * @param value Name of the ECS cluster to manage capacity providers for.
     */
    @JvmName("epwfrypofqlkoclx")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Set of capacity provider strategies to use by default for the cluster. Detailed below.
     */
    @JvmName("tebiekwjprlqphik")
    public suspend fun defaultCapacityProviderStrategies(`value`: List<ClusterCapacityProvidersDefaultCapacityProviderStrategyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultCapacityProviderStrategies = mapped
    }

    /**
     * @param argument Set of capacity provider strategies to use by default for the cluster. Detailed below.
     */
    @JvmName("dqknytslpdrmheea")
    public suspend fun defaultCapacityProviderStrategies(argument: List<suspend ClusterCapacityProvidersDefaultCapacityProviderStrategyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterCapacityProvidersDefaultCapacityProviderStrategyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultCapacityProviderStrategies = mapped
    }

    /**
     * @param argument Set of capacity provider strategies to use by default for the cluster. Detailed below.
     */
    @JvmName("rktththpaaphhkib")
    public suspend fun defaultCapacityProviderStrategies(vararg argument: suspend ClusterCapacityProvidersDefaultCapacityProviderStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterCapacityProvidersDefaultCapacityProviderStrategyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultCapacityProviderStrategies = mapped
    }

    /**
     * @param argument Set of capacity provider strategies to use by default for the cluster. Detailed below.
     */
    @JvmName("fdnkhhahpofhjabg")
    public suspend fun defaultCapacityProviderStrategies(argument: suspend ClusterCapacityProvidersDefaultCapacityProviderStrategyArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClusterCapacityProvidersDefaultCapacityProviderStrategyArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.defaultCapacityProviderStrategies = mapped
    }

    /**
     * @param values Set of capacity provider strategies to use by default for the cluster. Detailed below.
     */
    @JvmName("gjboqdcrsovlpduo")
    public suspend fun defaultCapacityProviderStrategies(vararg values: ClusterCapacityProvidersDefaultCapacityProviderStrategyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultCapacityProviderStrategies = mapped
    }

    internal fun build(): ClusterCapacityProvidersArgs = ClusterCapacityProvidersArgs(
        capacityProviders = capacityProviders,
        clusterName = clusterName,
        defaultCapacityProviderStrategies = defaultCapacityProviderStrategies,
    )
}
