@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.EcsFunctions.getClusterPlain
import com.pulumi.aws.ecs.EcsFunctions.getContainerDefinitionPlain
import com.pulumi.aws.ecs.EcsFunctions.getServicePlain
import com.pulumi.aws.ecs.EcsFunctions.getTaskDefinitionPlain
import com.pulumi.aws.ecs.EcsFunctions.getTaskExecutionPlain
import com.pulumi.aws.ecs.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.aws.ecs.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.GetContainerDefinitionPlainArgs
import com.pulumi.aws.ecs.kotlin.inputs.GetContainerDefinitionPlainArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.GetServicePlainArgs
import com.pulumi.aws.ecs.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskDefinitionPlainArgs
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskDefinitionPlainArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionCapacityProviderStrategy
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionNetworkConfiguration
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionOverrides
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionPlacementConstraint
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionPlacementStrategy
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionPlainArgs
import com.pulumi.aws.ecs.kotlin.inputs.GetTaskExecutionPlainArgsBuilder
import com.pulumi.aws.ecs.kotlin.outputs.GetClusterResult
import com.pulumi.aws.ecs.kotlin.outputs.GetContainerDefinitionResult
import com.pulumi.aws.ecs.kotlin.outputs.GetServiceResult
import com.pulumi.aws.ecs.kotlin.outputs.GetTaskDefinitionResult
import com.pulumi.aws.ecs.kotlin.outputs.GetTaskExecutionResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ecs.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.GetContainerDefinitionResult.Companion.toKotlin as getContainerDefinitionResultToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.GetTaskDefinitionResult.Companion.toKotlin as getTaskDefinitionResultToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.GetTaskExecutionResult.Companion.toKotlin as getTaskExecutionResultToKotlin

public object EcsFunctions {
    /**
     * The ECS Cluster data source allows access to details of a specific
     * cluster within an AWS ECS service.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ecs-mongo = aws.ecs.getCluster({
     *     clusterName: "ecs-mongo-production",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ecs_mongo = aws.ecs.get_cluster(cluster_name="ecs-mongo-production")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ecs_mongo = Aws.Ecs.GetCluster.Invoke(new()
     *     {
     *         ClusterName = "ecs-mongo-production",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecs.LookupCluster(ctx, &ecs.LookupClusterArgs{
     * 			ClusterName: "ecs-mongo-production",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecs.EcsFunctions;
     * import com.pulumi.aws.ecs.inputs.GetClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ecs-mongo = EcsFunctions.getCluster(GetClusterArgs.builder()
     *             .clusterName("ecs-mongo-production")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ecs-mongo:
     *     fn::invoke:
     *       Function: aws:ecs:getCluster
     *       Arguments:
     *         clusterName: ecs-mongo-production
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCluster.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterName Name of the ECS Cluster
     * @param tags Key-value map of resource tags
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(clusterName: String, tags: Map<String, String>? = null): GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterName = clusterName,
            tags = tags,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecs&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit): GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * The ECS container definition data source allows access to details of
     * a specific container within an AWS ECS service.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ecs-mongo = aws.ecs.getContainerDefinition({
     *     taskDefinition: mongo.id,
     *     containerName: "mongodb",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ecs_mongo = aws.ecs.get_container_definition(task_definition=mongo["id"],
     *     container_name="mongodb")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ecs_mongo = Aws.Ecs.GetContainerDefinition.Invoke(new()
     *     {
     *         TaskDefinition = mongo.Id,
     *         ContainerName = "mongodb",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecs.GetContainerDefinition(ctx, &ecs.GetContainerDefinitionArgs{
     * 			TaskDefinition: mongo.Id,
     * 			ContainerName:  "mongodb",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecs.EcsFunctions;
     * import com.pulumi.aws.ecs.inputs.GetContainerDefinitionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ecs-mongo = EcsFunctions.getContainerDefinition(GetContainerDefinitionArgs.builder()
     *             .taskDefinition(mongo.id())
     *             .containerName("mongodb")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ecs-mongo:
     *     fn::invoke:
     *       Function: aws:ecs:getContainerDefinition
     *       Arguments:
     *         taskDefinition: ${mongo.id}
     *         containerName: mongodb
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getContainerDefinition.
     * @return A collection of values returned by getContainerDefinition.
     */
    public suspend fun getContainerDefinition(argument: GetContainerDefinitionPlainArgs): GetContainerDefinitionResult =
        getContainerDefinitionResultToKotlin(getContainerDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getContainerDefinition].
     * @param containerName Name of the container definition
     * @param taskDefinition ARN of the task definition which contains the container
     * @return A collection of values returned by getContainerDefinition.
     */
    public suspend fun getContainerDefinition(containerName: String, taskDefinition: String): GetContainerDefinitionResult {
        val argument = GetContainerDefinitionPlainArgs(
            containerName = containerName,
            taskDefinition = taskDefinition,
        )
        return getContainerDefinitionResultToKotlin(getContainerDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getContainerDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecs&#46;kotlin&#46;inputs&#46;GetContainerDefinitionPlainArgs].
     * @return A collection of values returned by getContainerDefinition.
     */
    public suspend fun getContainerDefinition(argument: suspend GetContainerDefinitionPlainArgsBuilder.() -> Unit): GetContainerDefinitionResult {
        val builder = GetContainerDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContainerDefinitionResultToKotlin(getContainerDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * The ECS Service data source allows access to details of a specific
     * Service within a AWS ECS Cluster.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ecs.getService({
     *     serviceName: "example",
     *     clusterArn: exampleAwsEcsCluster.arn,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ecs.get_service(service_name="example",
     *     cluster_arn=example_aws_ecs_cluster["arn"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ecs.GetService.Invoke(new()
     *     {
     *         ServiceName = "example",
     *         ClusterArn = exampleAwsEcsCluster.Arn,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecs.LookupService(ctx, &ecs.LookupServiceArgs{
     * 			ServiceName: "example",
     * 			ClusterArn:  exampleAwsEcsCluster.Arn,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecs.EcsFunctions;
     * import com.pulumi.aws.ecs.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcsFunctions.getService(GetServiceArgs.builder()
     *             .serviceName("example")
     *             .clusterArn(exampleAwsEcsCluster.arn())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ecs:getService
     *       Arguments:
     *         serviceName: example
     *         clusterArn: ${exampleAwsEcsCluster.arn}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param clusterArn ARN of the ECS Cluster
     * @param serviceName Name of the ECS Service
     * @param tags Resource tags.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(
        clusterArn: String,
        serviceName: String,
        tags: Map<String, String>? = null,
    ): GetServiceResult {
        val argument = GetServicePlainArgs(
            clusterArn = clusterArn,
            serviceName = serviceName,
            tags = tags,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecs&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * The ECS task definition data source allows access to details of
     * a specific AWS ECS task definition.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const mongoTaskDefinition = new aws.ecs.TaskDefinition("mongo", {
     *     family: "mongodb",
     *     containerDefinitions: `[
     *   {
     *     "cpu": 128,
     *     "environment": [{
     *       "name": "SECRET",
     *       "value": "KEY"
     *     }],
     *     "essential": true,
     *     "image": "mongo:latest",
     *     "memory": 128,
     *     "memoryReservation": 64,
     *     "name": "mongodb"
     *   }
     * ]
     * `,
     * });
     * // Simply specify the family to find the latest ACTIVE revision in that family.
     * const mongo = aws.ecs.getTaskDefinitionOutput({
     *     taskDefinition: mongoTaskDefinition.family,
     * });
     * const foo = new aws.ecs.Cluster("foo", {name: "foo"});
     * const mongoService = new aws.ecs.Service("mongo", {
     *     name: "mongo",
     *     cluster: foo.id,
     *     desiredCount: 2,
     *     taskDefinition: mongo.apply(mongo => mongo.arn),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * mongo_task_definition = aws.ecs.TaskDefinition("mongo",
     *     family="mongodb",
     *     container_definitions="""[
     *   {
     *     "cpu": 128,
     *     "environment": [{
     *       "name": "SECRET",
     *       "value": "KEY"
     *     }],
     *     "essential": true,
     *     "image": "mongo:latest",
     *     "memory": 128,
     *     "memoryReservation": 64,
     *     "name": "mongodb"
     *   }
     * ]
     * """)
     * # Simply specify the family to find the latest ACTIVE revision in that family.
     * mongo = aws.ecs.get_task_definition_output(task_definition=mongo_task_definition.family)
     * foo = aws.ecs.Cluster("foo", name="foo")
     * mongo_service = aws.ecs.Service("mongo",
     *     name="mongo",
     *     cluster=foo.id,
     *     desired_count=2,
     *     task_definition=mongo.arn)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var mongoTaskDefinition = new Aws.Ecs.TaskDefinition("mongo", new()
     *     {
     *         Family = "mongodb",
     *         ContainerDefinitions = @"[
     *   {
     *     ""cpu"": 128,
     *     ""environment"": [{
     *       ""name"": ""SECRET"",
     *       ""value"": ""KEY""
     *     }],
     *     ""essential"": true,
     *     ""image"": ""mongo:latest"",
     *     ""memory"": 128,
     *     ""memoryReservation"": 64,
     *     ""name"": ""mongodb""
     *   }
     * ]
     * ",
     *     });
     *     // Simply specify the family to find the latest ACTIVE revision in that family.
     *     var mongo = Aws.Ecs.GetTaskDefinition.Invoke(new()
     *     {
     *         TaskDefinition = mongoTaskDefinition.Family,
     *     });
     *     var foo = new Aws.Ecs.Cluster("foo", new()
     *     {
     *         Name = "foo",
     *     });
     *     var mongoService = new Aws.Ecs.Service("mongo", new()
     *     {
     *         Name = "mongo",
     *         Cluster = foo.Id,
     *         DesiredCount = 2,
     *         TaskDefinition = mongo.Apply(getTaskDefinitionResult => getTaskDefinitionResult.Arn),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		mongoTaskDefinition, err := ecs.NewTaskDefinition(ctx, "mongo", &ecs.TaskDefinitionArgs{
     * 			Family: pulumi.String("mongodb"),
     * 			ContainerDefinitions: pulumi.String(`[
     *   {
     *     "cpu": 128,
     *     "environment": [{
     *       "name": "SECRET",
     *       "value": "KEY"
     *     }],
     *     "essential": true,
     *     "image": "mongo:latest",
     *     "memory": 128,
     *     "memoryReservation": 64,
     *     "name": "mongodb"
     *   }
     * ]
     * `),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Simply specify the family to find the latest ACTIVE revision in that family.
     * 		mongo := ecs.LookupTaskDefinitionOutput(ctx, ecs.GetTaskDefinitionOutputArgs{
     * 			TaskDefinition: mongoTaskDefinition.Family,
     * 		}, nil)
     * 		foo, err := ecs.NewCluster(ctx, "foo", &ecs.ClusterArgs{
     * 			Name: pulumi.String("foo"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ecs.NewService(ctx, "mongo", &ecs.ServiceArgs{
     * 			Name:         pulumi.String("mongo"),
     * 			Cluster:      foo.ID(),
     * 			DesiredCount: pulumi.Int(2),
     * 			TaskDefinition: pulumi.String(mongo.ApplyT(func(mongo ecs.GetTaskDefinitionResult) (*string, error) {
     * 				return &mongo.Arn, nil
     * 			}).(pulumi.StringPtrOutput)),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecs.TaskDefinition;
     * import com.pulumi.aws.ecs.TaskDefinitionArgs;
     * import com.pulumi.aws.ecs.EcsFunctions;
     * import com.pulumi.aws.ecs.inputs.GetTaskDefinitionArgs;
     * import com.pulumi.aws.ecs.Cluster;
     * import com.pulumi.aws.ecs.ClusterArgs;
     * import com.pulumi.aws.ecs.Service;
     * import com.pulumi.aws.ecs.ServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var mongoTaskDefinition = new TaskDefinition("mongoTaskDefinition", TaskDefinitionArgs.builder()
     *             .family("mongodb")
     *             .containerDefinitions("""
     * [
     *   {
     *     "cpu": 128,
     *     "environment": [{
     *       "name": "SECRET",
     *       "value": "KEY"
     *     }],
     *     "essential": true,
     *     "image": "mongo:latest",
     *     "memory": 128,
     *     "memoryReservation": 64,
     *     "name": "mongodb"
     *   }
     * ]
     *             """)
     *             .build());
     *         // Simply specify the family to find the latest ACTIVE revision in that family.
     *         final var mongo = EcsFunctions.getTaskDefinition(GetTaskDefinitionArgs.builder()
     *             .taskDefinition(mongoTaskDefinition.family())
     *             .build());
     *         var foo = new Cluster("foo", ClusterArgs.builder()
     *             .name("foo")
     *             .build());
     *         var mongoService = new Service("mongoService", ServiceArgs.builder()
     *             .name("mongo")
     *             .cluster(foo.id())
     *             .desiredCount(2)
     *             .taskDefinition(mongo.applyValue(getTaskDefinitionResult -> getTaskDefinitionResult).applyValue(mongo -> mongo.applyValue(getTaskDefinitionResult -> getTaskDefinitionResult.arn())))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   foo:
     *     type: aws:ecs:Cluster
     *     properties:
     *       name: foo
     *   mongoTaskDefinition:
     *     type: aws:ecs:TaskDefinition
     *     name: mongo
     *     properties:
     *       family: mongodb
     *       containerDefinitions: |
     *         [
     *           {
     *             "cpu": 128,
     *             "environment": [{
     *               "name": "SECRET",
     *               "value": "KEY"
     *             }],
     *             "essential": true,
     *             "image": "mongo:latest",
     *             "memory": 128,
     *             "memoryReservation": 64,
     *             "name": "mongodb"
     *           }
     *         ]
     *   mongoService:
     *     type: aws:ecs:Service
     *     name: mongo
     *     properties:
     *       name: mongo
     *       cluster: ${foo.id}
     *       desiredCount: 2 # Track the latest ACTIVE revision
     *       taskDefinition: ${mongo.arn}
     * variables:
     *   # Simply specify the family to find the latest ACTIVE revision in that family.
     *   mongo:
     *     fn::invoke:
     *       Function: aws:ecs:getTaskDefinition
     *       Arguments:
     *         taskDefinition: ${mongoTaskDefinition.family}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTaskDefinition.
     * @return A collection of values returned by getTaskDefinition.
     */
    public suspend fun getTaskDefinition(argument: GetTaskDefinitionPlainArgs): GetTaskDefinitionResult =
        getTaskDefinitionResultToKotlin(getTaskDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getTaskDefinition].
     * @param taskDefinition Family for the latest ACTIVE revision, family and revision (family:revision) for a specific revision in the family, the ARN of the task definition to access to.
     * @return A collection of values returned by getTaskDefinition.
     */
    public suspend fun getTaskDefinition(taskDefinition: String): GetTaskDefinitionResult {
        val argument = GetTaskDefinitionPlainArgs(
            taskDefinition = taskDefinition,
        )
        return getTaskDefinitionResultToKotlin(getTaskDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getTaskDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecs&#46;kotlin&#46;inputs&#46;GetTaskDefinitionPlainArgs].
     * @return A collection of values returned by getTaskDefinition.
     */
    public suspend fun getTaskDefinition(argument: suspend GetTaskDefinitionPlainArgsBuilder.() -> Unit): GetTaskDefinitionResult {
        val builder = GetTaskDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTaskDefinitionResultToKotlin(getTaskDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS ECS (Elastic Container) Task Execution. This data source calls the [RunTask](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API, allowing execution of one-time tasks that don't fit a standard resource lifecycle. See the feature request issue for additional context.
     * > **NOTE on preview operations:** This data source calls the `RunTask` API on every read operation, which means new task(s) may be created from a `pulumi preview` command if all attributes are known. Placing this functionality behind a data source is an intentional trade off to enable use cases requiring a one-time task execution without relying on provisioners. Caution should be taken to ensure the data source is only executed once, or that the resulting tasks can safely run in parallel.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ecs.getTaskExecution({
     *     cluster: exampleAwsEcsCluster.id,
     *     taskDefinition: exampleAwsEcsTaskDefinition.arn,
     *     desiredCount: 1,
     *     launchType: "FARGATE",
     *     networkConfiguration: {
     *         subnets: exampleAwsSubnet.map(__item => __item.id),
     *         securityGroups: [exampleAwsSecurityGroup&#46;id],
     *         assignPublicIp: false,
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ecs.get_task_execution(cluster=example_aws_ecs_cluster["id"],
     *     task_definition=example_aws_ecs_task_definition["arn"],
     *     desired_count=1,
     *     launch_type="FARGATE",
     *     network_configuration={
     *         "subnets": [__item["id"] for __item in example_aws_subnet],
     *         "security_groups": [example_aws_security_group["id"]],
     *         "assign_public_ip": False,
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ecs.GetTaskExecution.Invoke(new()
     *     {
     *         Cluster = exampleAwsEcsCluster.Id,
     *         TaskDefinition = exampleAwsEcsTaskDefinition.Arn,
     *         DesiredCount = 1,
     *         LaunchType = "FARGATE",
     *         NetworkConfiguration = new Aws.Ecs.Inputs.GetTaskExecutionNetworkConfigurationInputArgs
     *         {
     *             Subnets = exampleAwsSubnet.Select(__item => __item.Id).ToList(),
     *             SecurityGroups = new[]
     *             {
     *                 exampleAwsSecurityGroup.Id,
     *             },
     *             AssignPublicIp = false,
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _, err := ecs.GetTaskExecution(ctx, &ecs.GetTaskExecutionArgs{
     * Cluster: exampleAwsEcsCluster.Id,
     * TaskDefinition: exampleAwsEcsTaskDefinition.Arn,
     * DesiredCount: pulumi.IntRef(1),
     * LaunchType: pulumi.StringRef("FARGATE"),
     * NetworkConfiguration: ecs.GetTaskExecutionNetworkConfiguration{
     * Subnets: []string(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:6,22-44)),
     * SecurityGroups: interface{}{
     * exampleAwsSecurityGroup.Id,
     * },
     * AssignPublicIp: pulumi.BoolRef(false),
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecs.EcsFunctions;
     * import com.pulumi.aws.ecs.inputs.GetTaskExecutionArgs;
     * import com.pulumi.aws.ecs.inputs.GetTaskExecutionNetworkConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcsFunctions.getTaskExecution(GetTaskExecutionArgs.builder()
     *             .cluster(exampleAwsEcsCluster.id())
     *             .taskDefinition(exampleAwsEcsTaskDefinition.arn())
     *             .desiredCount(1)
     *             .launchType("FARGATE")
     *             .networkConfiguration(GetTaskExecutionNetworkConfigurationArgs.builder()
     *                 .subnets(exampleAwsSubnet.stream().map(element -> element.id()).collect(toList()))
     *                 .securityGroups(exampleAwsSecurityGroup.id())
     *                 .assignPublicIp(false)
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTaskExecution.
     * @return A collection of values returned by getTaskExecution.
     */
    public suspend fun getTaskExecution(argument: GetTaskExecutionPlainArgs): GetTaskExecutionResult =
        getTaskExecutionResultToKotlin(getTaskExecutionPlain(argument.toJava()).await())

    /**
     * @see [getTaskExecution].
     * @param capacityProviderStrategies Set of capacity provider strategies to use for the cluster. See below.
     * @param clientToken An identifier that you provide to ensure the idempotency of the request. It must be unique and is case sensitive. Up to 64 characters are allowed. The valid characters are characters in the range of 33-126, inclusive. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/ECS_Idempotency.html).
     * @param cluster Short name or full Amazon Resource Name (ARN) of the cluster to run the task on.
     * @param desiredCount Number of instantiations of the specified task to place on your cluster. You can specify up to 10 tasks for each call.
     * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
     * @param enableExecuteCommand Specifies whether to enable Amazon ECS Exec for the tasks within the service.
     * @param group Name of the task group to associate with the task. The default value is the family name of the task definition.
     * @param launchType Launch type on which to run your service. Valid values are `EC2`, `FARGATE`, and `EXTERNAL`.
     * @param networkConfiguration Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
     * @param overrides A list of container overrides that specify the name of a container in the specified task definition and the overrides it should receive.
     * @param placementConstraints An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task. See below.
     * @param placementStrategies The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task. See below.
     * @param platformVersion The platform version the task uses. A platform version is only specified for tasks hosted on Fargate. If one isn't specified, the `LATEST` platform version is used.
     * @param propagateTags Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. An error will be received if you specify the `SERVICE` option when running a task. Valid values are `TASK_DEFINITION` or `NONE`.
     * @param referenceId The reference ID to use for the task.
     * @param startedBy An optional tag specified when a task is started.
     * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * @param taskDefinition The `family` and `revision` (`family:revision`) or full ARN of the task definition to run. If a revision isn't specified, the latest `ACTIVE` revision is used.
     * The following arguments are optional:
     * @return A collection of values returned by getTaskExecution.
     */
    public suspend fun getTaskExecution(
        capacityProviderStrategies: List<GetTaskExecutionCapacityProviderStrategy>? = null,
        clientToken: String? = null,
        cluster: String,
        desiredCount: Int? = null,
        enableEcsManagedTags: Boolean? = null,
        enableExecuteCommand: Boolean? = null,
        group: String? = null,
        launchType: String? = null,
        networkConfiguration: GetTaskExecutionNetworkConfiguration? = null,
        overrides: GetTaskExecutionOverrides? = null,
        placementConstraints: List<GetTaskExecutionPlacementConstraint>? = null,
        placementStrategies: List<GetTaskExecutionPlacementStrategy>? = null,
        platformVersion: String? = null,
        propagateTags: String? = null,
        referenceId: String? = null,
        startedBy: String? = null,
        tags: Map<String, String>? = null,
        taskDefinition: String,
    ): GetTaskExecutionResult {
        val argument = GetTaskExecutionPlainArgs(
            capacityProviderStrategies = capacityProviderStrategies,
            clientToken = clientToken,
            cluster = cluster,
            desiredCount = desiredCount,
            enableEcsManagedTags = enableEcsManagedTags,
            enableExecuteCommand = enableExecuteCommand,
            group = group,
            launchType = launchType,
            networkConfiguration = networkConfiguration,
            overrides = overrides,
            placementConstraints = placementConstraints,
            placementStrategies = placementStrategies,
            platformVersion = platformVersion,
            propagateTags = propagateTags,
            referenceId = referenceId,
            startedBy = startedBy,
            tags = tags,
            taskDefinition = taskDefinition,
        )
        return getTaskExecutionResultToKotlin(getTaskExecutionPlain(argument.toJava()).await())
    }

    /**
     * @see [getTaskExecution].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecs&#46;kotlin&#46;inputs&#46;GetTaskExecutionPlainArgs].
     * @return A collection of values returned by getTaskExecution.
     */
    public suspend fun getTaskExecution(argument: suspend GetTaskExecutionPlainArgsBuilder.() -> Unit): GetTaskExecutionResult {
        val builder = GetTaskExecutionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTaskExecutionResultToKotlin(getTaskExecutionPlain(builtArgument.toJava()).await())
    }
}
