@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.kotlin.outputs.ServiceAlarms
import com.pulumi.aws.ecs.kotlin.outputs.ServiceCapacityProviderStrategy
import com.pulumi.aws.ecs.kotlin.outputs.ServiceDeploymentCircuitBreaker
import com.pulumi.aws.ecs.kotlin.outputs.ServiceDeploymentController
import com.pulumi.aws.ecs.kotlin.outputs.ServiceLoadBalancer
import com.pulumi.aws.ecs.kotlin.outputs.ServiceNetworkConfiguration
import com.pulumi.aws.ecs.kotlin.outputs.ServiceOrderedPlacementStrategy
import com.pulumi.aws.ecs.kotlin.outputs.ServicePlacementConstraint
import com.pulumi.aws.ecs.kotlin.outputs.ServiceServiceConnectConfiguration
import com.pulumi.aws.ecs.kotlin.outputs.ServiceServiceRegistries
import com.pulumi.aws.ecs.kotlin.outputs.ServiceVolumeConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ecs.kotlin.outputs.ServiceAlarms.Companion.toKotlin as serviceAlarmsToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.ServiceCapacityProviderStrategy.Companion.toKotlin as serviceCapacityProviderStrategyToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.ServiceDeploymentCircuitBreaker.Companion.toKotlin as serviceDeploymentCircuitBreakerToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.ServiceDeploymentController.Companion.toKotlin as serviceDeploymentControllerToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.ServiceLoadBalancer.Companion.toKotlin as serviceLoadBalancerToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.ServiceNetworkConfiguration.Companion.toKotlin as serviceNetworkConfigurationToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.ServiceOrderedPlacementStrategy.Companion.toKotlin as serviceOrderedPlacementStrategyToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.ServicePlacementConstraint.Companion.toKotlin as servicePlacementConstraintToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.ServiceServiceConnectConfiguration.Companion.toKotlin as serviceServiceConnectConfigurationToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.ServiceServiceRegistries.Companion.toKotlin as serviceServiceRegistriesToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.ServiceVolumeConfiguration.Companion.toKotlin as serviceVolumeConfigurationToKotlin

/**
 * Builder for [Service].
 */
@PulumiTagMarker
public class ServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceArgs = ServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceArgsBuilder.() -> Unit) {
        val builder = ServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Service {
        val builtJavaResource = com.pulumi.aws.ecs.Service(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Service(builtJavaResource)
    }
}

/**
 * > **Note:** To prevent a race condition during service deletion, make sure to set `depends_on` to the related `aws.iam.RolePolicy`; otherwise, the policy may be destroyed too soon and the ECS service will then get stuck in the `DRAINING` state.
 * Provides an ECS service - effectively a task that is expected to run until an error occurs or a user terminates it (typically a webserver or a database).
 * See [ECS Services section in AWS developer guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const mongo = new aws.ecs.Service("mongo", {
 *     name: "mongodb",
 *     cluster: fooAwsEcsCluster.id,
 *     taskDefinition: mongoAwsEcsTaskDefinition.arn,
 *     desiredCount: 3,
 *     iamRole: fooAwsIamRole.arn,
 *     orderedPlacementStrategies: [{
 *         type: "binpack",
 *         field: "cpu",
 *     }],
 *     loadBalancers: [{
 *         targetGroupArn: fooAwsLbTargetGroup.arn,
 *         containerName: "mongo",
 *         containerPort: 8080,
 *     }],
 *     placementConstraints: [{
 *         type: "memberOf",
 *         expression: "attribute:ecs.availability-zone in [us-west-2a, us-west-2b]",
 *     }],
 * }, {
 *     dependsOn: [foo],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * mongo = aws.ecs.Service("mongo",
 *     name="mongodb",
 *     cluster=foo_aws_ecs_cluster["id"],
 *     task_definition=mongo_aws_ecs_task_definition["arn"],
 *     desired_count=3,
 *     iam_role=foo_aws_iam_role["arn"],
 *     ordered_placement_strategies=[{
 *         "type": "binpack",
 *         "field": "cpu",
 *     }],
 *     load_balancers=[{
 *         "target_group_arn": foo_aws_lb_target_group["arn"],
 *         "container_name": "mongo",
 *         "container_port": 8080,
 *     }],
 *     placement_constraints=[{
 *         "type": "memberOf",
 *         "expression": "attribute:ecs.availability-zone in [us-west-2a, us-west-2b]",
 *     }],
 *     opts = pulumi.ResourceOptions(depends_on=[foo]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mongo = new Aws.Ecs.Service("mongo", new()
 *     {
 *         Name = "mongodb",
 *         Cluster = fooAwsEcsCluster.Id,
 *         TaskDefinition = mongoAwsEcsTaskDefinition.Arn,
 *         DesiredCount = 3,
 *         IamRole = fooAwsIamRole.Arn,
 *         OrderedPlacementStrategies = new[]
 *         {
 *             new Aws.Ecs.Inputs.ServiceOrderedPlacementStrategyArgs
 *             {
 *                 Type = "binpack",
 *                 Field = "cpu",
 *             },
 *         },
 *         LoadBalancers = new[]
 *         {
 *             new Aws.Ecs.Inputs.ServiceLoadBalancerArgs
 *             {
 *                 TargetGroupArn = fooAwsLbTargetGroup.Arn,
 *                 ContainerName = "mongo",
 *                 ContainerPort = 8080,
 *             },
 *         },
 *         PlacementConstraints = new[]
 *         {
 *             new Aws.Ecs.Inputs.ServicePlacementConstraintArgs
 *             {
 *                 Type = "memberOf",
 *                 Expression = "attribute:ecs.availability-zone in [us-west-2a, us-west-2b]",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             foo,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewService(ctx, "mongo", &ecs.ServiceArgs{
 * 			Name:           pulumi.String("mongodb"),
 * 			Cluster:        pulumi.Any(fooAwsEcsCluster.Id),
 * 			TaskDefinition: pulumi.Any(mongoAwsEcsTaskDefinition.Arn),
 * 			DesiredCount:   pulumi.Int(3),
 * 			IamRole:        pulumi.Any(fooAwsIamRole.Arn),
 * 			OrderedPlacementStrategies: ecs.ServiceOrderedPlacementStrategyArray{
 * 				&ecs.ServiceOrderedPlacementStrategyArgs{
 * 					Type:  pulumi.String("binpack"),
 * 					Field: pulumi.String("cpu"),
 * 				},
 * 			},
 * 			LoadBalancers: ecs.ServiceLoadBalancerArray{
 * 				&ecs.ServiceLoadBalancerArgs{
 * 					TargetGroupArn: pulumi.Any(fooAwsLbTargetGroup.Arn),
 * 					ContainerName:  pulumi.String("mongo"),
 * 					ContainerPort:  pulumi.Int(8080),
 * 				},
 * 			},
 * 			PlacementConstraints: ecs.ServicePlacementConstraintArray{
 * 				&ecs.ServicePlacementConstraintArgs{
 * 					Type:       pulumi.String("memberOf"),
 * 					Expression: pulumi.String("attribute:ecs.availability-zone in [us-west-2a, us-west-2b]"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			foo,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import com.pulumi.aws.ecs.inputs.ServiceOrderedPlacementStrategyArgs;
 * import com.pulumi.aws.ecs.inputs.ServiceLoadBalancerArgs;
 * import com.pulumi.aws.ecs.inputs.ServicePlacementConstraintArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mongo = new Service("mongo", ServiceArgs.builder()
 *             .name("mongodb")
 *             .cluster(fooAwsEcsCluster.id())
 *             .taskDefinition(mongoAwsEcsTaskDefinition.arn())
 *             .desiredCount(3)
 *             .iamRole(fooAwsIamRole.arn())
 *             .orderedPlacementStrategies(ServiceOrderedPlacementStrategyArgs.builder()
 *                 .type("binpack")
 *                 .field("cpu")
 *                 .build())
 *             .loadBalancers(ServiceLoadBalancerArgs.builder()
 *                 .targetGroupArn(fooAwsLbTargetGroup.arn())
 *                 .containerName("mongo")
 *                 .containerPort(8080)
 *                 .build())
 *             .placementConstraints(ServicePlacementConstraintArgs.builder()
 *                 .type("memberOf")
 *                 .expression("attribute:ecs.availability-zone in [us-west-2a, us-west-2b]")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(foo)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   mongo:
 *     type: aws:ecs:Service
 *     properties:
 *       name: mongodb
 *       cluster: ${fooAwsEcsCluster.id}
 *       taskDefinition: ${mongoAwsEcsTaskDefinition.arn}
 *       desiredCount: 3
 *       iamRole: ${fooAwsIamRole.arn}
 *       orderedPlacementStrategies:
 *         - type: binpack
 *           field: cpu
 *       loadBalancers:
 *         - targetGroupArn: ${fooAwsLbTargetGroup.arn}
 *           containerName: mongo
 *           containerPort: 8080
 *       placementConstraints:
 *         - type: memberOf
 *           expression: attribute:ecs.availability-zone in [us-west-2a, us-west-2b]
 *     options:
 *       dependson:
 *         - ${foo}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Ignoring Changes to Desired Count
 * You can use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to create an ECS service with an initial count of running instances, then ignore any changes to that count caused externally (e.g. Application Autoscaling).
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecs.Service("example", {desiredCount: 2});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecs.Service("example", desired_count=2)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecs.Service("example", new()
 *     {
 *         DesiredCount = 2,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewService(ctx, "example", &ecs.ServiceArgs{
 * 			DesiredCount: pulumi.Int(2),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .desiredCount(2)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecs:Service
 *     properties:
 *       desiredCount: 2 # Optional: Allow external changes without this provider plan difference
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Daemon Scheduling Strategy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const bar = new aws.ecs.Service("bar", {
 *     name: "bar",
 *     cluster: foo.id,
 *     taskDefinition: barAwsEcsTaskDefinition.arn,
 *     schedulingStrategy: "DAEMON",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * bar = aws.ecs.Service("bar",
 *     name="bar",
 *     cluster=foo["id"],
 *     task_definition=bar_aws_ecs_task_definition["arn"],
 *     scheduling_strategy="DAEMON")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bar = new Aws.Ecs.Service("bar", new()
 *     {
 *         Name = "bar",
 *         Cluster = foo.Id,
 *         TaskDefinition = barAwsEcsTaskDefinition.Arn,
 *         SchedulingStrategy = "DAEMON",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewService(ctx, "bar", &ecs.ServiceArgs{
 * 			Name:               pulumi.String("bar"),
 * 			Cluster:            pulumi.Any(foo.Id),
 * 			TaskDefinition:     pulumi.Any(barAwsEcsTaskDefinition.Arn),
 * 			SchedulingStrategy: pulumi.String("DAEMON"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Service("bar", ServiceArgs.builder()
 *             .name("bar")
 *             .cluster(foo.id())
 *             .taskDefinition(barAwsEcsTaskDefinition.arn())
 *             .schedulingStrategy("DAEMON")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:ecs:Service
 *     properties:
 *       name: bar
 *       cluster: ${foo.id}
 *       taskDefinition: ${barAwsEcsTaskDefinition.arn}
 *       schedulingStrategy: DAEMON
 * ```
 * <!--End PulumiCodeChooser -->
 * ### CloudWatch Deployment Alarms
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecs.Service("example", {
 *     name: "example",
 *     cluster: exampleAwsEcsCluster.id,
 *     alarms: {
 *         enable: true,
 *         rollback: true,
 *         alarmNames: [exampleAwsCloudwatchMetricAlarm&#46;alarmName],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecs.Service("example",
 *     name="example",
 *     cluster=example_aws_ecs_cluster["id"],
 *     alarms={
 *         "enable": True,
 *         "rollback": True,
 *         "alarm_names": [example_aws_cloudwatch_metric_alarm["alarmName"]],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecs.Service("example", new()
 *     {
 *         Name = "example",
 *         Cluster = exampleAwsEcsCluster.Id,
 *         Alarms = new Aws.Ecs.Inputs.ServiceAlarmsArgs
 *         {
 *             Enable = true,
 *             Rollback = true,
 *             AlarmNames = new[]
 *             {
 *                 exampleAwsCloudwatchMetricAlarm.AlarmName,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewService(ctx, "example", &ecs.ServiceArgs{
 * 			Name:    pulumi.String("example"),
 * 			Cluster: pulumi.Any(exampleAwsEcsCluster.Id),
 * 			Alarms: &ecs.ServiceAlarmsArgs{
 * 				Enable:   pulumi.Bool(true),
 * 				Rollback: pulumi.Bool(true),
 * 				AlarmNames: pulumi.StringArray{
 * 					exampleAwsCloudwatchMetricAlarm.AlarmName,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import com.pulumi.aws.ecs.inputs.ServiceAlarmsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .name("example")
 *             .cluster(exampleAwsEcsCluster.id())
 *             .alarms(ServiceAlarmsArgs.builder()
 *                 .enable(true)
 *                 .rollback(true)
 *                 .alarmNames(exampleAwsCloudwatchMetricAlarm.alarmName())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecs:Service
 *     properties:
 *       name: example
 *       cluster: ${exampleAwsEcsCluster.id}
 *       alarms:
 *         enable: true
 *         rollback: true
 *         alarmNames:
 *           - ${exampleAwsCloudwatchMetricAlarm.alarmName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### External Deployment Controller
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecs.Service("example", {
 *     name: "example",
 *     cluster: exampleAwsEcsCluster.id,
 *     deploymentController: {
 *         type: "EXTERNAL",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecs.Service("example",
 *     name="example",
 *     cluster=example_aws_ecs_cluster["id"],
 *     deployment_controller={
 *         "type": "EXTERNAL",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecs.Service("example", new()
 *     {
 *         Name = "example",
 *         Cluster = exampleAwsEcsCluster.Id,
 *         DeploymentController = new Aws.Ecs.Inputs.ServiceDeploymentControllerArgs
 *         {
 *             Type = "EXTERNAL",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewService(ctx, "example", &ecs.ServiceArgs{
 * 			Name:    pulumi.String("example"),
 * 			Cluster: pulumi.Any(exampleAwsEcsCluster.Id),
 * 			DeploymentController: &ecs.ServiceDeploymentControllerArgs{
 * 				Type: pulumi.String("EXTERNAL"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import com.pulumi.aws.ecs.inputs.ServiceDeploymentControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .name("example")
 *             .cluster(exampleAwsEcsCluster.id())
 *             .deploymentController(ServiceDeploymentControllerArgs.builder()
 *                 .type("EXTERNAL")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecs:Service
 *     properties:
 *       name: example
 *       cluster: ${exampleAwsEcsCluster.id}
 *       deploymentController:
 *         type: EXTERNAL
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Redeploy Service On Every Apply
 * The key used with `triggers` is arbitrary.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecs.Service("example", {
 *     forceNewDeployment: true,
 *     triggers: {
 *         redeployment: "plantimestamp()",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecs.Service("example",
 *     force_new_deployment=True,
 *     triggers={
 *         "redeployment": "plantimestamp()",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecs.Service("example", new()
 *     {
 *         ForceNewDeployment = true,
 *         Triggers =
 *         {
 *             { "redeployment", "plantimestamp()" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewService(ctx, "example", &ecs.ServiceArgs{
 * 			ForceNewDeployment: pulumi.Bool(true),
 * 			Triggers: pulumi.StringMap{
 * 				"redeployment": pulumi.String("plantimestamp()"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .forceNewDeployment(true)
 *             .triggers(Map.of("redeployment", "plantimestamp()"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecs:Service
 *     properties:
 *       forceNewDeployment: true
 *       triggers:
 *         redeployment: plantimestamp()
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECS services using the `name` together with ecs cluster `name`. For example:
 * ```sh
 * $ pulumi import aws:ecs/service:Service imported cluster-name/service-name
 * ```
 */
public class Service internal constructor(
    override val javaResource: com.pulumi.aws.ecs.Service,
) : KotlinCustomResource(javaResource, ServiceMapper) {
    /**
     * Information about the CloudWatch alarms. See below.
     */
    public val alarms: Output<ServiceAlarms>?
        get() = javaResource.alarms().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serviceAlarmsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
     */
    public val capacityProviderStrategies: Output<List<ServiceCapacityProviderStrategy>>?
        get() = javaResource.capacityProviderStrategies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        serviceCapacityProviderStrategyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * ARN of an ECS cluster.
     */
    public val cluster: Output<String>
        get() = javaResource.cluster().applyValue({ args0 -> args0 })

    /**
     * Configuration block for deployment circuit breaker. See below.
     */
    public val deploymentCircuitBreaker: Output<ServiceDeploymentCircuitBreaker>?
        get() = javaResource.deploymentCircuitBreaker().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceDeploymentCircuitBreakerToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration block for deployment controller configuration. See below.
     */
    public val deploymentController: Output<ServiceDeploymentController>?
        get() = javaResource.deploymentController().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceDeploymentControllerToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
     */
    public val deploymentMaximumPercent: Output<Int>?
        get() = javaResource.deploymentMaximumPercent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
     */
    public val deploymentMinimumHealthyPercent: Output<Int>?
        get() = javaResource.deploymentMinimumHealthyPercent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
     */
    public val desiredCount: Output<Int>?
        get() = javaResource.desiredCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable Amazon ECS managed tags for the tasks within the service.
     */
    public val enableEcsManagedTags: Output<Boolean>?
        get() = javaResource.enableEcsManagedTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable Amazon ECS Exec for the tasks within the service.
     */
    public val enableExecuteCommand: Output<Boolean>?
        get() = javaResource.enableExecuteCommand().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the `REPLICA` scheduling strategy.
     */
    public val forceDelete: Output<Boolean>?
        get() = javaResource.forceDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
     */
    public val forceNewDeployment: Output<Boolean>?
        get() = javaResource.forceNewDeployment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
     */
    public val healthCheckGracePeriodSeconds: Output<Int>?
        get() = javaResource.healthCheckGracePeriodSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
     */
    public val iamRole: Output<String>
        get() = javaResource.iamRole().applyValue({ args0 -> args0 })

    /**
     * Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`. Conflicts with `capacity_provider_strategy`.
     */
    public val launchType: Output<String>
        get() = javaResource.launchType().applyValue({ args0 -> args0 })

    /**
     * Configuration block for load balancers. See below.
     */
    public val loadBalancers: Output<List<ServiceLoadBalancer>>?
        get() = javaResource.loadBalancers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        serviceLoadBalancerToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Name of the service (up to 255 letters, numbers, hyphens, and underscores)
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
     */
    public val networkConfiguration: Output<ServiceNetworkConfiguration>?
        get() = javaResource.networkConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceNetworkConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    public val orderedPlacementStrategies: Output<List<ServiceOrderedPlacementStrategy>>?
        get() = javaResource.orderedPlacementStrategies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        serviceOrderedPlacementStrategyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    public val placementConstraints: Output<List<ServicePlacementConstraint>>?
        get() = javaResource.placementConstraints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        servicePlacementConstraintToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
     */
    public val platformVersion: Output<String>
        get() = javaResource.platformVersion().applyValue({ args0 -> args0 })

    /**
     * Whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
     */
    public val propagateTags: Output<String>?
        get() = javaResource.propagateTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
     */
    public val schedulingStrategy: Output<String>?
        get() = javaResource.schedulingStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
     */
    public val serviceConnectConfiguration: Output<ServiceServiceConnectConfiguration>?
        get() = javaResource.serviceConnectConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceServiceConnectConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
     */
    public val serviceRegistries: Output<ServiceServiceRegistries>?
        get() = javaResource.serviceRegistries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceServiceRegistriesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
     */
    public val taskDefinition: Output<String>?
        get() = javaResource.taskDefinition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `"plantimestamp()"`. When using the triggers property you also need to set the forceNewDeployment property to True.
     */
    public val triggers: Output<Map<String, String>>
        get() = javaResource.triggers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume. See below.
     */
    public val volumeConfiguration: Output<ServiceVolumeConfiguration>?
        get() = javaResource.volumeConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceVolumeConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
     */
    public val waitForSteadyState: Output<Boolean>?
        get() = javaResource.waitForSteadyState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ServiceMapper : ResourceMapper<Service> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecs.Service::class == javaResource::class

    override fun map(javaResource: Resource): Service = Service(
        javaResource as
            com.pulumi.aws.ecs.Service,
    )
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Service].
 */
public suspend fun service(name: String, block: suspend ServiceResourceBuilder.() -> Unit): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 */
public fun service(name: String): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
