@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.ServiceArgs.builder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceAlarmsArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceAlarmsArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceCapacityProviderStrategyArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceCapacityProviderStrategyArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceDeploymentCircuitBreakerArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceDeploymentCircuitBreakerArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceDeploymentControllerArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceDeploymentControllerArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceLoadBalancerArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceLoadBalancerArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceNetworkConfigurationArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceNetworkConfigurationArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceOrderedPlacementStrategyArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceOrderedPlacementStrategyArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServicePlacementConstraintArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServicePlacementConstraintArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceServiceConnectConfigurationArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceServiceConnectConfigurationArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceServiceRegistriesArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceServiceRegistriesArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.ServiceVolumeConfigurationArgs
import com.pulumi.aws.ecs.kotlin.inputs.ServiceVolumeConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * > **Note:** To prevent a race condition during service deletion, make sure to set `depends_on` to the related `aws.iam.RolePolicy`; otherwise, the policy may be destroyed too soon and the ECS service will then get stuck in the `DRAINING` state.
 * Provides an ECS service - effectively a task that is expected to run until an error occurs or a user terminates it (typically a webserver or a database).
 * See [ECS Services section in AWS developer guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const mongo = new aws.ecs.Service("mongo", {
 *     name: "mongodb",
 *     cluster: fooAwsEcsCluster.id,
 *     taskDefinition: mongoAwsEcsTaskDefinition.arn,
 *     desiredCount: 3,
 *     iamRole: fooAwsIamRole.arn,
 *     orderedPlacementStrategies: [{
 *         type: "binpack",
 *         field: "cpu",
 *     }],
 *     loadBalancers: [{
 *         targetGroupArn: fooAwsLbTargetGroup.arn,
 *         containerName: "mongo",
 *         containerPort: 8080,
 *     }],
 *     placementConstraints: [{
 *         type: "memberOf",
 *         expression: "attribute:ecs.availability-zone in [us-west-2a, us-west-2b]",
 *     }],
 * }, {
 *     dependsOn: [foo],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * mongo = aws.ecs.Service("mongo",
 *     name="mongodb",
 *     cluster=foo_aws_ecs_cluster["id"],
 *     task_definition=mongo_aws_ecs_task_definition["arn"],
 *     desired_count=3,
 *     iam_role=foo_aws_iam_role["arn"],
 *     ordered_placement_strategies=[{
 *         "type": "binpack",
 *         "field": "cpu",
 *     }],
 *     load_balancers=[{
 *         "target_group_arn": foo_aws_lb_target_group["arn"],
 *         "container_name": "mongo",
 *         "container_port": 8080,
 *     }],
 *     placement_constraints=[{
 *         "type": "memberOf",
 *         "expression": "attribute:ecs.availability-zone in [us-west-2a, us-west-2b]",
 *     }],
 *     opts = pulumi.ResourceOptions(depends_on=[foo]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mongo = new Aws.Ecs.Service("mongo", new()
 *     {
 *         Name = "mongodb",
 *         Cluster = fooAwsEcsCluster.Id,
 *         TaskDefinition = mongoAwsEcsTaskDefinition.Arn,
 *         DesiredCount = 3,
 *         IamRole = fooAwsIamRole.Arn,
 *         OrderedPlacementStrategies = new[]
 *         {
 *             new Aws.Ecs.Inputs.ServiceOrderedPlacementStrategyArgs
 *             {
 *                 Type = "binpack",
 *                 Field = "cpu",
 *             },
 *         },
 *         LoadBalancers = new[]
 *         {
 *             new Aws.Ecs.Inputs.ServiceLoadBalancerArgs
 *             {
 *                 TargetGroupArn = fooAwsLbTargetGroup.Arn,
 *                 ContainerName = "mongo",
 *                 ContainerPort = 8080,
 *             },
 *         },
 *         PlacementConstraints = new[]
 *         {
 *             new Aws.Ecs.Inputs.ServicePlacementConstraintArgs
 *             {
 *                 Type = "memberOf",
 *                 Expression = "attribute:ecs.availability-zone in [us-west-2a, us-west-2b]",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             foo,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewService(ctx, "mongo", &ecs.ServiceArgs{
 * 			Name:           pulumi.String("mongodb"),
 * 			Cluster:        pulumi.Any(fooAwsEcsCluster.Id),
 * 			TaskDefinition: pulumi.Any(mongoAwsEcsTaskDefinition.Arn),
 * 			DesiredCount:   pulumi.Int(3),
 * 			IamRole:        pulumi.Any(fooAwsIamRole.Arn),
 * 			OrderedPlacementStrategies: ecs.ServiceOrderedPlacementStrategyArray{
 * 				&ecs.ServiceOrderedPlacementStrategyArgs{
 * 					Type:  pulumi.String("binpack"),
 * 					Field: pulumi.String("cpu"),
 * 				},
 * 			},
 * 			LoadBalancers: ecs.ServiceLoadBalancerArray{
 * 				&ecs.ServiceLoadBalancerArgs{
 * 					TargetGroupArn: pulumi.Any(fooAwsLbTargetGroup.Arn),
 * 					ContainerName:  pulumi.String("mongo"),
 * 					ContainerPort:  pulumi.Int(8080),
 * 				},
 * 			},
 * 			PlacementConstraints: ecs.ServicePlacementConstraintArray{
 * 				&ecs.ServicePlacementConstraintArgs{
 * 					Type:       pulumi.String("memberOf"),
 * 					Expression: pulumi.String("attribute:ecs.availability-zone in [us-west-2a, us-west-2b]"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			foo,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import com.pulumi.aws.ecs.inputs.ServiceOrderedPlacementStrategyArgs;
 * import com.pulumi.aws.ecs.inputs.ServiceLoadBalancerArgs;
 * import com.pulumi.aws.ecs.inputs.ServicePlacementConstraintArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mongo = new Service("mongo", ServiceArgs.builder()
 *             .name("mongodb")
 *             .cluster(fooAwsEcsCluster.id())
 *             .taskDefinition(mongoAwsEcsTaskDefinition.arn())
 *             .desiredCount(3)
 *             .iamRole(fooAwsIamRole.arn())
 *             .orderedPlacementStrategies(ServiceOrderedPlacementStrategyArgs.builder()
 *                 .type("binpack")
 *                 .field("cpu")
 *                 .build())
 *             .loadBalancers(ServiceLoadBalancerArgs.builder()
 *                 .targetGroupArn(fooAwsLbTargetGroup.arn())
 *                 .containerName("mongo")
 *                 .containerPort(8080)
 *                 .build())
 *             .placementConstraints(ServicePlacementConstraintArgs.builder()
 *                 .type("memberOf")
 *                 .expression("attribute:ecs.availability-zone in [us-west-2a, us-west-2b]")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(foo)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   mongo:
 *     type: aws:ecs:Service
 *     properties:
 *       name: mongodb
 *       cluster: ${fooAwsEcsCluster.id}
 *       taskDefinition: ${mongoAwsEcsTaskDefinition.arn}
 *       desiredCount: 3
 *       iamRole: ${fooAwsIamRole.arn}
 *       orderedPlacementStrategies:
 *         - type: binpack
 *           field: cpu
 *       loadBalancers:
 *         - targetGroupArn: ${fooAwsLbTargetGroup.arn}
 *           containerName: mongo
 *           containerPort: 8080
 *       placementConstraints:
 *         - type: memberOf
 *           expression: attribute:ecs.availability-zone in [us-west-2a, us-west-2b]
 *     options:
 *       dependson:
 *         - ${foo}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Ignoring Changes to Desired Count
 * You can use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to create an ECS service with an initial count of running instances, then ignore any changes to that count caused externally (e.g. Application Autoscaling).
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecs.Service("example", {desiredCount: 2});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecs.Service("example", desired_count=2)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecs.Service("example", new()
 *     {
 *         DesiredCount = 2,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewService(ctx, "example", &ecs.ServiceArgs{
 * 			DesiredCount: pulumi.Int(2),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .desiredCount(2)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecs:Service
 *     properties:
 *       desiredCount: 2 # Optional: Allow external changes without this provider plan difference
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Daemon Scheduling Strategy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const bar = new aws.ecs.Service("bar", {
 *     name: "bar",
 *     cluster: foo.id,
 *     taskDefinition: barAwsEcsTaskDefinition.arn,
 *     schedulingStrategy: "DAEMON",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * bar = aws.ecs.Service("bar",
 *     name="bar",
 *     cluster=foo["id"],
 *     task_definition=bar_aws_ecs_task_definition["arn"],
 *     scheduling_strategy="DAEMON")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bar = new Aws.Ecs.Service("bar", new()
 *     {
 *         Name = "bar",
 *         Cluster = foo.Id,
 *         TaskDefinition = barAwsEcsTaskDefinition.Arn,
 *         SchedulingStrategy = "DAEMON",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewService(ctx, "bar", &ecs.ServiceArgs{
 * 			Name:               pulumi.String("bar"),
 * 			Cluster:            pulumi.Any(foo.Id),
 * 			TaskDefinition:     pulumi.Any(barAwsEcsTaskDefinition.Arn),
 * 			SchedulingStrategy: pulumi.String("DAEMON"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Service("bar", ServiceArgs.builder()
 *             .name("bar")
 *             .cluster(foo.id())
 *             .taskDefinition(barAwsEcsTaskDefinition.arn())
 *             .schedulingStrategy("DAEMON")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:ecs:Service
 *     properties:
 *       name: bar
 *       cluster: ${foo.id}
 *       taskDefinition: ${barAwsEcsTaskDefinition.arn}
 *       schedulingStrategy: DAEMON
 * ```
 * <!--End PulumiCodeChooser -->
 * ### CloudWatch Deployment Alarms
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecs.Service("example", {
 *     name: "example",
 *     cluster: exampleAwsEcsCluster.id,
 *     alarms: {
 *         enable: true,
 *         rollback: true,
 *         alarmNames: [exampleAwsCloudwatchMetricAlarm&#46;alarmName],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecs.Service("example",
 *     name="example",
 *     cluster=example_aws_ecs_cluster["id"],
 *     alarms={
 *         "enable": True,
 *         "rollback": True,
 *         "alarm_names": [example_aws_cloudwatch_metric_alarm["alarmName"]],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecs.Service("example", new()
 *     {
 *         Name = "example",
 *         Cluster = exampleAwsEcsCluster.Id,
 *         Alarms = new Aws.Ecs.Inputs.ServiceAlarmsArgs
 *         {
 *             Enable = true,
 *             Rollback = true,
 *             AlarmNames = new[]
 *             {
 *                 exampleAwsCloudwatchMetricAlarm.AlarmName,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewService(ctx, "example", &ecs.ServiceArgs{
 * 			Name:    pulumi.String("example"),
 * 			Cluster: pulumi.Any(exampleAwsEcsCluster.Id),
 * 			Alarms: &ecs.ServiceAlarmsArgs{
 * 				Enable:   pulumi.Bool(true),
 * 				Rollback: pulumi.Bool(true),
 * 				AlarmNames: pulumi.StringArray{
 * 					exampleAwsCloudwatchMetricAlarm.AlarmName,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import com.pulumi.aws.ecs.inputs.ServiceAlarmsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .name("example")
 *             .cluster(exampleAwsEcsCluster.id())
 *             .alarms(ServiceAlarmsArgs.builder()
 *                 .enable(true)
 *                 .rollback(true)
 *                 .alarmNames(exampleAwsCloudwatchMetricAlarm.alarmName())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecs:Service
 *     properties:
 *       name: example
 *       cluster: ${exampleAwsEcsCluster.id}
 *       alarms:
 *         enable: true
 *         rollback: true
 *         alarmNames:
 *           - ${exampleAwsCloudwatchMetricAlarm.alarmName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### External Deployment Controller
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecs.Service("example", {
 *     name: "example",
 *     cluster: exampleAwsEcsCluster.id,
 *     deploymentController: {
 *         type: "EXTERNAL",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecs.Service("example",
 *     name="example",
 *     cluster=example_aws_ecs_cluster["id"],
 *     deployment_controller={
 *         "type": "EXTERNAL",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecs.Service("example", new()
 *     {
 *         Name = "example",
 *         Cluster = exampleAwsEcsCluster.Id,
 *         DeploymentController = new Aws.Ecs.Inputs.ServiceDeploymentControllerArgs
 *         {
 *             Type = "EXTERNAL",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewService(ctx, "example", &ecs.ServiceArgs{
 * 			Name:    pulumi.String("example"),
 * 			Cluster: pulumi.Any(exampleAwsEcsCluster.Id),
 * 			DeploymentController: &ecs.ServiceDeploymentControllerArgs{
 * 				Type: pulumi.String("EXTERNAL"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import com.pulumi.aws.ecs.inputs.ServiceDeploymentControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .name("example")
 *             .cluster(exampleAwsEcsCluster.id())
 *             .deploymentController(ServiceDeploymentControllerArgs.builder()
 *                 .type("EXTERNAL")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecs:Service
 *     properties:
 *       name: example
 *       cluster: ${exampleAwsEcsCluster.id}
 *       deploymentController:
 *         type: EXTERNAL
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Redeploy Service On Every Apply
 * The key used with `triggers` is arbitrary.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecs.Service("example", {
 *     forceNewDeployment: true,
 *     triggers: {
 *         redeployment: "plantimestamp()",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecs.Service("example",
 *     force_new_deployment=True,
 *     triggers={
 *         "redeployment": "plantimestamp()",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecs.Service("example", new()
 *     {
 *         ForceNewDeployment = true,
 *         Triggers =
 *         {
 *             { "redeployment", "plantimestamp()" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewService(ctx, "example", &ecs.ServiceArgs{
 * 			ForceNewDeployment: pulumi.Bool(true),
 * 			Triggers: pulumi.StringMap{
 * 				"redeployment": pulumi.String("plantimestamp()"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .forceNewDeployment(true)
 *             .triggers(Map.of("redeployment", "plantimestamp()"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecs:Service
 *     properties:
 *       forceNewDeployment: true
 *       triggers:
 *         redeployment: plantimestamp()
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECS services using the `name` together with ecs cluster `name`. For example:
 * ```sh
 * $ pulumi import aws:ecs/service:Service imported cluster-name/service-name
 * ```
 * @property alarms Information about the CloudWatch alarms. See below.
 * @property capacityProviderStrategies Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
 * @property cluster ARN of an ECS cluster.
 * @property deploymentCircuitBreaker Configuration block for deployment circuit breaker. See below.
 * @property deploymentController Configuration block for deployment controller configuration. See below.
 * @property deploymentMaximumPercent Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
 * @property deploymentMinimumHealthyPercent Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
 * @property desiredCount Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
 * @property enableEcsManagedTags Whether to enable Amazon ECS managed tags for the tasks within the service.
 * @property enableExecuteCommand Whether to enable Amazon ECS Exec for the tasks within the service.
 * @property forceDelete Enable to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the `REPLICA` scheduling strategy.
 * @property forceNewDeployment Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
 * @property healthCheckGracePeriodSeconds Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
 * @property iamRole ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
 * @property launchType Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`. Conflicts with `capacity_provider_strategy`.
 * @property loadBalancers Configuration block for load balancers. See below.
 * @property name Name of the service (up to 255 letters, numbers, hyphens, and underscores)
 * The following arguments are optional:
 * @property networkConfiguration Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
 * @property orderedPlacementStrategies Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
 * @property placementConstraints Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
 * @property platformVersion Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
 * @property propagateTags Whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
 * @property schedulingStrategy Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
 * @property serviceConnectConfiguration ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
 * @property serviceRegistries Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property taskDefinition Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
 * @property triggers Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `"plantimestamp()"`. When using the triggers property you also need to set the forceNewDeployment property to True.
 * @property volumeConfiguration Configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume. See below.
 * @property waitForSteadyState If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
 */
public data class ServiceArgs(
    public val alarms: Output<ServiceAlarmsArgs>? = null,
    public val capacityProviderStrategies: Output<List<ServiceCapacityProviderStrategyArgs>>? = null,
    public val cluster: Output<String>? = null,
    public val deploymentCircuitBreaker: Output<ServiceDeploymentCircuitBreakerArgs>? = null,
    public val deploymentController: Output<ServiceDeploymentControllerArgs>? = null,
    public val deploymentMaximumPercent: Output<Int>? = null,
    public val deploymentMinimumHealthyPercent: Output<Int>? = null,
    public val desiredCount: Output<Int>? = null,
    public val enableEcsManagedTags: Output<Boolean>? = null,
    public val enableExecuteCommand: Output<Boolean>? = null,
    public val forceDelete: Output<Boolean>? = null,
    public val forceNewDeployment: Output<Boolean>? = null,
    public val healthCheckGracePeriodSeconds: Output<Int>? = null,
    public val iamRole: Output<String>? = null,
    public val launchType: Output<String>? = null,
    public val loadBalancers: Output<List<ServiceLoadBalancerArgs>>? = null,
    public val name: Output<String>? = null,
    public val networkConfiguration: Output<ServiceNetworkConfigurationArgs>? = null,
    public val orderedPlacementStrategies: Output<List<ServiceOrderedPlacementStrategyArgs>>? = null,
    public val placementConstraints: Output<List<ServicePlacementConstraintArgs>>? = null,
    public val platformVersion: Output<String>? = null,
    public val propagateTags: Output<String>? = null,
    public val schedulingStrategy: Output<String>? = null,
    public val serviceConnectConfiguration: Output<ServiceServiceConnectConfigurationArgs>? = null,
    public val serviceRegistries: Output<ServiceServiceRegistriesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taskDefinition: Output<String>? = null,
    public val triggers: Output<Map<String, String>>? = null,
    public val volumeConfiguration: Output<ServiceVolumeConfigurationArgs>? = null,
    public val waitForSteadyState: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.ServiceArgs> {
    override fun toJava(): com.pulumi.aws.ecs.ServiceArgs = com.pulumi.aws.ecs.ServiceArgs.builder()
        .alarms(alarms?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .capacityProviderStrategies(
            capacityProviderStrategies?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .cluster(cluster?.applyValue({ args0 -> args0 }))
        .deploymentCircuitBreaker(
            deploymentCircuitBreaker?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .deploymentController(
            deploymentController?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .deploymentMaximumPercent(deploymentMaximumPercent?.applyValue({ args0 -> args0 }))
        .deploymentMinimumHealthyPercent(deploymentMinimumHealthyPercent?.applyValue({ args0 -> args0 }))
        .desiredCount(desiredCount?.applyValue({ args0 -> args0 }))
        .enableEcsManagedTags(enableEcsManagedTags?.applyValue({ args0 -> args0 }))
        .enableExecuteCommand(enableExecuteCommand?.applyValue({ args0 -> args0 }))
        .forceDelete(forceDelete?.applyValue({ args0 -> args0 }))
        .forceNewDeployment(forceNewDeployment?.applyValue({ args0 -> args0 }))
        .healthCheckGracePeriodSeconds(healthCheckGracePeriodSeconds?.applyValue({ args0 -> args0 }))
        .iamRole(iamRole?.applyValue({ args0 -> args0 }))
        .launchType(launchType?.applyValue({ args0 -> args0 }))
        .loadBalancers(
            loadBalancers?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .networkConfiguration(
            networkConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .orderedPlacementStrategies(
            orderedPlacementStrategies?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .placementConstraints(
            placementConstraints?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .platformVersion(platformVersion?.applyValue({ args0 -> args0 }))
        .propagateTags(propagateTags?.applyValue({ args0 -> args0 }))
        .schedulingStrategy(schedulingStrategy?.applyValue({ args0 -> args0 }))
        .serviceConnectConfiguration(
            serviceConnectConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .serviceRegistries(serviceRegistries?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .taskDefinition(taskDefinition?.applyValue({ args0 -> args0 }))
        .triggers(
            triggers?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .volumeConfiguration(
            volumeConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .waitForSteadyState(waitForSteadyState?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var alarms: Output<ServiceAlarmsArgs>? = null

    private var capacityProviderStrategies: Output<List<ServiceCapacityProviderStrategyArgs>>? = null

    private var cluster: Output<String>? = null

    private var deploymentCircuitBreaker: Output<ServiceDeploymentCircuitBreakerArgs>? = null

    private var deploymentController: Output<ServiceDeploymentControllerArgs>? = null

    private var deploymentMaximumPercent: Output<Int>? = null

    private var deploymentMinimumHealthyPercent: Output<Int>? = null

    private var desiredCount: Output<Int>? = null

    private var enableEcsManagedTags: Output<Boolean>? = null

    private var enableExecuteCommand: Output<Boolean>? = null

    private var forceDelete: Output<Boolean>? = null

    private var forceNewDeployment: Output<Boolean>? = null

    private var healthCheckGracePeriodSeconds: Output<Int>? = null

    private var iamRole: Output<String>? = null

    private var launchType: Output<String>? = null

    private var loadBalancers: Output<List<ServiceLoadBalancerArgs>>? = null

    private var name: Output<String>? = null

    private var networkConfiguration: Output<ServiceNetworkConfigurationArgs>? = null

    private var orderedPlacementStrategies: Output<List<ServiceOrderedPlacementStrategyArgs>>? = null

    private var placementConstraints: Output<List<ServicePlacementConstraintArgs>>? = null

    private var platformVersion: Output<String>? = null

    private var propagateTags: Output<String>? = null

    private var schedulingStrategy: Output<String>? = null

    private var serviceConnectConfiguration: Output<ServiceServiceConnectConfigurationArgs>? = null

    private var serviceRegistries: Output<ServiceServiceRegistriesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taskDefinition: Output<String>? = null

    private var triggers: Output<Map<String, String>>? = null

    private var volumeConfiguration: Output<ServiceVolumeConfigurationArgs>? = null

    private var waitForSteadyState: Output<Boolean>? = null

    /**
     * @param value Information about the CloudWatch alarms. See below.
     */
    @JvmName("rjpbtdcdlopoymbf")
    public suspend fun alarms(`value`: Output<ServiceAlarmsArgs>) {
        this.alarms = value
    }

    /**
     * @param value Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
     */
    @JvmName("mgcifhsvvxyiqpec")
    public suspend fun capacityProviderStrategies(`value`: Output<List<ServiceCapacityProviderStrategyArgs>>) {
        this.capacityProviderStrategies = value
    }

    @JvmName("nmitbakirxjmysom")
    public suspend fun capacityProviderStrategies(vararg values: Output<ServiceCapacityProviderStrategyArgs>) {
        this.capacityProviderStrategies = Output.all(values.asList())
    }

    /**
     * @param values Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
     */
    @JvmName("qdxxtnvermscxpmx")
    public suspend fun capacityProviderStrategies(values: List<Output<ServiceCapacityProviderStrategyArgs>>) {
        this.capacityProviderStrategies = Output.all(values)
    }

    /**
     * @param value ARN of an ECS cluster.
     */
    @JvmName("fnxcvobsqvpybjue")
    public suspend fun cluster(`value`: Output<String>) {
        this.cluster = value
    }

    /**
     * @param value Configuration block for deployment circuit breaker. See below.
     */
    @JvmName("fypilsxinoewxgfr")
    public suspend fun deploymentCircuitBreaker(`value`: Output<ServiceDeploymentCircuitBreakerArgs>) {
        this.deploymentCircuitBreaker = value
    }

    /**
     * @param value Configuration block for deployment controller configuration. See below.
     */
    @JvmName("lplnvudccokajgqf")
    public suspend fun deploymentController(`value`: Output<ServiceDeploymentControllerArgs>) {
        this.deploymentController = value
    }

    /**
     * @param value Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
     */
    @JvmName("csnxmfpvielupiuf")
    public suspend fun deploymentMaximumPercent(`value`: Output<Int>) {
        this.deploymentMaximumPercent = value
    }

    /**
     * @param value Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
     */
    @JvmName("esjpgabioeprplqo")
    public suspend fun deploymentMinimumHealthyPercent(`value`: Output<Int>) {
        this.deploymentMinimumHealthyPercent = value
    }

    /**
     * @param value Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
     */
    @JvmName("uoexargftirpmdqw")
    public suspend fun desiredCount(`value`: Output<Int>) {
        this.desiredCount = value
    }

    /**
     * @param value Whether to enable Amazon ECS managed tags for the tasks within the service.
     */
    @JvmName("mpfakxdmdtsvetkv")
    public suspend fun enableEcsManagedTags(`value`: Output<Boolean>) {
        this.enableEcsManagedTags = value
    }

    /**
     * @param value Whether to enable Amazon ECS Exec for the tasks within the service.
     */
    @JvmName("nohsbmegrtgwpnmd")
    public suspend fun enableExecuteCommand(`value`: Output<Boolean>) {
        this.enableExecuteCommand = value
    }

    /**
     * @param value Enable to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the `REPLICA` scheduling strategy.
     */
    @JvmName("bxvwpnbumnbirtjk")
    public suspend fun forceDelete(`value`: Output<Boolean>) {
        this.forceDelete = value
    }

    /**
     * @param value Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
     */
    @JvmName("spbtawdjspcyxdhw")
    public suspend fun forceNewDeployment(`value`: Output<Boolean>) {
        this.forceNewDeployment = value
    }

    /**
     * @param value Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
     */
    @JvmName("gfdmridfoifpymcb")
    public suspend fun healthCheckGracePeriodSeconds(`value`: Output<Int>) {
        this.healthCheckGracePeriodSeconds = value
    }

    /**
     * @param value ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
     */
    @JvmName("snahwgtdjouvkwti")
    public suspend fun iamRole(`value`: Output<String>) {
        this.iamRole = value
    }

    /**
     * @param value Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`. Conflicts with `capacity_provider_strategy`.
     */
    @JvmName("wysiljgxbmcpspjp")
    public suspend fun launchType(`value`: Output<String>) {
        this.launchType = value
    }

    /**
     * @param value Configuration block for load balancers. See below.
     */
    @JvmName("gjuldvwiikjuboia")
    public suspend fun loadBalancers(`value`: Output<List<ServiceLoadBalancerArgs>>) {
        this.loadBalancers = value
    }

    @JvmName("aeyytnihgverrvpj")
    public suspend fun loadBalancers(vararg values: Output<ServiceLoadBalancerArgs>) {
        this.loadBalancers = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for load balancers. See below.
     */
    @JvmName("schfsjmffnealcti")
    public suspend fun loadBalancers(values: List<Output<ServiceLoadBalancerArgs>>) {
        this.loadBalancers = Output.all(values)
    }

    /**
     * @param value Name of the service (up to 255 letters, numbers, hyphens, and underscores)
     * The following arguments are optional:
     */
    @JvmName("quuuiflpmnqeiajm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
     */
    @JvmName("hljwvskoqciotpwb")
    public suspend fun networkConfiguration(`value`: Output<ServiceNetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("hjtqfskdirltfova")
    public suspend fun orderedPlacementStrategies(`value`: Output<List<ServiceOrderedPlacementStrategyArgs>>) {
        this.orderedPlacementStrategies = value
    }

    @JvmName("tyqamvvrhkitfttn")
    public suspend fun orderedPlacementStrategies(vararg values: Output<ServiceOrderedPlacementStrategyArgs>) {
        this.orderedPlacementStrategies = Output.all(values.asList())
    }

    /**
     * @param values Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("edhiatlsgnhwkprr")
    public suspend fun orderedPlacementStrategies(values: List<Output<ServiceOrderedPlacementStrategyArgs>>) {
        this.orderedPlacementStrategies = Output.all(values)
    }

    /**
     * @param value Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("dvslcepdvcwjuojc")
    public suspend fun placementConstraints(`value`: Output<List<ServicePlacementConstraintArgs>>) {
        this.placementConstraints = value
    }

    @JvmName("vdbnpgqanrenvshk")
    public suspend fun placementConstraints(vararg values: Output<ServicePlacementConstraintArgs>) {
        this.placementConstraints = Output.all(values.asList())
    }

    /**
     * @param values Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("lhidmmsryschlcht")
    public suspend fun placementConstraints(values: List<Output<ServicePlacementConstraintArgs>>) {
        this.placementConstraints = Output.all(values)
    }

    /**
     * @param value Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
     */
    @JvmName("huxqahhtebbavuut")
    public suspend fun platformVersion(`value`: Output<String>) {
        this.platformVersion = value
    }

    /**
     * @param value Whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
     */
    @JvmName("dbqjyrpnqkojfwhw")
    public suspend fun propagateTags(`value`: Output<String>) {
        this.propagateTags = value
    }

    /**
     * @param value Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
     */
    @JvmName("aaajrgqchkffacxe")
    public suspend fun schedulingStrategy(`value`: Output<String>) {
        this.schedulingStrategy = value
    }

    /**
     * @param value ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
     */
    @JvmName("pxiwxjsnlcrsbsra")
    public suspend fun serviceConnectConfiguration(`value`: Output<ServiceServiceConnectConfigurationArgs>) {
        this.serviceConnectConfiguration = value
    }

    /**
     * @param value Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
     */
    @JvmName("uqetfppyvamfrnvu")
    public suspend fun serviceRegistries(`value`: Output<ServiceServiceRegistriesArgs>) {
        this.serviceRegistries = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bewtynhavgccoqjr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
     */
    @JvmName("npoimnfvsjejcnat")
    public suspend fun taskDefinition(`value`: Output<String>) {
        this.taskDefinition = value
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `"plantimestamp()"`. When using the triggers property you also need to set the forceNewDeployment property to True.
     */
    @JvmName("hctowjdumgeomhoe")
    public suspend fun triggers(`value`: Output<Map<String, String>>) {
        this.triggers = value
    }

    /**
     * @param value Configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume. See below.
     */
    @JvmName("wfncetptoghuolab")
    public suspend fun volumeConfiguration(`value`: Output<ServiceVolumeConfigurationArgs>) {
        this.volumeConfiguration = value
    }

    /**
     * @param value If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
     */
    @JvmName("jorjqpblduipwxpt")
    public suspend fun waitForSteadyState(`value`: Output<Boolean>) {
        this.waitForSteadyState = value
    }

    /**
     * @param value Information about the CloudWatch alarms. See below.
     */
    @JvmName("bqfmeewxqgdtlkev")
    public suspend fun alarms(`value`: ServiceAlarmsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param argument Information about the CloudWatch alarms. See below.
     */
    @JvmName("njfdscbyllidfylc")
    public suspend fun alarms(argument: suspend ServiceAlarmsArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceAlarmsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.alarms = mapped
    }

    /**
     * @param value Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
     */
    @JvmName("tumisstdtkodnmdt")
    public suspend fun capacityProviderStrategies(`value`: List<ServiceCapacityProviderStrategyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
     */
    @JvmName("bnsdbfsuqmrwdepg")
    public suspend fun capacityProviderStrategies(argument: List<suspend ServiceCapacityProviderStrategyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceCapacityProviderStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
     */
    @JvmName("bgewvcsfmurejlvr")
    public suspend fun capacityProviderStrategies(vararg argument: suspend ServiceCapacityProviderStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceCapacityProviderStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
     */
    @JvmName("fuaiooxxqaerfsbd")
    public suspend fun capacityProviderStrategies(argument: suspend ServiceCapacityProviderStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceCapacityProviderStrategyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param values Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
     */
    @JvmName("ilfygieaawhwxtgl")
    public suspend fun capacityProviderStrategies(vararg values: ServiceCapacityProviderStrategyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param value ARN of an ECS cluster.
     */
    @JvmName("mrxwtxwvcljxvmgn")
    public suspend fun cluster(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cluster = mapped
    }

    /**
     * @param value Configuration block for deployment circuit breaker. See below.
     */
    @JvmName("drboldnusaskaisq")
    public suspend fun deploymentCircuitBreaker(`value`: ServiceDeploymentCircuitBreakerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentCircuitBreaker = mapped
    }

    /**
     * @param argument Configuration block for deployment circuit breaker. See below.
     */
    @JvmName("pbkhnimewxgrguto")
    public suspend fun deploymentCircuitBreaker(argument: suspend ServiceDeploymentCircuitBreakerArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceDeploymentCircuitBreakerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentCircuitBreaker = mapped
    }

    /**
     * @param value Configuration block for deployment controller configuration. See below.
     */
    @JvmName("ujqifvghgwshwllu")
    public suspend fun deploymentController(`value`: ServiceDeploymentControllerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentController = mapped
    }

    /**
     * @param argument Configuration block for deployment controller configuration. See below.
     */
    @JvmName("xwhfolginhmhpxsl")
    public suspend fun deploymentController(argument: suspend ServiceDeploymentControllerArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceDeploymentControllerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentController = mapped
    }

    /**
     * @param value Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
     */
    @JvmName("ilgtafyvnmfhlddg")
    public suspend fun deploymentMaximumPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentMaximumPercent = mapped
    }

    /**
     * @param value Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
     */
    @JvmName("xtfuvbgorupiptki")
    public suspend fun deploymentMinimumHealthyPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentMinimumHealthyPercent = mapped
    }

    /**
     * @param value Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
     */
    @JvmName("unrhqyuyvutvwlxi")
    public suspend fun desiredCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredCount = mapped
    }

    /**
     * @param value Whether to enable Amazon ECS managed tags for the tasks within the service.
     */
    @JvmName("rhoebmawujhfsntu")
    public suspend fun enableEcsManagedTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableEcsManagedTags = mapped
    }

    /**
     * @param value Whether to enable Amazon ECS Exec for the tasks within the service.
     */
    @JvmName("jktnxckjwxaqxklv")
    public suspend fun enableExecuteCommand(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableExecuteCommand = mapped
    }

    /**
     * @param value Enable to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the `REPLICA` scheduling strategy.
     */
    @JvmName("nepnryegnpyneytx")
    public suspend fun forceDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDelete = mapped
    }

    /**
     * @param value Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
     */
    @JvmName("nyppyqeybvjxveiv")
    public suspend fun forceNewDeployment(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceNewDeployment = mapped
    }

    /**
     * @param value Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
     */
    @JvmName("vecrfjtswbkccdaw")
    public suspend fun healthCheckGracePeriodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckGracePeriodSeconds = mapped
    }

    /**
     * @param value ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
     */
    @JvmName("ofbsjrnewnpngmtd")
    public suspend fun iamRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRole = mapped
    }

    /**
     * @param value Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`. Conflicts with `capacity_provider_strategy`.
     */
    @JvmName("qobqpglfcrcevynl")
    public suspend fun launchType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchType = mapped
    }

    /**
     * @param value Configuration block for load balancers. See below.
     */
    @JvmName("gvuqjfjhmsgbvpqa")
    public suspend fun loadBalancers(`value`: List<ServiceLoadBalancerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancers = mapped
    }

    /**
     * @param argument Configuration block for load balancers. See below.
     */
    @JvmName("skqrklenimqtjbas")
    public suspend fun loadBalancers(argument: List<suspend ServiceLoadBalancerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceLoadBalancerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancers = mapped
    }

    /**
     * @param argument Configuration block for load balancers. See below.
     */
    @JvmName("cwuaxndtbjlfmtnr")
    public suspend fun loadBalancers(vararg argument: suspend ServiceLoadBalancerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceLoadBalancerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancers = mapped
    }

    /**
     * @param argument Configuration block for load balancers. See below.
     */
    @JvmName("sxgfdhyqyqahcemv")
    public suspend fun loadBalancers(argument: suspend ServiceLoadBalancerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceLoadBalancerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loadBalancers = mapped
    }

    /**
     * @param values Configuration block for load balancers. See below.
     */
    @JvmName("joygfopyvhipcrei")
    public suspend fun loadBalancers(vararg values: ServiceLoadBalancerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancers = mapped
    }

    /**
     * @param value Name of the service (up to 255 letters, numbers, hyphens, and underscores)
     * The following arguments are optional:
     */
    @JvmName("vbvcfwiwsghxruxt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
     */
    @JvmName("cxtuwgwmsnytvmkj")
    public suspend fun networkConfiguration(`value`: ServiceNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
     */
    @JvmName("kdgpqhxcykrjnkdc")
    public suspend fun networkConfiguration(argument: suspend ServiceNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceNetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("yneptndknriuegru")
    public suspend fun orderedPlacementStrategies(`value`: List<ServiceOrderedPlacementStrategyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param argument Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("xilairdernwbyhnh")
    public suspend fun orderedPlacementStrategies(argument: List<suspend ServiceOrderedPlacementStrategyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceOrderedPlacementStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param argument Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("rbruffcswtwdqkwi")
    public suspend fun orderedPlacementStrategies(vararg argument: suspend ServiceOrderedPlacementStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceOrderedPlacementStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param argument Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("tbgdtpdklfmbyfoj")
    public suspend fun orderedPlacementStrategies(argument: suspend ServiceOrderedPlacementStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceOrderedPlacementStrategyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param values Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
     */
    @JvmName("brcflkyajcwftuiw")
    public suspend fun orderedPlacementStrategies(vararg values: ServiceOrderedPlacementStrategyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param value Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("xagkqqgpipeqigmv")
    public suspend fun placementConstraints(`value`: List<ServicePlacementConstraintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param argument Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("lyydxjgdtjhnjbhy")
    public suspend fun placementConstraints(argument: List<suspend ServicePlacementConstraintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServicePlacementConstraintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param argument Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("houjiyqvwrdmahpc")
    public suspend fun placementConstraints(vararg argument: suspend ServicePlacementConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServicePlacementConstraintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param argument Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("lpiqoysaqeuqdrca")
    public suspend fun placementConstraints(argument: suspend ServicePlacementConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServicePlacementConstraintArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param values Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
     */
    @JvmName("ygxjogypagwgvoic")
    public suspend fun placementConstraints(vararg values: ServicePlacementConstraintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param value Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
     */
    @JvmName("ulfanxvicfrvkyoy")
    public suspend fun platformVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformVersion = mapped
    }

    /**
     * @param value Whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
     */
    @JvmName("gxvkmjmntjevigdt")
    public suspend fun propagateTags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propagateTags = mapped
    }

    /**
     * @param value Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
     */
    @JvmName("adadukrpfkuglbfi")
    public suspend fun schedulingStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedulingStrategy = mapped
    }

    /**
     * @param value ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
     */
    @JvmName("efmvvvwewkfyigce")
    public suspend fun serviceConnectConfiguration(`value`: ServiceServiceConnectConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceConnectConfiguration = mapped
    }

    /**
     * @param argument ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
     */
    @JvmName("kgtvsbjlvphefgxs")
    public suspend fun serviceConnectConfiguration(argument: suspend ServiceServiceConnectConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceServiceConnectConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serviceConnectConfiguration = mapped
    }

    /**
     * @param value Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
     */
    @JvmName("ebbdtvbrlxhlgnhm")
    public suspend fun serviceRegistries(`value`: ServiceServiceRegistriesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRegistries = mapped
    }

    /**
     * @param argument Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
     */
    @JvmName("hmnfvfnomfbinwgb")
    public suspend fun serviceRegistries(argument: suspend ServiceServiceRegistriesArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceServiceRegistriesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceRegistries = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pbvfhaluepxnmpmm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hwusgsyqohdftdrs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
     */
    @JvmName("fiisfxigucjgnqla")
    public suspend fun taskDefinition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskDefinition = mapped
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `"plantimestamp()"`. When using the triggers property you also need to set the forceNewDeployment property to True.
     */
    @JvmName("pxjukeqigrgqgnjl")
    public suspend fun triggers(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param values Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `"plantimestamp()"`. When using the triggers property you also need to set the forceNewDeployment property to True.
     */
    @JvmName("ouujomtnahhmjmpd")
    public fun triggers(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param value Configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume. See below.
     */
    @JvmName("lqxruqwjlnqjjbjd")
    public suspend fun volumeConfiguration(`value`: ServiceVolumeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeConfiguration = mapped
    }

    /**
     * @param argument Configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume. See below.
     */
    @JvmName("txllphcipuwxhhvk")
    public suspend fun volumeConfiguration(argument: suspend ServiceVolumeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceVolumeConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.volumeConfiguration = mapped
    }

    /**
     * @param value If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
     */
    @JvmName("evvjcbeffercnefj")
    public suspend fun waitForSteadyState(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForSteadyState = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        alarms = alarms,
        capacityProviderStrategies = capacityProviderStrategies,
        cluster = cluster,
        deploymentCircuitBreaker = deploymentCircuitBreaker,
        deploymentController = deploymentController,
        deploymentMaximumPercent = deploymentMaximumPercent,
        deploymentMinimumHealthyPercent = deploymentMinimumHealthyPercent,
        desiredCount = desiredCount,
        enableEcsManagedTags = enableEcsManagedTags,
        enableExecuteCommand = enableExecuteCommand,
        forceDelete = forceDelete,
        forceNewDeployment = forceNewDeployment,
        healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds,
        iamRole = iamRole,
        launchType = launchType,
        loadBalancers = loadBalancers,
        name = name,
        networkConfiguration = networkConfiguration,
        orderedPlacementStrategies = orderedPlacementStrategies,
        placementConstraints = placementConstraints,
        platformVersion = platformVersion,
        propagateTags = propagateTags,
        schedulingStrategy = schedulingStrategy,
        serviceConnectConfiguration = serviceConnectConfiguration,
        serviceRegistries = serviceRegistries,
        tags = tags,
        taskDefinition = taskDefinition,
        triggers = triggers,
        volumeConfiguration = volumeConfiguration,
        waitForSteadyState = waitForSteadyState,
    )
}
