@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionEphemeralStorage
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionInferenceAccelerator
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionPlacementConstraint
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionProxyConfiguration
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionRuntimePlatform
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionVolume
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionEphemeralStorage.Companion.toKotlin as taskDefinitionEphemeralStorageToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionInferenceAccelerator.Companion.toKotlin as taskDefinitionInferenceAcceleratorToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionPlacementConstraint.Companion.toKotlin as taskDefinitionPlacementConstraintToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionProxyConfiguration.Companion.toKotlin as taskDefinitionProxyConfigurationToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionRuntimePlatform.Companion.toKotlin as taskDefinitionRuntimePlatformToKotlin
import com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionVolume.Companion.toKotlin as taskDefinitionVolumeToKotlin

/**
 * Builder for [TaskDefinition].
 */
@PulumiTagMarker
public class TaskDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TaskDefinitionArgs = TaskDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TaskDefinitionArgsBuilder.() -> Unit) {
        val builder = TaskDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TaskDefinition {
        val builtJavaResource = com.pulumi.aws.ecs.TaskDefinition(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TaskDefinition(builtJavaResource)
    }
}

/**
 * Manages a revision of an ECS task definition to be used in `aws.ecs.Service`.
 * ## Example Usage
 * ### Basic Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const service = new aws.ecs.TaskDefinition("service", {
 *     family: "service",
 *     containerDefinitions: JSON.stringify([
 *         {
 *             name: "first",
 *             image: "service-first",
 *             cpu: 10,
 *             memory: 512,
 *             essential: true,
 *             portMappings: [{
 *                 containerPort: 80,
 *                 hostPort: 80,
 *             }],
 *         },
 *         {
 *             name: "second",
 *             image: "service-second",
 *             cpu: 10,
 *             memory: 256,
 *             essential: true,
 *             portMappings: [{
 *                 containerPort: 443,
 *                 hostPort: 443,
 *             }],
 *         },
 *     ]),
 *     volumes: [{
 *         name: "service-storage",
 *         hostPath: "/ecs/service-storage",
 *     }],
 *     placementConstraints: [{
 *         type: "memberOf",
 *         expression: "attribute:ecs.availability-zone in [us-west-2a, us-west-2b]",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * service = aws.ecs.TaskDefinition("service",
 *     family="service",
 *     container_definitions=json.dumps([
 *         {
 *             "name": "first",
 *             "image": "service-first",
 *             "cpu": 10,
 *             "memory": 512,
 *             "essential": True,
 *             "portMappings": [{
 *                 "containerPort": 80,
 *                 "hostPort": 80,
 *             }],
 *         },
 *         {
 *             "name": "second",
 *             "image": "service-second",
 *             "cpu": 10,
 *             "memory": 256,
 *             "essential": True,
 *             "portMappings": [{
 *                 "containerPort": 443,
 *                 "hostPort": 443,
 *             }],
 *         },
 *     ]),
 *     volumes=[{
 *         "name": "service-storage",
 *         "host_path": "/ecs/service-storage",
 *     }],
 *     placement_constraints=[{
 *         "type": "memberOf",
 *         "expression": "attribute:ecs.availability-zone in [us-west-2a, us-west-2b]",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new Aws.Ecs.TaskDefinition("service", new()
 *     {
 *         Family = "service",
 *         ContainerDefinitions = JsonSerializer.Serialize(new[]
 *         {
 *             new Dictionary<string, object?>
 *             {
 *                 ["name"] = "first",
 *                 ["image"] = "service-first",
 *                 ["cpu"] = 10,
 *                 ["memory"] = 512,
 *                 ["essential"] = true,
 *                 ["portMappings"] = new[]
 *                 {
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["containerPort"] = 80,
 *                         ["hostPort"] = 80,
 *                     },
 *                 },
 *             },
 *             new Dictionary<string, object?>
 *             {
 *                 ["name"] = "second",
 *                 ["image"] = "service-second",
 *                 ["cpu"] = 10,
 *                 ["memory"] = 256,
 *                 ["essential"] = true,
 *                 ["portMappings"] = new[]
 *                 {
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["containerPort"] = 443,
 *                         ["hostPort"] = 443,
 *                     },
 *                 },
 *             },
 *         }),
 *         Volumes = new[]
 *         {
 *             new Aws.Ecs.Inputs.TaskDefinitionVolumeArgs
 *             {
 *                 Name = "service-storage",
 *                 HostPath = "/ecs/service-storage",
 *             },
 *         },
 *         PlacementConstraints = new[]
 *         {
 *             new Aws.Ecs.Inputs.TaskDefinitionPlacementConstraintArgs
 *             {
 *                 Type = "memberOf",
 *                 Expression = "attribute:ecs.availability-zone in [us-west-2a, us-west-2b]",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal([]interface{}{
 * 			map[string]interface{}{
 * 				"name":      "first",
 * 				"image":     "service-first",
 * 				"cpu":       10,
 * 				"memory":    512,
 * 				"essential": true,
 * 				"portMappings": []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"containerPort": 80,
 * 						"hostPort":      80,
 * 					},
 * 				},
 * 			},
 * 			map[string]interface{}{
 * 				"name":      "second",
 * 				"image":     "service-second",
 * 				"cpu":       10,
 * 				"memory":    256,
 * 				"essential": true,
 * 				"portMappings": []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"containerPort": 443,
 * 						"hostPort":      443,
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = ecs.NewTaskDefinition(ctx, "service", &ecs.TaskDefinitionArgs{
 * 			Family:               pulumi.String("service"),
 * 			ContainerDefinitions: pulumi.String(json0),
 * 			Volumes: ecs.TaskDefinitionVolumeArray{
 * 				&ecs.TaskDefinitionVolumeArgs{
 * 					Name:     pulumi.String("service-storage"),
 * 					HostPath: pulumi.String("/ecs/service-storage"),
 * 				},
 * 			},
 * 			PlacementConstraints: ecs.TaskDefinitionPlacementConstraintArray{
 * 				&ecs.TaskDefinitionPlacementConstraintArgs{
 * 					Type:       pulumi.String("memberOf"),
 * 					Expression: pulumi.String("attribute:ecs.availability-zone in [us-west-2a, us-west-2b]"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionPlacementConstraintArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(serializeJson(
 *                 jsonArray(
 *                     jsonObject(
 *                         jsonProperty("name", "first"),
 *                         jsonProperty("image", "service-first"),
 *                         jsonProperty("cpu", 10),
 *                         jsonProperty("memory", 512),
 *                         jsonProperty("essential", true),
 *                         jsonProperty("portMappings", jsonArray(jsonObject(
 *                             jsonProperty("containerPort", 80),
 *                             jsonProperty("hostPort", 80)
 *                         )))
 *                     ),
 *                     jsonObject(
 *                         jsonProperty("name", "second"),
 *                         jsonProperty("image", "service-second"),
 *                         jsonProperty("cpu", 10),
 *                         jsonProperty("memory", 256),
 *                         jsonProperty("essential", true),
 *                         jsonProperty("portMappings", jsonArray(jsonObject(
 *                             jsonProperty("containerPort", 443),
 *                             jsonProperty("hostPort", 443)
 *                         )))
 *                     )
 *                 )))
 *             .volumes(TaskDefinitionVolumeArgs.builder()
 *                 .name("service-storage")
 *                 .hostPath("/ecs/service-storage")
 *                 .build())
 *             .placementConstraints(TaskDefinitionPlacementConstraintArgs.builder()
 *                 .type("memberOf")
 *                 .expression("attribute:ecs.availability-zone in [us-west-2a, us-west-2b]")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   service:
 *     type: aws:ecs:TaskDefinition
 *     properties:
 *       family: service
 *       containerDefinitions:
 *         fn::toJSON:
 *           - name: first
 *             image: service-first
 *             cpu: 10
 *             memory: 512
 *             essential: true
 *             portMappings:
 *               - containerPort: 80
 *                 hostPort: 80
 *           - name: second
 *             image: service-second
 *             cpu: 10
 *             memory: 256
 *             essential: true
 *             portMappings:
 *               - containerPort: 443
 *                 hostPort: 443
 *       volumes:
 *         - name: service-storage
 *           hostPath: /ecs/service-storage
 *       placementConstraints:
 *         - type: memberOf
 *           expression: attribute:ecs.availability-zone in [us-west-2a, us-west-2b]
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With AppMesh Proxy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const service = new aws.ecs.TaskDefinition("service", {
 *     family: "service",
 *     containerDefinitions: std.file({
 *         input: "task-definitions/service.json",
 *     }).then(invoke => invoke.result),
 *     proxyConfiguration: {
 *         type: "APPMESH",
 *         containerName: "applicationContainerName",
 *         properties: {
 *             AppPorts: "8080",
 *             EgressIgnoredIPs: "169.254.170.2,169.254.169.254",
 *             IgnoredUID: "1337",
 *             ProxyEgressPort: "15001",
 *             ProxyIngressPort: "15000",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * service = aws.ecs.TaskDefinition("service",
 *     family="service",
 *     container_definitions=std.file(input="task-definitions/service.json").result,
 *     proxy_configuration={
 *         "type": "APPMESH",
 *         "container_name": "applicationContainerName",
 *         "properties": {
 *             "app_ports": "8080",
 *             "egress_ignored_ips": "169.254.170.2,169.254.169.254",
 *             "ignored_uid": "1337",
 *             "proxy_egress_port": "15001",
 *             "proxy_ingress_port": "15000",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new Aws.Ecs.TaskDefinition("service", new()
 *     {
 *         Family = "service",
 *         ContainerDefinitions = Std.File.Invoke(new()
 *         {
 *             Input = "task-definitions/service.json",
 *         }).Apply(invoke => invoke.Result),
 *         ProxyConfiguration = new Aws.Ecs.Inputs.TaskDefinitionProxyConfigurationArgs
 *         {
 *             Type = "APPMESH",
 *             ContainerName = "applicationContainerName",
 *             Properties =
 *             {
 *                 { "AppPorts", "8080" },
 *                 { "EgressIgnoredIPs", "169.254.170.2,169.254.169.254" },
 *                 { "IgnoredUID", "1337" },
 *                 { "ProxyEgressPort", "15001" },
 *                 { "ProxyIngressPort", "15000" },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "task-definitions/service.json",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewTaskDefinition(ctx, "service", &ecs.TaskDefinitionArgs{
 * 			Family:               pulumi.String("service"),
 * 			ContainerDefinitions: pulumi.String(invokeFile.Result),
 * 			ProxyConfiguration: &ecs.TaskDefinitionProxyConfigurationArgs{
 * 				Type:          pulumi.String("APPMESH"),
 * 				ContainerName: pulumi.String("applicationContainerName"),
 * 				Properties: pulumi.StringMap{
 * 					"AppPorts":         pulumi.String("8080"),
 * 					"EgressIgnoredIPs": pulumi.String("169.254.170.2,169.254.169.254"),
 * 					"IgnoredUID":       pulumi.String("1337"),
 * 					"ProxyEgressPort":  pulumi.String("15001"),
 * 					"ProxyIngressPort": pulumi.String("15000"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionProxyConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(StdFunctions.file(FileArgs.builder()
 *                 .input("task-definitions/service.json")
 *                 .build()).result())
 *             .proxyConfiguration(TaskDefinitionProxyConfigurationArgs.builder()
 *                 .type("APPMESH")
 *                 .containerName("applicationContainerName")
 *                 .properties(Map.ofEntries(
 *                     Map.entry("AppPorts", "8080"),
 *                     Map.entry("EgressIgnoredIPs", "169.254.170.2,169.254.169.254"),
 *                     Map.entry("IgnoredUID", "1337"),
 *                     Map.entry("ProxyEgressPort", 15001),
 *                     Map.entry("ProxyIngressPort", 15000)
 *                 ))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   service:
 *     type: aws:ecs:TaskDefinition
 *     properties:
 *       family: service
 *       containerDefinitions:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: task-definitions/service.json
 *           Return: result
 *       proxyConfiguration:
 *         type: APPMESH
 *         containerName: applicationContainerName
 *         properties:
 *           AppPorts: '8080'
 *           EgressIgnoredIPs: 169.254.170.2,169.254.169.254
 *           IgnoredUID: '1337'
 *           ProxyEgressPort: 15001
 *           ProxyIngressPort: 15000
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example Using `docker_volume_configuration`
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const service = new aws.ecs.TaskDefinition("service", {
 *     family: "service",
 *     containerDefinitions: std.file({
 *         input: "task-definitions/service.json",
 *     }).then(invoke => invoke.result),
 *     volumes: [{
 *         name: "service-storage",
 *         dockerVolumeConfiguration: {
 *             scope: "shared",
 *             autoprovision: true,
 *             driver: "local",
 *             driverOpts: {
 *                 type: "nfs",
 *                 device: `${fs.dnsName}:/`,
 *                 o: `addr=${fs.dnsName},rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noresvport`,
 *             },
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * service = aws.ecs.TaskDefinition("service",
 *     family="service",
 *     container_definitions=std.file(input="task-definitions/service.json").result,
 *     volumes=[{
 *         "name": "service-storage",
 *         "docker_volume_configuration": {
 *             "scope": "shared",
 *             "autoprovision": True,
 *             "driver": "local",
 *             "driver_opts": {
 *                 "type": "nfs",
 *                 "device": f"{fs['dnsName']}:/",
 *                 "o": f"addr={fs['dnsName']},rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noresvport",
 *             },
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new Aws.Ecs.TaskDefinition("service", new()
 *     {
 *         Family = "service",
 *         ContainerDefinitions = Std.File.Invoke(new()
 *         {
 *             Input = "task-definitions/service.json",
 *         }).Apply(invoke => invoke.Result),
 *         Volumes = new[]
 *         {
 *             new Aws.Ecs.Inputs.TaskDefinitionVolumeArgs
 *             {
 *                 Name = "service-storage",
 *                 DockerVolumeConfiguration = new Aws.Ecs.Inputs.TaskDefinitionVolumeDockerVolumeConfigurationArgs
 *                 {
 *                     Scope = "shared",
 *                     Autoprovision = true,
 *                     Driver = "local",
 *                     DriverOpts =
 *                     {
 *                         { "type", "nfs" },
 *                         { "device", $"{fs.DnsName}:/" },
 *                         { "o", $"addr={fs.DnsName},rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noresvport" },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "task-definitions/service.json",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewTaskDefinition(ctx, "service", &ecs.TaskDefinitionArgs{
 * 			Family:               pulumi.String("service"),
 * 			ContainerDefinitions: pulumi.String(invokeFile.Result),
 * 			Volumes: ecs.TaskDefinitionVolumeArray{
 * 				&ecs.TaskDefinitionVolumeArgs{
 * 					Name: pulumi.String("service-storage"),
 * 					DockerVolumeConfiguration: &ecs.TaskDefinitionVolumeDockerVolumeConfigurationArgs{
 * 						Scope:         pulumi.String("shared"),
 * 						Autoprovision: pulumi.Bool(true),
 * 						Driver:        pulumi.String("local"),
 * 						DriverOpts: pulumi.StringMap{
 * 							"type":   pulumi.String("nfs"),
 * 							"device": pulumi.Sprintf("%v:/", fs.DnsName),
 * 							"o":      pulumi.Sprintf("addr=%v,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noresvport", fs.DnsName),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeDockerVolumeConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(StdFunctions.file(FileArgs.builder()
 *                 .input("task-definitions/service.json")
 *                 .build()).result())
 *             .volumes(TaskDefinitionVolumeArgs.builder()
 *                 .name("service-storage")
 *                 .dockerVolumeConfiguration(TaskDefinitionVolumeDockerVolumeConfigurationArgs.builder()
 *                     .scope("shared")
 *                     .autoprovision(true)
 *                     .driver("local")
 *                     .driverOpts(Map.ofEntries(
 *                         Map.entry("type", "nfs"),
 *                         Map.entry("device", String.format("%s:/", fs.dnsName())),
 *                         Map.entry("o", String.format("addr=%s,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noresvport", fs.dnsName()))
 *                     ))
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   service:
 *     type: aws:ecs:TaskDefinition
 *     properties:
 *       family: service
 *       containerDefinitions:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: task-definitions/service.json
 *           Return: result
 *       volumes:
 *         - name: service-storage
 *           dockerVolumeConfiguration:
 *             scope: shared
 *             autoprovision: true
 *             driver: local
 *             driverOpts:
 *               type: nfs
 *               device: ${fs.dnsName}:/
 *               o: addr=${fs.dnsName},rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noresvport
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example Using `efs_volume_configuration`
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const service = new aws.ecs.TaskDefinition("service", {
 *     family: "service",
 *     containerDefinitions: std.file({
 *         input: "task-definitions/service.json",
 *     }).then(invoke => invoke.result),
 *     volumes: [{
 *         name: "service-storage",
 *         efsVolumeConfiguration: {
 *             fileSystemId: fs.id,
 *             rootDirectory: "/opt/data",
 *             transitEncryption: "ENABLED",
 *             transitEncryptionPort: 2999,
 *             authorizationConfig: {
 *                 accessPointId: test.id,
 *                 iam: "ENABLED",
 *             },
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * service = aws.ecs.TaskDefinition("service",
 *     family="service",
 *     container_definitions=std.file(input="task-definitions/service.json").result,
 *     volumes=[{
 *         "name": "service-storage",
 *         "efs_volume_configuration": {
 *             "file_system_id": fs["id"],
 *             "root_directory": "/opt/data",
 *             "transit_encryption": "ENABLED",
 *             "transit_encryption_port": 2999,
 *             "authorization_config": {
 *                 "access_point_id": test["id"],
 *                 "iam": "ENABLED",
 *             },
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new Aws.Ecs.TaskDefinition("service", new()
 *     {
 *         Family = "service",
 *         ContainerDefinitions = Std.File.Invoke(new()
 *         {
 *             Input = "task-definitions/service.json",
 *         }).Apply(invoke => invoke.Result),
 *         Volumes = new[]
 *         {
 *             new Aws.Ecs.Inputs.TaskDefinitionVolumeArgs
 *             {
 *                 Name = "service-storage",
 *                 EfsVolumeConfiguration = new Aws.Ecs.Inputs.TaskDefinitionVolumeEfsVolumeConfigurationArgs
 *                 {
 *                     FileSystemId = fs.Id,
 *                     RootDirectory = "/opt/data",
 *                     TransitEncryption = "ENABLED",
 *                     TransitEncryptionPort = 2999,
 *                     AuthorizationConfig = new Aws.Ecs.Inputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs
 *                     {
 *                         AccessPointId = test.Id,
 *                         Iam = "ENABLED",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "task-definitions/service.json",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewTaskDefinition(ctx, "service", &ecs.TaskDefinitionArgs{
 * 			Family:               pulumi.String("service"),
 * 			ContainerDefinitions: pulumi.String(invokeFile.Result),
 * 			Volumes: ecs.TaskDefinitionVolumeArray{
 * 				&ecs.TaskDefinitionVolumeArgs{
 * 					Name: pulumi.String("service-storage"),
 * 					EfsVolumeConfiguration: &ecs.TaskDefinitionVolumeEfsVolumeConfigurationArgs{
 * 						FileSystemId:          pulumi.Any(fs.Id),
 * 						RootDirectory:         pulumi.String("/opt/data"),
 * 						TransitEncryption:     pulumi.String("ENABLED"),
 * 						TransitEncryptionPort: pulumi.Int(2999),
 * 						AuthorizationConfig: &ecs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs{
 * 							AccessPointId: pulumi.Any(test.Id),
 * 							Iam:           pulumi.String("ENABLED"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(StdFunctions.file(FileArgs.builder()
 *                 .input("task-definitions/service.json")
 *                 .build()).result())
 *             .volumes(TaskDefinitionVolumeArgs.builder()
 *                 .name("service-storage")
 *                 .efsVolumeConfiguration(TaskDefinitionVolumeEfsVolumeConfigurationArgs.builder()
 *                     .fileSystemId(fs.id())
 *                     .rootDirectory("/opt/data")
 *                     .transitEncryption("ENABLED")
 *                     .transitEncryptionPort(2999)
 *                     .authorizationConfig(TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs.builder()
 *                         .accessPointId(test.id())
 *                         .iam("ENABLED")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   service:
 *     type: aws:ecs:TaskDefinition
 *     properties:
 *       family: service
 *       containerDefinitions:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: task-definitions/service.json
 *           Return: result
 *       volumes:
 *         - name: service-storage
 *           efsVolumeConfiguration:
 *             fileSystemId: ${fs.id}
 *             rootDirectory: /opt/data
 *             transitEncryption: ENABLED
 *             transitEncryptionPort: 2999
 *             authorizationConfig:
 *               accessPointId: ${test.id}
 *               iam: ENABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example Using `fsx_windows_file_server_volume_configuration`
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const test = new aws.secretsmanager.SecretVersion("test", {
 *     secretId: testAwsSecretsmanagerSecret.id,
 *     secretString: JSON.stringify({
 *         username: "admin",
 *         password: testAwsDirectoryServiceDirectory.password,
 *     }),
 * });
 * const service = new aws.ecs.TaskDefinition("service", {
 *     family: "service",
 *     containerDefinitions: std.file({
 *         input: "task-definitions/service.json",
 *     }).then(invoke => invoke.result),
 *     volumes: [{
 *         name: "service-storage",
 *         fsxWindowsFileServerVolumeConfiguration: {
 *             fileSystemId: testAwsFsxWindowsFileSystem.id,
 *             rootDirectory: "\\data",
 *             authorizationConfig: {
 *                 credentialsParameter: test.arn,
 *                 domain: testAwsDirectoryServiceDirectory.name,
 *             },
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * import pulumi_std as std
 * test = aws.secretsmanager.SecretVersion("test",
 *     secret_id=test_aws_secretsmanager_secret["id"],
 *     secret_string=json.dumps({
 *         "username": "admin",
 *         "password": test_aws_directory_service_directory["password"],
 *     }))
 * service = aws.ecs.TaskDefinition("service",
 *     family="service",
 *     container_definitions=std.file(input="task-definitions/service.json").result,
 *     volumes=[{
 *         "name": "service-storage",
 *         "fsx_windows_file_server_volume_configuration": {
 *             "file_system_id": test_aws_fsx_windows_file_system["id"],
 *             "root_directory": "\\data",
 *             "authorization_config": {
 *                 "credentials_parameter": test.arn,
 *                 "domain": test_aws_directory_service_directory["name"],
 *             },
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.SecretsManager.SecretVersion("test", new()
 *     {
 *         SecretId = testAwsSecretsmanagerSecret.Id,
 *         SecretString = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["username"] = "admin",
 *             ["password"] = testAwsDirectoryServiceDirectory.Password,
 *         }),
 *     });
 *     var service = new Aws.Ecs.TaskDefinition("service", new()
 *     {
 *         Family = "service",
 *         ContainerDefinitions = Std.File.Invoke(new()
 *         {
 *             Input = "task-definitions/service.json",
 *         }).Apply(invoke => invoke.Result),
 *         Volumes = new[]
 *         {
 *             new Aws.Ecs.Inputs.TaskDefinitionVolumeArgs
 *             {
 *                 Name = "service-storage",
 *                 FsxWindowsFileServerVolumeConfiguration = new Aws.Ecs.Inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs
 *                 {
 *                     FileSystemId = testAwsFsxWindowsFileSystem.Id,
 *                     RootDirectory = "\\data",
 *                     AuthorizationConfig = new Aws.Ecs.Inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs
 *                     {
 *                         CredentialsParameter = test.Arn,
 *                         Domain = testAwsDirectoryServiceDirectory.Name,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/secretsmanager"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"username": "admin",
 * 			"password": testAwsDirectoryServiceDirectory.Password,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		test, err := secretsmanager.NewSecretVersion(ctx, "test", &secretsmanager.SecretVersionArgs{
 * 			SecretId:     pulumi.Any(testAwsSecretsmanagerSecret.Id),
 * 			SecretString: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "task-definitions/service.json",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewTaskDefinition(ctx, "service", &ecs.TaskDefinitionArgs{
 * 			Family:               pulumi.String("service"),
 * 			ContainerDefinitions: pulumi.String(invokeFile.Result),
 * 			Volumes: ecs.TaskDefinitionVolumeArray{
 * 				&ecs.TaskDefinitionVolumeArgs{
 * 					Name: pulumi.String("service-storage"),
 * 					FsxWindowsFileServerVolumeConfiguration: &ecs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs{
 * 						FileSystemId:  pulumi.Any(testAwsFsxWindowsFileSystem.Id),
 * 						RootDirectory: pulumi.String("\\data"),
 * 						AuthorizationConfig: &ecs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs{
 * 							CredentialsParameter: test.Arn,
 * 							Domain:               pulumi.Any(testAwsDirectoryServiceDirectory.Name),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.SecretVersion;
 * import com.pulumi.aws.secretsmanager.SecretVersionArgs;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new SecretVersion("test", SecretVersionArgs.builder()
 *             .secretId(testAwsSecretsmanagerSecret.id())
 *             .secretString(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("username", "admin"),
 *                     jsonProperty("password", testAwsDirectoryServiceDirectory.password())
 *                 )))
 *             .build());
 *         var service = new TaskDefinition("service", TaskDefinitionArgs.builder()
 *             .family("service")
 *             .containerDefinitions(StdFunctions.file(FileArgs.builder()
 *                 .input("task-definitions/service.json")
 *                 .build()).result())
 *             .volumes(TaskDefinitionVolumeArgs.builder()
 *                 .name("service-storage")
 *                 .fsxWindowsFileServerVolumeConfiguration(TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs.builder()
 *                     .fileSystemId(testAwsFsxWindowsFileSystem.id())
 *                     .rootDirectory("\\data")
 *                     .authorizationConfig(TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs.builder()
 *                         .credentialsParameter(test.arn())
 *                         .domain(testAwsDirectoryServiceDirectory.name())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   service:
 *     type: aws:ecs:TaskDefinition
 *     properties:
 *       family: service
 *       containerDefinitions:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: task-definitions/service.json
 *           Return: result
 *       volumes:
 *         - name: service-storage
 *           fsxWindowsFileServerVolumeConfiguration:
 *             fileSystemId: ${testAwsFsxWindowsFileSystem.id}
 *             rootDirectory: \data
 *             authorizationConfig:
 *               credentialsParameter: ${test.arn}
 *               domain: ${testAwsDirectoryServiceDirectory.name}
 *   test:
 *     type: aws:secretsmanager:SecretVersion
 *     properties:
 *       secretId: ${testAwsSecretsmanagerSecret.id}
 *       secretString:
 *         fn::toJSON:
 *           username: admin
 *           password: ${testAwsDirectoryServiceDirectory.password}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example Using `container_definitions` and `inference_accelerator`
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.ecs.TaskDefinition("test", {
 *     family: "test",
 *     containerDefinitions: `[
 *   {
 *     "cpu": 10,
 *     "command": ["sleep", "10"],
 *     "entryPoint": ["/"],
 *     "environment": [
 *       {"name": "VARNAME", "value": "VARVAL"}
 *     ],
 *     "essential": true,
 *     "image": "jenkins",
 *     "memory": 128,
 *     "name": "jenkins",
 *     "portMappings": [
 *       {
 *         "containerPort": 80,
 *         "hostPort": 8080
 *       }
 *     ],
 *         "resourceRequirements":[
 *             {
 *                 "type":"InferenceAccelerator",
 *                 "value":"device_1"
 *             }
 *         ]
 *   }
 * ]
 * `,
 *     inferenceAccelerators: [{
 *         deviceName: "device_1",
 *         deviceType: "eia1.medium",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ecs.TaskDefinition("test",
 *     family="test",
 *     container_definitions="""[
 *   {
 *     "cpu": 10,
 *     "command": ["sleep", "10"],
 *     "entryPoint": ["/"],
 *     "environment": [
 *       {"name": "VARNAME", "value": "VARVAL"}
 *     ],
 *     "essential": true,
 *     "image": "jenkins",
 *     "memory": 128,
 *     "name": "jenkins",
 *     "portMappings": [
 *       {
 *         "containerPort": 80,
 *         "hostPort": 8080
 *       }
 *     ],
 *         "resourceRequirements":[
 *             {
 *                 "type":"InferenceAccelerator",
 *                 "value":"device_1"
 *             }
 *         ]
 *   }
 * ]
 * """,
 *     inference_accelerators=[{
 *         "device_name": "device_1",
 *         "device_type": "eia1.medium",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Ecs.TaskDefinition("test", new()
 *     {
 *         Family = "test",
 *         ContainerDefinitions = @"[
 *   {
 *     ""cpu"": 10,
 *     ""command"": [""sleep"", ""10""],
 *     ""entryPoint"": [""/""],
 *     ""environment"": [
 *       {""name"": ""VARNAME"", ""value"": ""VARVAL""}
 *     ],
 *     ""essential"": true,
 *     ""image"": ""jenkins"",
 *     ""memory"": 128,
 *     ""name"": ""jenkins"",
 *     ""portMappings"": [
 *       {
 *         ""containerPort"": 80,
 *         ""hostPort"": 8080
 *       }
 *     ],
 *         ""resourceRequirements"":[
 *             {
 *                 ""type"":""InferenceAccelerator"",
 *                 ""value"":""device_1""
 *             }
 *         ]
 *   }
 * ]
 * ",
 *         InferenceAccelerators = new[]
 *         {
 *             new Aws.Ecs.Inputs.TaskDefinitionInferenceAcceleratorArgs
 *             {
 *                 DeviceName = "device_1",
 *                 DeviceType = "eia1.medium",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewTaskDefinition(ctx, "test", &ecs.TaskDefinitionArgs{
 * 			Family: pulumi.String("test"),
 * 			ContainerDefinitions: pulumi.String(`[
 *   {
 *     "cpu": 10,
 *     "command": ["sleep", "10"],
 *     "entryPoint": ["/"],
 *     "environment": [
 *       {"name": "VARNAME", "value": "VARVAL"}
 *     ],
 *     "essential": true,
 *     "image": "jenkins",
 *     "memory": 128,
 *     "name": "jenkins",
 *     "portMappings": [
 *       {
 *         "containerPort": 80,
 *         "hostPort": 8080
 *       }
 *     ],
 *         "resourceRequirements":[
 *             {
 *                 "type":"InferenceAccelerator",
 *                 "value":"device_1"
 *             }
 *         ]
 *   }
 * ]
 * `),
 * 			InferenceAccelerators: ecs.TaskDefinitionInferenceAcceleratorArray{
 * 				&ecs.TaskDefinitionInferenceAcceleratorArgs{
 * 					DeviceName: pulumi.String("device_1"),
 * 					DeviceType: pulumi.String("eia1.medium"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionInferenceAcceleratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new TaskDefinition("test", TaskDefinitionArgs.builder()
 *             .family("test")
 *             .containerDefinitions("""
 * [
 *   {
 *     "cpu": 10,
 *     "command": ["sleep", "10"],
 *     "entryPoint": ["/"],
 *     "environment": [
 *       {"name": "VARNAME", "value": "VARVAL"}
 *     ],
 *     "essential": true,
 *     "image": "jenkins",
 *     "memory": 128,
 *     "name": "jenkins",
 *     "portMappings": [
 *       {
 *         "containerPort": 80,
 *         "hostPort": 8080
 *       }
 *     ],
 *         "resourceRequirements":[
 *             {
 *                 "type":"InferenceAccelerator",
 *                 "value":"device_1"
 *             }
 *         ]
 *   }
 * ]
 *             """)
 *             .inferenceAccelerators(TaskDefinitionInferenceAcceleratorArgs.builder()
 *                 .deviceName("device_1")
 *                 .deviceType("eia1.medium")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ecs:TaskDefinition
 *     properties:
 *       family: test
 *       containerDefinitions: |
 *         [
 *           {
 *             "cpu": 10,
 *             "command": ["sleep", "10"],
 *             "entryPoint": ["/"],
 *             "environment": [
 *               {"name": "VARNAME", "value": "VARVAL"}
 *             ],
 *             "essential": true,
 *             "image": "jenkins",
 *             "memory": 128,
 *             "name": "jenkins",
 *             "portMappings": [
 *               {
 *                 "containerPort": 80,
 *                 "hostPort": 8080
 *               }
 *             ],
 *                 "resourceRequirements":[
 *                     {
 *                         "type":"InferenceAccelerator",
 *                         "value":"device_1"
 *                     }
 *                 ]
 *           }
 *         ]
 *       inferenceAccelerators:
 *         - deviceName: device_1
 *           deviceType: eia1.medium
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example Using `runtime_platform` and `fargate`
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.ecs.TaskDefinition("test", {
 *     family: "test",
 *     requiresCompatibilities: ["FARGATE"],
 *     networkMode: "awsvpc",
 *     cpu: "1024",
 *     memory: "2048",
 *     containerDefinitions: `[
 *   {
 *     "name": "iis",
 *     "image": "mcr.microsoft.com/windows/servercore/iis",
 *     "cpu": 1024,
 *     "memory": 2048,
 *     "essential": true
 *   }
 * ]
 * `,
 *     runtimePlatform: {
 *         operatingSystemFamily: "WINDOWS_SERVER_2019_CORE",
 *         cpuArchitecture: "X86_64",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ecs.TaskDefinition("test",
 *     family="test",
 *     requires_compatibilities=["FARGATE"],
 *     network_mode="awsvpc",
 *     cpu="1024",
 *     memory="2048",
 *     container_definitions="""[
 *   {
 *     "name": "iis",
 *     "image": "mcr.microsoft.com/windows/servercore/iis",
 *     "cpu": 1024,
 *     "memory": 2048,
 *     "essential": true
 *   }
 * ]
 * """,
 *     runtime_platform={
 *         "operating_system_family": "WINDOWS_SERVER_2019_CORE",
 *         "cpu_architecture": "X86_64",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Ecs.TaskDefinition("test", new()
 *     {
 *         Family = "test",
 *         RequiresCompatibilities = new[]
 *         {
 *             "FARGATE",
 *         },
 *         NetworkMode = "awsvpc",
 *         Cpu = "1024",
 *         Memory = "2048",
 *         ContainerDefinitions = @"[
 *   {
 *     ""name"": ""iis"",
 *     ""image"": ""mcr.microsoft.com/windows/servercore/iis"",
 *     ""cpu"": 1024,
 *     ""memory"": 2048,
 *     ""essential"": true
 *   }
 * ]
 * ",
 *         RuntimePlatform = new Aws.Ecs.Inputs.TaskDefinitionRuntimePlatformArgs
 *         {
 *             OperatingSystemFamily = "WINDOWS_SERVER_2019_CORE",
 *             CpuArchitecture = "X86_64",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewTaskDefinition(ctx, "test", &ecs.TaskDefinitionArgs{
 * 			Family: pulumi.String("test"),
 * 			RequiresCompatibilities: pulumi.StringArray{
 * 				pulumi.String("FARGATE"),
 * 			},
 * 			NetworkMode: pulumi.String("awsvpc"),
 * 			Cpu:         pulumi.String("1024"),
 * 			Memory:      pulumi.String("2048"),
 * 			ContainerDefinitions: pulumi.String(`[
 *   {
 *     "name": "iis",
 *     "image": "mcr.microsoft.com/windows/servercore/iis",
 *     "cpu": 1024,
 *     "memory": 2048,
 *     "essential": true
 *   }
 * ]
 * `),
 * 			RuntimePlatform: &ecs.TaskDefinitionRuntimePlatformArgs{
 * 				OperatingSystemFamily: pulumi.String("WINDOWS_SERVER_2019_CORE"),
 * 				CpuArchitecture:       pulumi.String("X86_64"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskDefinition;
 * import com.pulumi.aws.ecs.TaskDefinitionArgs;
 * import com.pulumi.aws.ecs.inputs.TaskDefinitionRuntimePlatformArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new TaskDefinition("test", TaskDefinitionArgs.builder()
 *             .family("test")
 *             .requiresCompatibilities("FARGATE")
 *             .networkMode("awsvpc")
 *             .cpu(1024)
 *             .memory(2048)
 *             .containerDefinitions("""
 * [
 *   {
 *     "name": "iis",
 *     "image": "mcr.microsoft.com/windows/servercore/iis",
 *     "cpu": 1024,
 *     "memory": 2048,
 *     "essential": true
 *   }
 * ]
 *             """)
 *             .runtimePlatform(TaskDefinitionRuntimePlatformArgs.builder()
 *                 .operatingSystemFamily("WINDOWS_SERVER_2019_CORE")
 *                 .cpuArchitecture("X86_64")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ecs:TaskDefinition
 *     properties:
 *       family: test
 *       requiresCompatibilities:
 *         - FARGATE
 *       networkMode: awsvpc
 *       cpu: 1024
 *       memory: 2048
 *       containerDefinitions: |
 *         [
 *           {
 *             "name": "iis",
 *             "image": "mcr.microsoft.com/windows/servercore/iis",
 *             "cpu": 1024,
 *             "memory": 2048,
 *             "essential": true
 *           }
 *         ]
 *       runtimePlatform:
 *         operatingSystemFamily: WINDOWS_SERVER_2019_CORE
 *         cpuArchitecture: X86_64
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECS Task Definitions using their ARNs. For example:
 * ```sh
 * $ pulumi import aws:ecs/taskDefinition:TaskDefinition example arn:aws:ecs:us-east-1:012345678910:task-definition/mytaskfamily:123
 * ```
 */
public class TaskDefinition internal constructor(
    override val javaResource: com.pulumi.aws.ecs.TaskDefinition,
) : KotlinCustomResource(javaResource, TaskDefinitionMapper) {
    /**
     * Full ARN of the Task Definition (including both `family` and `revision`).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ARN of the Task Definition with the trailing `revision` removed. This may be useful for situations where the latest task definition is always desired. If a revision isn't specified, the latest ACTIVE revision is used. See the [AWS documentation](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_StartTask.html#ECS-StartTask-request-taskDefinition) for details.
     */
    public val arnWithoutRevision: Output<String>
        get() = javaResource.arnWithoutRevision().applyValue({ args0 -> args0 })

    /**
     * A list of valid [container definitions](http://docs&#46;aws&#46;amazon&#46;com/AmazonECS/latest/APIReference/API_ContainerDefinition&#46;html) provided as a single valid JSON document&#46; Please note that you should only provide values that are part of the container definition document&#46; For a detailed description of what parameters are available, see the [Task Definition Parameters](https://docs&#46;aws&#46;amazon&#46;com/AmazonECS/latest/developerguide/task_definition_parameters&#46;html) section from the official [Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide).
     */
    public val containerDefinitions: Output<String>
        get() = javaResource.containerDefinitions().applyValue({ args0 -> args0 })

    /**
     * Number of cpu units used by the task. If the `requires_compatibilities` is `FARGATE` this field is required.
     */
    public val cpu: Output<String>?
        get() = javaResource.cpu().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
     */
    public val ephemeralStorage: Output<TaskDefinitionEphemeralStorage>?
        get() = javaResource.ephemeralStorage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> taskDefinitionEphemeralStorageToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * ARN of the task execution role that the Amazon ECS container agent and the Docker daemon can assume.
     */
    public val executionRoleArn: Output<String>?
        get() = javaResource.executionRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique name for your task definition.
     * The following arguments are optional:
     */
    public val family: Output<String>
        get() = javaResource.family().applyValue({ args0 -> args0 })

    /**
     * Configuration block(s) with Inference Accelerators settings. Detailed below.
     */
    public val inferenceAccelerators: Output<List<TaskDefinitionInferenceAccelerator>>?
        get() = javaResource.inferenceAccelerators().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        taskDefinitionInferenceAcceleratorToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
     */
    public val ipcMode: Output<String>?
        get() = javaResource.ipcMode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Amount (in MiB) of memory used by the task. If the `requires_compatibilities` is `FARGATE` this field is required.
     */
    public val memory: Output<String>?
        get() = javaResource.memory().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Docker networking mode to use for the containers in the task. Valid values are `none`, `bridge`, `awsvpc`, and `host`.
     */
    public val networkMode: Output<String>
        get() = javaResource.networkMode().applyValue({ args0 -> args0 })

    /**
     * Process namespace to use for the containers in the task. The valid values are `host` and `task`.
     */
    public val pidMode: Output<String>?
        get() = javaResource.pidMode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
     */
    public val placementConstraints: Output<List<TaskDefinitionPlacementConstraint>>?
        get() = javaResource.placementConstraints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        taskDefinitionPlacementConstraintToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block for the App Mesh proxy. Detailed below.
     */
    public val proxyConfiguration: Output<TaskDefinitionProxyConfiguration>?
        get() = javaResource.proxyConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> taskDefinitionProxyConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Set of launch types required by the task. The valid values are `EC2` and `FARGATE`.
     */
    public val requiresCompatibilities: Output<List<String>>?
        get() = javaResource.requiresCompatibilities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Revision of the task in a particular family.
     */
    public val revision: Output<Int>
        get() = javaResource.revision().applyValue({ args0 -> args0 })

    /**
     * Configuration block for runtime_platform that containers in your task may use.
     */
    public val runtimePlatform: Output<TaskDefinitionRuntimePlatform>?
        get() = javaResource.runtimePlatform().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> taskDefinitionRuntimePlatformToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
     */
    public val skipDestroy: Output<Boolean>?
        get() = javaResource.skipDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * ARN of IAM role that allows your Amazon ECS container task to make calls to other AWS services.
     */
    public val taskRoleArn: Output<String>?
        get() = javaResource.taskRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether should track latest `ACTIVE` task definition on AWS or the one created with the resource stored in state. Default is `false`. Useful in the event the task definition is modified outside of this resource.
     */
    public val trackLatest: Output<Boolean>?
        get() = javaResource.trackLatest().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for volumes that containers in your task may use. Detailed below.
     */
    public val volumes: Output<List<TaskDefinitionVolume>>?
        get() = javaResource.volumes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> taskDefinitionVolumeToKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object TaskDefinitionMapper : ResourceMapper<TaskDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecs.TaskDefinition::class == javaResource::class

    override fun map(javaResource: Resource): TaskDefinition = TaskDefinition(
        javaResource as
            com.pulumi.aws.ecs.TaskDefinition,
    )
}

/**
 * @see [TaskDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TaskDefinition].
 */
public suspend fun taskDefinition(
    name: String,
    block: suspend TaskDefinitionResourceBuilder.() -> Unit,
): TaskDefinition {
    val builder = TaskDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TaskDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun taskDefinition(name: String): TaskDefinition {
    val builder = TaskDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
