@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin

import com.pulumi.aws.ecs.TaskSetArgs.builder
import com.pulumi.aws.ecs.kotlin.inputs.TaskSetCapacityProviderStrategyArgs
import com.pulumi.aws.ecs.kotlin.inputs.TaskSetCapacityProviderStrategyArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.TaskSetLoadBalancerArgs
import com.pulumi.aws.ecs.kotlin.inputs.TaskSetLoadBalancerArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.TaskSetNetworkConfigurationArgs
import com.pulumi.aws.ecs.kotlin.inputs.TaskSetNetworkConfigurationArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.TaskSetScaleArgs
import com.pulumi.aws.ecs.kotlin.inputs.TaskSetScaleArgsBuilder
import com.pulumi.aws.ecs.kotlin.inputs.TaskSetServiceRegistriesArgs
import com.pulumi.aws.ecs.kotlin.inputs.TaskSetServiceRegistriesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ECS task set - effectively a task that is expected to run until an error occurs or a user terminates it (typically a webserver or a database).
 * See [ECS Task Set section in AWS developer guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-external.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecs.TaskSet("example", {
 *     service: exampleAwsEcsService.id,
 *     cluster: exampleAwsEcsCluster.id,
 *     taskDefinition: exampleAwsEcsTaskDefinition.arn,
 *     loadBalancers: [{
 *         targetGroupArn: exampleAwsLbTargetGroup.arn,
 *         containerName: "mongo",
 *         containerPort: 8080,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecs.TaskSet("example",
 *     service=example_aws_ecs_service["id"],
 *     cluster=example_aws_ecs_cluster["id"],
 *     task_definition=example_aws_ecs_task_definition["arn"],
 *     load_balancers=[{
 *         "target_group_arn": example_aws_lb_target_group["arn"],
 *         "container_name": "mongo",
 *         "container_port": 8080,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecs.TaskSet("example", new()
 *     {
 *         Service = exampleAwsEcsService.Id,
 *         Cluster = exampleAwsEcsCluster.Id,
 *         TaskDefinition = exampleAwsEcsTaskDefinition.Arn,
 *         LoadBalancers = new[]
 *         {
 *             new Aws.Ecs.Inputs.TaskSetLoadBalancerArgs
 *             {
 *                 TargetGroupArn = exampleAwsLbTargetGroup.Arn,
 *                 ContainerName = "mongo",
 *                 ContainerPort = 8080,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewTaskSet(ctx, "example", &ecs.TaskSetArgs{
 * 			Service:        pulumi.Any(exampleAwsEcsService.Id),
 * 			Cluster:        pulumi.Any(exampleAwsEcsCluster.Id),
 * 			TaskDefinition: pulumi.Any(exampleAwsEcsTaskDefinition.Arn),
 * 			LoadBalancers: ecs.TaskSetLoadBalancerArray{
 * 				&ecs.TaskSetLoadBalancerArgs{
 * 					TargetGroupArn: pulumi.Any(exampleAwsLbTargetGroup.Arn),
 * 					ContainerName:  pulumi.String("mongo"),
 * 					ContainerPort:  pulumi.Int(8080),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskSet;
 * import com.pulumi.aws.ecs.TaskSetArgs;
 * import com.pulumi.aws.ecs.inputs.TaskSetLoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TaskSet("example", TaskSetArgs.builder()
 *             .service(exampleAwsEcsService.id())
 *             .cluster(exampleAwsEcsCluster.id())
 *             .taskDefinition(exampleAwsEcsTaskDefinition.arn())
 *             .loadBalancers(TaskSetLoadBalancerArgs.builder()
 *                 .targetGroupArn(exampleAwsLbTargetGroup.arn())
 *                 .containerName("mongo")
 *                 .containerPort(8080)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecs:TaskSet
 *     properties:
 *       service: ${exampleAwsEcsService.id}
 *       cluster: ${exampleAwsEcsCluster.id}
 *       taskDefinition: ${exampleAwsEcsTaskDefinition.arn}
 *       loadBalancers:
 *         - targetGroupArn: ${exampleAwsLbTargetGroup.arn}
 *           containerName: mongo
 *           containerPort: 8080
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Ignoring Changes to Scale
 * You can utilize the generic resource lifecycle configuration block with `ignore_changes` to create an ECS service with an initial count of running instances, then ignore any changes to that count caused externally (e.g. Application Autoscaling).
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ecs.TaskSet("example", {scale: {
 *     value: 50,
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ecs.TaskSet("example", scale={
 *     "value": 50,
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ecs.TaskSet("example", new()
 *     {
 *         Scale = new Aws.Ecs.Inputs.TaskSetScaleArgs
 *         {
 *             Value = 50,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewTaskSet(ctx, "example", &ecs.TaskSetArgs{
 * 			Scale: &ecs.TaskSetScaleArgs{
 * 				Value: pulumi.Float64(50),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.TaskSet;
 * import com.pulumi.aws.ecs.TaskSetArgs;
 * import com.pulumi.aws.ecs.inputs.TaskSetScaleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TaskSet("example", TaskSetArgs.builder()
 *             .scale(TaskSetScaleArgs.builder()
 *                 .value(50)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ecs:TaskSet
 *     properties:
 *       scale:
 *         value: 50
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ECS Task Sets using the `task_set_id`, `service`, and `cluster` separated by commas (`,`). For example:
 * ```sh
 * $ pulumi import aws:ecs/taskSet:TaskSet example ecs-svc/7177320696926227436,arn:aws:ecs:us-west-2:123456789101:service/example/example-1234567890,arn:aws:ecs:us-west-2:123456789101:cluster/example
 * ```
 * @property capacityProviderStrategies The capacity provider strategy to use for the service. Can be one or more.  Defined below.
 * @property cluster The short name or ARN of the cluster that hosts the service to create the task set in.
 * @property externalId The external ID associated with the task set.
 * @property forceDelete Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it's in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
 * @property launchType The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
 * @property loadBalancers Details on load balancers that are used with a task set. Detailed below.
 * @property networkConfiguration The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
 * @property platformVersion The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
 * @property scale A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
 * @property service The short name or ARN of the ECS service.
 * @property serviceRegistries The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
 * @property tags A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
 * @property taskDefinition The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.
 * The following arguments are optional:
 * @property waitUntilStable Whether the provider should wait until the task set has reached `STEADY_STATE`.
 * @property waitUntilStableTimeout Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
 */
public data class TaskSetArgs(
    public val capacityProviderStrategies: Output<List<TaskSetCapacityProviderStrategyArgs>>? = null,
    public val cluster: Output<String>? = null,
    public val externalId: Output<String>? = null,
    public val forceDelete: Output<Boolean>? = null,
    public val launchType: Output<String>? = null,
    public val loadBalancers: Output<List<TaskSetLoadBalancerArgs>>? = null,
    public val networkConfiguration: Output<TaskSetNetworkConfigurationArgs>? = null,
    public val platformVersion: Output<String>? = null,
    public val scale: Output<TaskSetScaleArgs>? = null,
    public val service: Output<String>? = null,
    public val serviceRegistries: Output<TaskSetServiceRegistriesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taskDefinition: Output<String>? = null,
    public val waitUntilStable: Output<Boolean>? = null,
    public val waitUntilStableTimeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.TaskSetArgs> {
    override fun toJava(): com.pulumi.aws.ecs.TaskSetArgs = com.pulumi.aws.ecs.TaskSetArgs.builder()
        .capacityProviderStrategies(
            capacityProviderStrategies?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .cluster(cluster?.applyValue({ args0 -> args0 }))
        .externalId(externalId?.applyValue({ args0 -> args0 }))
        .forceDelete(forceDelete?.applyValue({ args0 -> args0 }))
        .launchType(launchType?.applyValue({ args0 -> args0 }))
        .loadBalancers(
            loadBalancers?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .networkConfiguration(
            networkConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .platformVersion(platformVersion?.applyValue({ args0 -> args0 }))
        .scale(scale?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .service(service?.applyValue({ args0 -> args0 }))
        .serviceRegistries(serviceRegistries?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .taskDefinition(taskDefinition?.applyValue({ args0 -> args0 }))
        .waitUntilStable(waitUntilStable?.applyValue({ args0 -> args0 }))
        .waitUntilStableTimeout(waitUntilStableTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskSetArgs].
 */
@PulumiTagMarker
public class TaskSetArgsBuilder internal constructor() {
    private var capacityProviderStrategies: Output<List<TaskSetCapacityProviderStrategyArgs>>? = null

    private var cluster: Output<String>? = null

    private var externalId: Output<String>? = null

    private var forceDelete: Output<Boolean>? = null

    private var launchType: Output<String>? = null

    private var loadBalancers: Output<List<TaskSetLoadBalancerArgs>>? = null

    private var networkConfiguration: Output<TaskSetNetworkConfigurationArgs>? = null

    private var platformVersion: Output<String>? = null

    private var scale: Output<TaskSetScaleArgs>? = null

    private var service: Output<String>? = null

    private var serviceRegistries: Output<TaskSetServiceRegistriesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taskDefinition: Output<String>? = null

    private var waitUntilStable: Output<Boolean>? = null

    private var waitUntilStableTimeout: Output<String>? = null

    /**
     * @param value The capacity provider strategy to use for the service. Can be one or more.  Defined below.
     */
    @JvmName("xuwkywljxjhgxodv")
    public suspend fun capacityProviderStrategies(`value`: Output<List<TaskSetCapacityProviderStrategyArgs>>) {
        this.capacityProviderStrategies = value
    }

    @JvmName("haaqjugrmghnpswx")
    public suspend fun capacityProviderStrategies(vararg values: Output<TaskSetCapacityProviderStrategyArgs>) {
        this.capacityProviderStrategies = Output.all(values.asList())
    }

    /**
     * @param values The capacity provider strategy to use for the service. Can be one or more.  Defined below.
     */
    @JvmName("iojpxfbpmvygaosj")
    public suspend fun capacityProviderStrategies(values: List<Output<TaskSetCapacityProviderStrategyArgs>>) {
        this.capacityProviderStrategies = Output.all(values)
    }

    /**
     * @param value The short name or ARN of the cluster that hosts the service to create the task set in.
     */
    @JvmName("mnkwqhibiprvkbsu")
    public suspend fun cluster(`value`: Output<String>) {
        this.cluster = value
    }

    /**
     * @param value The external ID associated with the task set.
     */
    @JvmName("sdhiookewuolyxfj")
    public suspend fun externalId(`value`: Output<String>) {
        this.externalId = value
    }

    /**
     * @param value Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it's in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
     */
    @JvmName("wlrwsdcuxewqljvj")
    public suspend fun forceDelete(`value`: Output<Boolean>) {
        this.forceDelete = value
    }

    /**
     * @param value The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
     */
    @JvmName("dkhlexchxgiwdugi")
    public suspend fun launchType(`value`: Output<String>) {
        this.launchType = value
    }

    /**
     * @param value Details on load balancers that are used with a task set. Detailed below.
     */
    @JvmName("cptpowbwnywifwba")
    public suspend fun loadBalancers(`value`: Output<List<TaskSetLoadBalancerArgs>>) {
        this.loadBalancers = value
    }

    @JvmName("qaodkbhihyjuvwge")
    public suspend fun loadBalancers(vararg values: Output<TaskSetLoadBalancerArgs>) {
        this.loadBalancers = Output.all(values.asList())
    }

    /**
     * @param values Details on load balancers that are used with a task set. Detailed below.
     */
    @JvmName("nwjkdyonjacolqys")
    public suspend fun loadBalancers(values: List<Output<TaskSetLoadBalancerArgs>>) {
        this.loadBalancers = Output.all(values)
    }

    /**
     * @param value The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
     */
    @JvmName("heigudkrfupygujn")
    public suspend fun networkConfiguration(`value`: Output<TaskSetNetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
     */
    @JvmName("ufatukxatgdwbhif")
    public suspend fun platformVersion(`value`: Output<String>) {
        this.platformVersion = value
    }

    /**
     * @param value A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
     */
    @JvmName("qcwiscveurgykpeq")
    public suspend fun scale(`value`: Output<TaskSetScaleArgs>) {
        this.scale = value
    }

    /**
     * @param value The short name or ARN of the ECS service.
     */
    @JvmName("rolwvgsgjeintgoa")
    public suspend fun service(`value`: Output<String>) {
        this.service = value
    }

    /**
     * @param value The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
     */
    @JvmName("gjkkqurwfpbbptgy")
    public suspend fun serviceRegistries(`value`: Output<TaskSetServiceRegistriesArgs>) {
        this.serviceRegistries = value
    }

    /**
     * @param value A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
     */
    @JvmName("nltcdlnrvfceggxj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.
     * The following arguments are optional:
     */
    @JvmName("aegoemrkummxgtxt")
    public suspend fun taskDefinition(`value`: Output<String>) {
        this.taskDefinition = value
    }

    /**
     * @param value Whether the provider should wait until the task set has reached `STEADY_STATE`.
     */
    @JvmName("qxogekvefycfuewy")
    public suspend fun waitUntilStable(`value`: Output<Boolean>) {
        this.waitUntilStable = value
    }

    /**
     * @param value Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
     */
    @JvmName("yfmokhcesjwnsxtj")
    public suspend fun waitUntilStableTimeout(`value`: Output<String>) {
        this.waitUntilStableTimeout = value
    }

    /**
     * @param value The capacity provider strategy to use for the service. Can be one or more.  Defined below.
     */
    @JvmName("ffwaqvkuymjftxpo")
    public suspend fun capacityProviderStrategies(`value`: List<TaskSetCapacityProviderStrategyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument The capacity provider strategy to use for the service. Can be one or more.  Defined below.
     */
    @JvmName("egkuaplybjqugctm")
    public suspend fun capacityProviderStrategies(argument: List<suspend TaskSetCapacityProviderStrategyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TaskSetCapacityProviderStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument The capacity provider strategy to use for the service. Can be one or more.  Defined below.
     */
    @JvmName("qlfgfdoncormrspr")
    public suspend fun capacityProviderStrategies(vararg argument: suspend TaskSetCapacityProviderStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TaskSetCapacityProviderStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument The capacity provider strategy to use for the service. Can be one or more.  Defined below.
     */
    @JvmName("qdprifeqoybashuu")
    public suspend fun capacityProviderStrategies(argument: suspend TaskSetCapacityProviderStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TaskSetCapacityProviderStrategyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param values The capacity provider strategy to use for the service. Can be one or more.  Defined below.
     */
    @JvmName("eaarntgulyqyovcg")
    public suspend fun capacityProviderStrategies(vararg values: TaskSetCapacityProviderStrategyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param value The short name or ARN of the cluster that hosts the service to create the task set in.
     */
    @JvmName("iutvreotkdadbyhi")
    public suspend fun cluster(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cluster = mapped
    }

    /**
     * @param value The external ID associated with the task set.
     */
    @JvmName("oujtwrpiabekjghx")
    public suspend fun externalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalId = mapped
    }

    /**
     * @param value Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it's in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
     */
    @JvmName("vuqpxyotpxyvnqly")
    public suspend fun forceDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDelete = mapped
    }

    /**
     * @param value The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
     */
    @JvmName("ngdhlnqcbcgidvao")
    public suspend fun launchType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchType = mapped
    }

    /**
     * @param value Details on load balancers that are used with a task set. Detailed below.
     */
    @JvmName("qcjnyrcrnamxoops")
    public suspend fun loadBalancers(`value`: List<TaskSetLoadBalancerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancers = mapped
    }

    /**
     * @param argument Details on load balancers that are used with a task set. Detailed below.
     */
    @JvmName("acfjseqdyodxrgvt")
    public suspend fun loadBalancers(argument: List<suspend TaskSetLoadBalancerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TaskSetLoadBalancerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancers = mapped
    }

    /**
     * @param argument Details on load balancers that are used with a task set. Detailed below.
     */
    @JvmName("amfjfiyfxiqckjbl")
    public suspend fun loadBalancers(vararg argument: suspend TaskSetLoadBalancerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TaskSetLoadBalancerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancers = mapped
    }

    /**
     * @param argument Details on load balancers that are used with a task set. Detailed below.
     */
    @JvmName("sckrvostkduxosmr")
    public suspend fun loadBalancers(argument: suspend TaskSetLoadBalancerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TaskSetLoadBalancerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loadBalancers = mapped
    }

    /**
     * @param values Details on load balancers that are used with a task set. Detailed below.
     */
    @JvmName("caujnbolaqaggdpa")
    public suspend fun loadBalancers(vararg values: TaskSetLoadBalancerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancers = mapped
    }

    /**
     * @param value The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
     */
    @JvmName("bygcbnasinhagrus")
    public suspend fun networkConfiguration(`value`: TaskSetNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
     */
    @JvmName("npmykpidjtvmvbhm")
    public suspend fun networkConfiguration(argument: suspend TaskSetNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = TaskSetNetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
     */
    @JvmName("dbavhqmyonhkmmbr")
    public suspend fun platformVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformVersion = mapped
    }

    /**
     * @param value A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
     */
    @JvmName("bdgneximjxendbwe")
    public suspend fun scale(`value`: TaskSetScaleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scale = mapped
    }

    /**
     * @param argument A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
     */
    @JvmName("abejxltnvhberssg")
    public suspend fun scale(argument: suspend TaskSetScaleArgsBuilder.() -> Unit) {
        val toBeMapped = TaskSetScaleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scale = mapped
    }

    /**
     * @param value The short name or ARN of the ECS service.
     */
    @JvmName("olnxdtpuweigsskq")
    public suspend fun service(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.service = mapped
    }

    /**
     * @param value The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
     */
    @JvmName("lquximkgjsoqlkrs")
    public suspend fun serviceRegistries(`value`: TaskSetServiceRegistriesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRegistries = mapped
    }

    /**
     * @param argument The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
     */
    @JvmName("uradcmgctlcnqpas")
    public suspend fun serviceRegistries(argument: suspend TaskSetServiceRegistriesArgsBuilder.() -> Unit) {
        val toBeMapped = TaskSetServiceRegistriesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceRegistries = mapped
    }

    /**
     * @param value A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
     */
    @JvmName("utpkbhbfhhcrnjmp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
     */
    @JvmName("bjmohsglaivurgkj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.
     * The following arguments are optional:
     */
    @JvmName("lpgoskctmywlrfmj")
    public suspend fun taskDefinition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskDefinition = mapped
    }

    /**
     * @param value Whether the provider should wait until the task set has reached `STEADY_STATE`.
     */
    @JvmName("hurcxloxqsjipyii")
    public suspend fun waitUntilStable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitUntilStable = mapped
    }

    /**
     * @param value Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
     */
    @JvmName("updrwnywjhoeasuk")
    public suspend fun waitUntilStableTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitUntilStableTimeout = mapped
    }

    internal fun build(): TaskSetArgs = TaskSetArgs(
        capacityProviderStrategies = capacityProviderStrategies,
        cluster = cluster,
        externalId = externalId,
        forceDelete = forceDelete,
        launchType = launchType,
        loadBalancers = loadBalancers,
        networkConfiguration = networkConfiguration,
        platformVersion = platformVersion,
        scale = scale,
        service = service,
        serviceRegistries = serviceRegistries,
        tags = tags,
        taskDefinition = taskDefinition,
        waitUntilStable = waitUntilStable,
        waitUntilStableTimeout = waitUntilStableTimeout,
    )
}
