@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.CapacityProviderAutoScalingGroupProviderManagedScalingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceWarmupPeriod Period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value of 300 seconds is used.
 * @property maximumScalingStepSize Maximum step adjustment size. A number between 1 and 10,000.
 * @property minimumScalingStepSize Minimum step adjustment size. A number between 1 and 10,000.
 * @property status Whether auto scaling is managed by ECS. Valid values are `ENABLED` and `DISABLED`.
 * @property targetCapacity Target utilization for the capacity provider. A number between 1 and 100.
 */
public data class CapacityProviderAutoScalingGroupProviderManagedScalingArgs(
    public val instanceWarmupPeriod: Output<Int>? = null,
    public val maximumScalingStepSize: Output<Int>? = null,
    public val minimumScalingStepSize: Output<Int>? = null,
    public val status: Output<String>? = null,
    public val targetCapacity: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ecs.inputs.CapacityProviderAutoScalingGroupProviderManagedScalingArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.CapacityProviderAutoScalingGroupProviderManagedScalingArgs =
        com.pulumi.aws.ecs.inputs.CapacityProviderAutoScalingGroupProviderManagedScalingArgs.builder()
            .instanceWarmupPeriod(instanceWarmupPeriod?.applyValue({ args0 -> args0 }))
            .maximumScalingStepSize(maximumScalingStepSize?.applyValue({ args0 -> args0 }))
            .minimumScalingStepSize(minimumScalingStepSize?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .targetCapacity(targetCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CapacityProviderAutoScalingGroupProviderManagedScalingArgs].
 */
@PulumiTagMarker
public class CapacityProviderAutoScalingGroupProviderManagedScalingArgsBuilder internal constructor() {
    private var instanceWarmupPeriod: Output<Int>? = null

    private var maximumScalingStepSize: Output<Int>? = null

    private var minimumScalingStepSize: Output<Int>? = null

    private var status: Output<String>? = null

    private var targetCapacity: Output<Int>? = null

    /**
     * @param value Period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value of 300 seconds is used.
     */
    @JvmName("rkhjibbrhylpljbq")
    public suspend fun instanceWarmupPeriod(`value`: Output<Int>) {
        this.instanceWarmupPeriod = value
    }

    /**
     * @param value Maximum step adjustment size. A number between 1 and 10,000.
     */
    @JvmName("koarqijtxvfqdbri")
    public suspend fun maximumScalingStepSize(`value`: Output<Int>) {
        this.maximumScalingStepSize = value
    }

    /**
     * @param value Minimum step adjustment size. A number between 1 and 10,000.
     */
    @JvmName("qryujflapqbwjhsk")
    public suspend fun minimumScalingStepSize(`value`: Output<Int>) {
        this.minimumScalingStepSize = value
    }

    /**
     * @param value Whether auto scaling is managed by ECS. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("digvjnungwnpucdc")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Target utilization for the capacity provider. A number between 1 and 100.
     */
    @JvmName("vpmkgnxknlemhrio")
    public suspend fun targetCapacity(`value`: Output<Int>) {
        this.targetCapacity = value
    }

    /**
     * @param value Period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value of 300 seconds is used.
     */
    @JvmName("gfgwvblgjjgnhhic")
    public suspend fun instanceWarmupPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceWarmupPeriod = mapped
    }

    /**
     * @param value Maximum step adjustment size. A number between 1 and 10,000.
     */
    @JvmName("cjgkcakiqhmbhuvv")
    public suspend fun maximumScalingStepSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumScalingStepSize = mapped
    }

    /**
     * @param value Minimum step adjustment size. A number between 1 and 10,000.
     */
    @JvmName("aawpxadwcklsqkdf")
    public suspend fun minimumScalingStepSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumScalingStepSize = mapped
    }

    /**
     * @param value Whether auto scaling is managed by ECS. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("tnvgfbyokkvdcfga")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Target utilization for the capacity provider. A number between 1 and 100.
     */
    @JvmName("fbdvssrbyjudjvkb")
    public suspend fun targetCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetCapacity = mapped
    }

    internal fun build(): CapacityProviderAutoScalingGroupProviderManagedScalingArgs =
        CapacityProviderAutoScalingGroupProviderManagedScalingArgs(
            instanceWarmupPeriod = instanceWarmupPeriod,
            maximumScalingStepSize = maximumScalingStepSize,
            minimumScalingStepSize = minimumScalingStepSize,
            status = status,
            targetCapacity = targetCapacity,
        )
}
